/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client.settings;

import com.google.common.base.Charsets;
import com.google.common.base.Splitter;
import com.mrcrayfish.controllable.Controllable;
import com.mrcrayfish.controllable.client.ControllerType;
import com.mrcrayfish.controllable.client.CursorType;
import com.mrcrayfish.controllable.client.settings.ControllableBooleanOption;
import com.mrcrayfish.controllable.client.settings.ControllableEnumOption;
import com.mrcrayfish.controllable.client.settings.ControllableSliderPercentageOption;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.GameSettings;
import net.minecraft.client.settings.BooleanOption;
import net.minecraft.client.settings.SliderPercentageOption;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.io.IOUtils;

public class ControllerOptions {
    private static final DecimalFormat FORMAT = new DecimalFormat("0.0#");
    public static final BooleanOption FORCE_FEEDBACK = new ControllableBooleanOption("controllable.options.forceFeedback", gameSettings -> Controllable.getOptions().forceFeedback, (gameSettings, value) -> {
        Controllable.getOptions().forceFeedback = value;
    });
    public static final BooleanOption AUTO_SELECT = new ControllableBooleanOption("controllable.options.autoSelect", gameSettings -> Controllable.getOptions().autoSelect, (gameSettings, value) -> {
        Controllable.getOptions().autoSelect = value;
    });
    public static final BooleanOption RENDER_MINI_PLAYER = new ControllableBooleanOption("controllable.options.renderMiniPlayer", gameSettings -> Controllable.getOptions().renderMiniPlayer, (gameSettings, value) -> {
        Controllable.getOptions().renderMiniPlayer = value;
    });
    public static final BooleanOption VIRTUAL_MOUSE = new ControllableBooleanOption("controllable.options.virtualMouse", gameSettings -> Controllable.getOptions().virtualMouse, (gameSettings, value) -> {
        Controllable.getOptions().virtualMouse = value;
    });
    public static final BooleanOption CONSOLE_HOTBAR = new ControllableBooleanOption("controllable.options.consoleHotbar", gameSettings -> Controllable.getOptions().consoleHotbar, (gameSettings, value) -> {
        Controllable.getOptions().consoleHotbar = value;
    });
    public static final ControllableEnumOption<CursorType> CURSOR_TYPE = new ControllableEnumOption<CursorType>("controllable.options.cursorType", CursorType.class, gameSettings -> Controllable.getOptions().cursorType, (gameSettings, cursorType) -> {
        Controllable.getOptions().cursorType = cursorType;
    }, (gameSettings, controllableEnumOption) -> {
        CursorType cursorType = (CursorType)((Object)((Object)controllableEnumOption.get((GameSettings)gameSettings)));
        return new TranslationTextComponent("controllable.cursor." + cursorType.func_176610_l());
    });
    public static final ControllableEnumOption<ControllerType> CONTROLLER_TYPE = new ControllableEnumOption<ControllerType>("controllable.options.controllerType", ControllerType.class, gameSettings -> Controllable.getOptions().controllerType, (gameSettings, controllerType) -> {
        Controllable.getOptions().controllerType = controllerType;
    }, (gameSettings, controllableEnumOption) -> {
        ControllerType controllerType = (ControllerType)((Object)((Object)controllableEnumOption.get((GameSettings)gameSettings)));
        return new TranslationTextComponent("controllable.controller." + controllerType.func_176610_l());
    });
    public static final BooleanOption INVERT_LOOK = new ControllableBooleanOption("controllable.options.invertLook", gameSettings -> Controllable.getOptions().invertLook, (gameSettings, value) -> {
        Controllable.getOptions().invertLook = value;
    });
    public static final SliderPercentageOption DEAD_ZONE = new ControllableSliderPercentageOption("controllable.options.deadZone", 0.0, 1.0, 0.01f, gameSettings -> Controllable.getOptions().deadZone, (gameSettings, value) -> {
        Controllable.getOptions().deadZone = MathHelper.func_151237_a((double)value, (double)0.0, (double)1.0);
    }, (gameSettings, option) -> {
        double deadZone = Controllable.getOptions().deadZone;
        return new TranslationTextComponent("controllable.options.deadZone.format", new Object[]{FORMAT.format(deadZone)});
    });
    public static final SliderPercentageOption ROTATION_SPEED = new ControllableSliderPercentageOption("controllable.options.rotationSpeed", 1.0, 50.0, 1.0f, gameSettings -> Controllable.getOptions().rotationSpeed, (gameSettings, value) -> {
        Controllable.getOptions().rotationSpeed = MathHelper.func_151237_a((double)value, (double)1.0, (double)50.0);
    }, (gameSettings, option) -> {
        double rotationSpeed = Controllable.getOptions().rotationSpeed;
        return new TranslationTextComponent("controllable.options.rotationSpeed.format", new Object[]{FORMAT.format(rotationSpeed)});
    });
    public static final SliderPercentageOption MOUSE_SPEED = new ControllableSliderPercentageOption("controllable.options.mouseSpeed", 1.0, 50.0, 1.0f, gameSettings -> Controllable.getOptions().mouseSpeed, (gameSettings, value) -> {
        Controllable.getOptions().mouseSpeed = MathHelper.func_151237_a((double)value, (double)1.0, (double)50.0);
    }, (gameSettings, option) -> {
        double mouseSpeed = Controllable.getOptions().mouseSpeed;
        return new TranslationTextComponent("controllable.options.mouseSpeed.format", new Object[]{FORMAT.format(mouseSpeed)});
    });
    public static final Splitter COLON_SPLITTER = Splitter.on((char)':');
    private File optionsFile;
    private boolean forceFeedback = true;
    private boolean autoSelect = true;
    private boolean renderMiniPlayer = true;
    private boolean virtualMouse = true;
    private boolean consoleHotbar = false;
    private CursorType cursorType = CursorType.LIGHT;
    private ControllerType controllerType = ControllerType.DEFAULT;
    private boolean invertLook = false;
    private double deadZone = 0.15;
    private double rotationSpeed = 25.0;
    private double mouseSpeed = 30.0;

    public ControllerOptions(File dataDir) {
        this.optionsFile = new File(dataDir, "controllable-options.txt");
        this.loadOptions();
    }

    private void loadOptions() {
        try {
            if (!this.optionsFile.exists()) {
                return;
            }
            List lines = IOUtils.readLines((InputStream)new FileInputStream(this.optionsFile), (Charset)Charsets.UTF_8);
            CompoundNBT compound = new CompoundNBT();
            for (String line : lines) {
                try {
                    Iterator iterator = COLON_SPLITTER.omitEmptyStrings().limit(2).split((CharSequence)line).iterator();
                    compound.func_74778_a((String)iterator.next(), (String)iterator.next());
                }
                catch (Exception var10) {
                    Controllable.LOGGER.warn("Skipping bad option: {}", (Object)line);
                }
            }
            for (String key : compound.func_150296_c()) {
                String value = compound.func_74779_i(key);
                try {
                    switch (key) {
                        case "forceFeedback": {
                            this.forceFeedback = Boolean.valueOf(value);
                            break;
                        }
                        case "autoSelect": {
                            this.autoSelect = Boolean.valueOf(value);
                            break;
                        }
                        case "renderMiniPlayer": {
                            this.renderMiniPlayer = Boolean.valueOf(value);
                            break;
                        }
                        case "virtualMouse": {
                            this.virtualMouse = Boolean.valueOf(value);
                            break;
                        }
                        case "consoleHotbar": {
                            this.consoleHotbar = Boolean.valueOf(value);
                            break;
                        }
                        case "cursorType": {
                            this.cursorType = CursorType.byId(value);
                            break;
                        }
                        case "controllerType": {
                            this.controllerType = ControllerType.byName(value);
                            break;
                        }
                        case "invertLook": {
                            this.invertLook = Boolean.valueOf(value);
                            break;
                        }
                        case "deadZone": {
                            this.deadZone = Double.parseDouble(value);
                            break;
                        }
                        case "rotationSpeed": {
                            this.rotationSpeed = Double.parseDouble(value);
                            break;
                        }
                        case "mouseSpeed": {
                            this.mouseSpeed = Double.parseDouble(value);
                        }
                    }
                }
                catch (Exception e) {
                    Controllable.LOGGER.warn("Skipping bad option: {}:{}", (Object)key, (Object)value);
                }
            }
        }
        catch (Exception e) {
            Controllable.LOGGER.error("Failed to load options", (Throwable)e);
        }
    }

    public void saveOptions() {
        try (PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.optionsFile), StandardCharsets.UTF_8));){
            writer.println("forceFeedback:" + this.forceFeedback);
            writer.println("autoSelect:" + this.autoSelect);
            writer.println("renderMiniPlayer:" + this.renderMiniPlayer);
            writer.println("virtualMouse:" + this.virtualMouse);
            writer.println("consoleHotbar:" + this.consoleHotbar);
            writer.println("cursorType:" + this.cursorType.func_176610_l());
            writer.println("controllerType:" + this.controllerType.func_176610_l());
            writer.println("invertLook:" + this.invertLook);
            writer.println("deadZone:" + FORMAT.format(this.deadZone));
            writer.println("rotationSpeed:" + FORMAT.format(this.rotationSpeed));
            writer.println("mouseSpeed:" + FORMAT.format(this.mouseSpeed));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public boolean useForceFeedback() {
        return this.forceFeedback;
    }

    public boolean isAutoSelect() {
        return this.autoSelect;
    }

    public boolean isRenderMiniPlayer() {
        return this.renderMiniPlayer;
    }

    public boolean isVirtualMouse() {
        return this.virtualMouse;
    }

    public boolean useConsoleHotbar() {
        return this.consoleHotbar;
    }

    public CursorType getCursorType() {
        return this.cursorType;
    }

    public ControllerType getControllerType() {
        return this.controllerType;
    }

    public boolean isInvertLook() {
        return this.invertLook;
    }

    public double getDeadZone() {
        return this.deadZone;
    }

    public double getRotationSpeed() {
        return this.rotationSpeed;
    }

    public double getMouseSpeed() {
        return this.mouseSpeed;
    }
}

