/*
 * Decompiled with CFR 0.152.
 */
package com.croparia.mod.World.Generation;

import com.croparia.mod.Config.ConfigInit;
import com.croparia.mod.Init.ModBlocks;
import com.croparia.mod.World.Generation.StructureWorldGen;
import com.google.common.base.Predicate;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;

public class ModWorldGenerator
implements IWorldGenerator {
    private WorldGenerator gen_apricot = new WorldGenMinable(ModBlocks.APRICOT_PLANT.func_176223_P(), 4, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150329_H));
    private WorldGenerator gen_banana = new WorldGenMinable(ModBlocks.BANANA_PLANT.func_176223_P(), 4, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150329_H));
    private WorldGenerator gen_cherry = new WorldGenMinable(ModBlocks.CHERRY_PLANT.func_176223_P(), 4, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150329_H));
    private WorldGenerator gen_kiwi = new WorldGenMinable(ModBlocks.KIWI_PLANT.func_176223_P(), 4, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150329_H));
    private WorldGenerator gen_lemon = new WorldGenMinable(ModBlocks.LEMON_PLANT.func_176223_P(), 4, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150329_H));
    private WorldGenerator gen_orange = new WorldGenMinable(ModBlocks.ORANGE_PLANT.func_176223_P(), 4, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150329_H));
    private WorldGenerator gen_pear = new WorldGenMinable(ModBlocks.PEAR_PLANT.func_176223_P(), 4, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150329_H));
    private WorldGenerator gen_coalcrop = new WorldGenMinable(ModBlocks.COAL_CROP.func_176203_a(3), 5, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150329_H));
    private WorldGenerator gen_poisonous_icy_plant = new WorldGenMinable(ModBlocks.POISONOUS_ICY_PLANT.func_176223_P(), 9, (Predicate)BlockMatcher.func_177642_a((Block)ModBlocks.ICY_PLANT));
    private WorldGenerator gen_water_gem_ore;
    private WorldGenerator gen_fired_obsidian_ground = new WorldGenMinable(ModBlocks.FIRED_OBSIDIAN_GROUND.func_176223_P(), 9, (Predicate)BlockMatcher.func_177642_a((Block)ModBlocks.OBSIDIAN_GROUND));
    private WorldGenerator gen_fire_gem_ore;
    private WorldGenerator gen_earth_gem_ore;
    private WorldGenerator gen_air_gem_ore;
    private WorldGenerator gen_bounce_cloud;

    public ModWorldGenerator() {
        this.gen_water_gem_ore = new WorldGenMinable(ModBlocks.WATER_GEM_ORE.func_176223_P(), 3, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150403_cj));
        this.gen_fire_gem_ore = new WorldGenMinable(ModBlocks.FIRE_GEM_ORE.func_176223_P(), 3, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_189877_df));
        this.gen_earth_gem_ore = new WorldGenMinable(ModBlocks.EARTH_GEM_ORE.func_176223_P(), 3, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150346_d));
        this.gen_air_gem_ore = new WorldGenMinable(ModBlocks.AIR_GEM_ORE.func_176223_P(), 3, (Predicate)BlockMatcher.func_177642_a((Block)ModBlocks.CLOUD));
        this.gen_bounce_cloud = new WorldGenMinable(ModBlocks.BOUNCE_CLOUD.func_176223_P(), 3, (Predicate)BlockMatcher.func_177642_a((Block)ModBlocks.CLOUD));
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        int blockX = chunkX * 16;
        int blockZ = chunkZ * 16;
        switch (world.field_73011_w.getDimension()) {
            case 0: {
                this.runGenerator(this.gen_apricot, world, random, chunkX, chunkZ, ConfigInit.fruitGenChance, (Block)Blocks.field_150349_c);
                this.runGenerator(this.gen_banana, world, random, chunkX, chunkZ, ConfigInit.fruitGenChance, (Block)Blocks.field_150349_c);
                this.runGenerator(this.gen_cherry, world, random, chunkX, chunkZ, ConfigInit.fruitGenChance, (Block)Blocks.field_150349_c);
                this.runGenerator(this.gen_kiwi, world, random, chunkX, chunkZ, ConfigInit.fruitGenChance, (Block)Blocks.field_150349_c);
                this.runGenerator(this.gen_lemon, world, random, chunkX, chunkZ, ConfigInit.fruitGenChance, (Block)Blocks.field_150349_c);
                this.runGenerator(this.gen_orange, world, random, chunkX, chunkZ, ConfigInit.fruitGenChance, (Block)Blocks.field_150349_c);
                this.runGenerator(this.gen_pear, world, random, chunkX, chunkZ, ConfigInit.fruitGenChance, (Block)Blocks.field_150349_c);
                this.runGenerator(this.gen_coalcrop, world, random, chunkX, chunkZ, ConfigInit.coalGenChance, (Block)Blocks.field_150349_c);
                break;
            }
            case 1: {
                break;
            }
            case 5: {
                StructureWorldGen.generateWater(world, random, blockX + 8, blockZ + 8);
                this.runGenerator(this.gen_poisonous_icy_plant, world, random, chunkX, chunkZ, ConfigInit.poisonousIcyPlantGen, Blocks.field_150403_cj);
                this.runGenerator(this.gen_water_gem_ore, world, random, chunkX, chunkZ, ConfigInit.waterGemOreGen, 0, 128);
                break;
            }
            case 6: {
                this.runGenerator(this.gen_fired_obsidian_ground, world, random, chunkX, chunkZ, ConfigInit.firedObsidianGroundGen, Blocks.field_189877_df);
                this.runGenerator(this.gen_fire_gem_ore, world, random, chunkX, chunkZ, ConfigInit.fireGemOreGen, 0, 128);
                break;
            }
            case 7: {
                this.runGenerator(this.gen_earth_gem_ore, world, random, chunkX, chunkZ, ConfigInit.earthGemOreGen, 0, 128);
                break;
            }
            case 8: {
                this.runGenerator(this.gen_bounce_cloud, world, random, chunkX, chunkZ, ConfigInit.bounceCloudGen, ModBlocks.CLOUD);
                this.runGenerator(this.gen_air_gem_ore, world, random, chunkX, chunkZ, ConfigInit.airGemOreGen, 0, 128);
                break;
            }
        }
    }

    private void runGenerator(WorldGenerator generator, World world, Random random, int chunkX, int chunkZ, int chancesToSpawn, int minHeight, int maxHeight) {
        if (minHeight < 0 || maxHeight > 256 || minHeight > maxHeight) {
            throw new IllegalArgumentException("Illegal Height Argument For WorldGenerator");
        }
        int heightDiff = maxHeight - minHeight + 1;
        for (int i = 0; i < chancesToSpawn; ++i) {
            int x = chunkX * 16 + random.nextInt(16);
            int y = minHeight + random.nextInt(heightDiff);
            int z = chunkZ * 16 + random.nextInt(16);
            generator.func_180709_b(world, random, new BlockPos(x, y, z));
        }
    }

    private void runGenerator(WorldGenerator generator, World world, Random random, int chunkX, int chunkZ, int chancesToSpawn, Block topblock) {
        for (int i = 0; i < chancesToSpawn; ++i) {
            int x = chunkX * 16 + random.nextInt(16);
            int z = chunkZ * 16 + random.nextInt(16);
            int y = ModWorldGenerator.calculateGenerationHeight(world, x, z, topblock);
            generator.func_180709_b(world, random, new BlockPos(x, y, z));
        }
    }

    private static int calculateGenerationHeight(World world, int x, int z, Block topBlock) {
        int y = world.func_72800_K();
        boolean foundGround = false;
        while (!foundGround && y-- >= 0) {
            Block block = world.func_180495_p(new BlockPos(x, y, z)).func_177230_c();
            foundGround = block == topBlock;
        }
        return y;
    }
}

