/*
 * Decompiled with CFR 0.152.
 */
package c4.culinaryconstruct.common.util;

import c4.culinaryconstruct.common.util.ConfigHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.oredict.OreDictionary;

public class BreadHelper {
    private static Set<String> breadOres = new HashSet<String>();
    private static List<Item> blacklist = new ArrayList<Item>();

    public static void initBlacklist() {
        String[] config = ConfigHandler.breadBlacklist;
        blacklist.clear();
        for (String s : config) {
            Item item = Item.func_111206_d((String)s);
            if (item == null) continue;
            blacklist.add(item);
        }
    }

    public static void initOreDict() {
        OreDictionary.registerOre((String)"bread", (Item)Items.field_151025_P);
        BreadHelper.addBreadOre("bread");
        if (Loader.isModLoaded((String)"harvestcraft")) {
            BreadHelper.addBreadOres("foodPumpkinbread", "foodGingerbread", "foodGarlicbread", "foodZucchinibread", "foodWalnutraisinbread", "foodBanananutbread", "foodDatenutbread", "foodFairybread", "foodHoneybread");
        }
        if (Loader.isModLoaded((String)"actuallyadditions")) {
            BreadHelper.addBreadItems("actuallyadditions:item_food", 10, 15, 17, 19);
        }
        if (Loader.isModLoaded((String)"xreliquary")) {
            BreadHelper.addBreadItem("xreliquary:glowing_bread");
        }
        if (Loader.isModLoaded((String)"ashenwheat")) {
            BreadHelper.addBreadItems("ashenwheat:ashbread", "ashenwheat:scintillabread");
        }
        if (Loader.isModLoaded((String)"pmp")) {
            BreadHelper.addBreadOre("foodCornBread");
        }
        if (Loader.isModLoaded((String)"xlfoodmod")) {
            BreadHelper.addBreadItems("xlfoodmod:cheesy_bread", "xlfoodmod:potato_bread", "xlfoodmod:corn_bread", "xlfoodmod:rice_bread");
        }
        if (Loader.isModLoaded((String)"gb")) {
            BreadHelper.addBreadItem("gb:glob_bread");
        }
        if (Loader.isModLoaded((String)"roots")) {
            BreadHelper.addBreadItem("roots:wildewheet_bread");
        }
        for (String s : ConfigHandler.breadItems) {
            BreadHelper.addBreadItem(s);
        }
    }

    private static void addBreadOre(String ore) {
        breadOres.add(ore);
    }

    private static void addBreadOres(String ... ore) {
        breadOres.addAll(Arrays.asList(ore));
    }

    private static void addBreadItem(String id) {
        Item item = Item.func_111206_d((String)id);
        if (item != null) {
            OreDictionary.registerOre((String)"bread", (ItemStack)new ItemStack(item));
        }
    }

    private static void addBreadItems(String ... ids) {
        for (String s : ids) {
            BreadHelper.addBreadItem(s);
        }
    }

    private static void addBreadItems(String id, int ... metadata) {
        Item item = Item.func_111206_d((String)id);
        if (item != null) {
            int[] nArray = metadata;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                Integer meta = nArray[i];
                OreDictionary.registerOre((String)"bread", (ItemStack)new ItemStack(item, 1, meta.intValue()));
            }
        }
    }

    public static boolean isValidBread(ItemStack stack) {
        if (blacklist.contains(stack.func_77973_b())) {
            return false;
        }
        for (String oreDictEntry : breadOres) {
            if (!OreDictionary.containsMatch((boolean)true, (NonNullList)OreDictionary.getOres((String)oreDictEntry), (ItemStack[])new ItemStack[]{stack})) continue;
            return true;
        }
        return false;
    }
}

