/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.culinaryconstruct;

import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.renderer.model.BlockModel;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.model.SimpleBakedModel;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.theillusivec4.culinaryconstruct.client.CulinaryScreen;
import top.theillusivec4.culinaryconstruct.client.model.FoodBowlModel;
import top.theillusivec4.culinaryconstruct.client.model.SandwichModel;
import top.theillusivec4.culinaryconstruct.client.model.base.CulinaryModelWrapper;
import top.theillusivec4.culinaryconstruct.common.CulinaryConstructConfig;
import top.theillusivec4.culinaryconstruct.common.advancement.CulinaryTriggers;
import top.theillusivec4.culinaryconstruct.common.capability.CapabilityCulinaryFood;
import top.theillusivec4.culinaryconstruct.common.network.CulinaryConstructNetwork;
import top.theillusivec4.culinaryconstruct.common.registry.CulinaryConstructRegistry;

@Mod(value="culinaryconstruct")
public class CulinaryConstruct {
    public static final String MODID = "culinaryconstruct";
    public static final Logger LOGGER = LogManager.getLogger();

    public CulinaryConstruct() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        eventBus.addListener(this::setup);
        eventBus.addListener(this::clientSetup);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, CulinaryConstructConfig.serverSpec);
    }

    private void setup(FMLCommonSetupEvent evt) {
        CulinaryConstructNetwork.register();
        CapabilityCulinaryFood.register();
        CulinaryTriggers.register();
    }

    private void clientSetup(FMLClientSetupEvent evt) {
        ScreenManager.func_216911_a(CulinaryConstructRegistry.CULINARY_STATION_CONTAINER, CulinaryScreen::new);
    }

    @Mod.EventBusSubscriber(modid="culinaryconstruct", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ClientProxy {
        @SubscribeEvent
        public static void bakeModels(ModelBakeEvent evt) {
            ModelResourceLocation rl = new ModelResourceLocation("culinaryconstruct:sandwich", "inventory");
            SimpleBakedModel original = (SimpleBakedModel)evt.getModelRegistry().get(rl);
            BlockModel unbaked = (BlockModel)evt.getModelLoader().func_209597_a((ResourceLocation)rl);
            CulinaryModelWrapper model = new CulinaryModelWrapper(original, new SandwichModel.BakedSandwichOverrideHandler((ModelBakery)evt.getModelLoader(), unbaked));
            evt.getModelRegistry().put(rl, model);
            rl = new ModelResourceLocation("culinaryconstruct:food_bowl", "inventory");
            original = (SimpleBakedModel)evt.getModelRegistry().get(rl);
            unbaked = (BlockModel)evt.getModelLoader().func_209597_a((ResourceLocation)rl);
            model = new CulinaryModelWrapper(original, new FoodBowlModel.BakedFoodBowlOverrideHandler((ModelBakery)evt.getModelLoader(), unbaked));
            evt.getModelRegistry().put(rl, model);
        }

        @SubscribeEvent
        public static void registerTextures(TextureStitchEvent.Pre evt) {
            AtlasTexture map = evt.getMap();
            if (map.getBasePath().equals("textures")) {
                for (int i = 0; i < 5; ++i) {
                    evt.addSprite(new ResourceLocation(CulinaryConstruct.MODID, "item/sandwich/bread" + i));
                    evt.addSprite(new ResourceLocation(CulinaryConstruct.MODID, "item/sandwich/layer" + i));
                    evt.addSprite(new ResourceLocation(CulinaryConstruct.MODID, "item/bowl/layer" + i));
                }
                evt.addSprite(new ResourceLocation(CulinaryConstruct.MODID, "item/bowl/liquid_base"));
                evt.addSprite(new ResourceLocation(CulinaryConstruct.MODID, "item/bowl/liquid_overflow"));
            }
        }
    }
}

