/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.culinaryconstruct.client.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.BlockModel;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.texture.ISprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.BakedItemModel;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import top.theillusivec4.culinaryconstruct.client.model.base.CulinaryOverrideHandler;
import top.theillusivec4.culinaryconstruct.client.model.utils.ColorHelper;
import top.theillusivec4.culinaryconstruct.client.model.utils.ModelHelper;
import top.theillusivec4.culinaryconstruct.common.util.CulinaryNBTHelper;

public class SandwichModel
implements IUnbakedModel {
    @Nullable
    private final List<TextureAtlasSprite> ingredients;
    @Nullable
    private final List<Integer> layers;
    private final int baseIndex;

    public SandwichModel(@Nullable List<TextureAtlasSprite> ingredients, @Nullable List<Integer> layers) {
        this.ingredients = ingredients;
        this.layers = layers;
        this.baseIndex = ingredients == null ? 0 : ingredients.size() - 1;
    }

    @Nonnull
    public Collection<ResourceLocation> func_209559_a(@Nonnull Function<ResourceLocation, IUnbakedModel> modelGetter, @Nonnull Set<String> missingTextureErrors) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        if (this.ingredients != null && this.layers != null) {
            builder.add((Object)new ResourceLocation("culinaryconstruct", "item/sandwich/bread" + this.baseIndex));
            for (TextureAtlasSprite sprite : this.ingredients) {
                builder.add((Object)sprite.func_195668_m());
            }
            Iterator<Object> iterator = this.layers.iterator();
            while (iterator.hasNext()) {
                int layer = (Integer)iterator.next();
                builder.add((Object)new ResourceLocation("culinaryconstruct", "item/sandwich/layer" + layer));
            }
        }
        return builder.build();
    }

    @Nonnull
    public Collection<ResourceLocation> func_187965_e() {
        return Collections.emptyList();
    }

    @Nonnull
    public IBakedModel bake(@Nonnull ModelBakery bakery, @Nonnull Function<ResourceLocation, TextureAtlasSprite> spriteGetter, @Nonnull ISprite sprite, @Nonnull VertexFormat format) {
        IModelState state = sprite.getState();
        ImmutableMap transformMap = PerspectiveMapWrapper.getTransforms((IModelState)state);
        TRSRTransformation transform = state.apply(Optional.empty()).orElse(TRSRTransformation.identity());
        Random random = new Random();
        random.setSeed(42L);
        ImmutableList.Builder builder = ImmutableList.builder();
        IBakedModel model = ModelHelper.getBakedLayerModel(new ResourceLocation("culinaryconstruct", "item/sandwich/bread" + this.baseIndex), bakery, spriteGetter, sprite, format);
        builder.addAll((Iterable)model.getQuads(null, null, random, (IModelData)EmptyModelData.INSTANCE));
        TextureAtlasSprite particleSprite = model.getParticleTexture((IModelData)EmptyModelData.INSTANCE);
        if (this.ingredients != null && this.layers != null) {
            ArrayList<Integer> ingredientColors = new ArrayList<Integer>();
            for (TextureAtlasSprite ing : this.ingredients) {
                ingredientColors.add(ColorHelper.getDominantColor(ing));
            }
            for (int i = 0; i < this.ingredients.size(); ++i) {
                IBakedModel ingredient = ModelHelper.getBakedLayerModel(new ResourceLocation("culinaryconstruct", "item/sandwich/layer" + this.layers.get(i)), bakery, spriteGetter, sprite, format);
                ColorHelper.colorQuads(ingredient, (Integer)ingredientColors.get(i), random, (ImmutableList.Builder<BakedQuad>)builder);
            }
        }
        return new BakedItemModel(builder.build(), particleSprite, transformMap, ItemOverrideList.field_188022_a, transform.isIdentity());
    }

    public static final class BakedSandwichOverrideHandler
    extends CulinaryOverrideHandler {
        public BakedSandwichOverrideHandler(ModelBakery bakery, BlockModel unbaked) {
            super(bakery, unbaked);
        }

        @Override
        protected IBakedModel getBakedModel(ItemStack stack) {
            ImmutableList.Builder builder = ImmutableList.builder();
            NonNullList<ItemStack> ingredients = CulinaryNBTHelper.getIngredientsList(stack);
            for (ItemStack ing : ingredients) {
                builder.add((Object)Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(ing).getParticleTexture((IModelData)EmptyModelData.INSTANCE));
            }
            int size = CulinaryNBTHelper.getSize(stack);
            ArrayList<Integer> list = new ArrayList<Integer>();
            switch (size) {
                case 1: {
                    list.add(2);
                    break;
                }
                case 2: {
                    list.addAll(Arrays.asList(1, 2));
                    break;
                }
                case 3: {
                    list.addAll(Arrays.asList(1, 2, 3));
                    break;
                }
                case 4: {
                    list.addAll(Arrays.asList(0, 1, 2, 3));
                    break;
                }
                case 5: {
                    list.addAll(Arrays.asList(0, 1, 2, 3, 4));
                }
            }
            SandwichModel parent = new SandwichModel((List<TextureAtlasSprite>)builder.build(), list);
            Function<ResourceLocation, TextureAtlasSprite> textureGetter = location -> Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString());
            return parent.bake(this.bakery, textureGetter, (ISprite)new SimpleModelState(ImmutableMap.copyOf((Map)PerspectiveMapWrapper.getTransforms((ItemCameraTransforms)this.unbaked.func_181682_g()))), DefaultVertexFormats.field_176599_b);
        }
    }
}

