/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.culinaryconstruct.client.model.base;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.model.BlockModel;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.world.World;
import top.theillusivec4.culinaryconstruct.CulinaryConstruct;
import top.theillusivec4.culinaryconstruct.client.model.base.CulinaryModelWrapper;
import top.theillusivec4.culinaryconstruct.client.model.utils.ModelHelper;
import top.theillusivec4.culinaryconstruct.common.util.CulinaryNBTHelper;

public abstract class CulinaryOverrideHandler
extends ItemOverrideList {
    protected final ModelBakery bakery;
    protected final BlockModel unbaked;
    private Cache<ModelHelper.CacheKey, IBakedModel> bakedModelCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(5L, TimeUnit.MINUTES).build();

    public CulinaryOverrideHandler(ModelBakery bakery, BlockModel unbaked) {
        this.bakery = bakery;
        this.unbaked = unbaked;
    }

    @Nonnull
    public IBakedModel func_209581_a(@Nonnull IBakedModel model, @Nonnull ItemStack stack, @Nullable World worldIn, @Nullable LivingEntity entityIn) {
        CompoundNBT data = CulinaryNBTHelper.getTagSafe(stack);
        IBakedModel output = model;
        if (!data.isEmpty()) {
            CulinaryModelWrapper original = (CulinaryModelWrapper)model;
            ModelHelper.CacheKey key = this.getCacheKey(stack, original);
            try {
                output = (IBakedModel)this.bakedModelCache.get((Object)key, () -> this.getBakedModel(stack));
            }
            catch (ExecutionException e) {
                CulinaryConstruct.LOGGER.error("Error baking model!");
            }
        }
        return output;
    }

    protected abstract IBakedModel getBakedModel(ItemStack var1);

    ModelHelper.CacheKey getCacheKey(ItemStack stack, CulinaryModelWrapper original) {
        return new ModelHelper.CacheKey((IBakedModel)original, stack);
    }
}

