/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.culinaryconstruct.client.model.utils;

import com.google.common.collect.ImmutableList;
import java.awt.Color;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.client.model.pipeline.VertexTransformer;

public class ColorHelper {
    public static void colorQuads(IBakedModel bakedModel, int color, Random random, ImmutableList.Builder<BakedQuad> builder) {
        List quads = bakedModel.getQuads(null, null, random, (IModelData)EmptyModelData.INSTANCE);
        for (BakedQuad quad : quads) {
            ColorTransformer transformer = new ColorTransformer(color, quad.getFormat());
            quad.pipe((IVertexConsumer)transformer);
            builder.add((Object)transformer.build());
        }
    }

    public static int getDominantColor(TextureAtlasSprite sprite) {
        int iconWidth = sprite.func_94211_a();
        int iconHeight = sprite.func_94216_b();
        int frameCount = sprite.func_110970_k();
        if (iconWidth <= 0 || iconHeight <= 0 || frameCount <= 0) {
            return 0xFFFFFF;
        }
        TreeMap<Integer, Integer> counts = new TreeMap<Integer, Integer>();
        for (int f = 0; f < frameCount; ++f) {
            for (int v = 0; v < iconWidth; ++v) {
                for (int u = 0; u < iconHeight; ++u) {
                    int rgba = sprite.getPixelRGBA(f, v, u);
                    int alpha = rgba >> 24 & 0xFF;
                    if (alpha <= 0) continue;
                    counts.merge(rgba, 1, (color, count) -> count + 1);
                }
            }
        }
        int dominantColor = 0;
        int dominantSum = 0;
        for (Map.Entry entry : counts.entrySet()) {
            if ((Integer)entry.getValue() <= dominantSum) continue;
            dominantSum = (Integer)entry.getValue();
            dominantColor = (Integer)entry.getKey();
        }
        Color color2 = new Color(dominantColor, true);
        return new Color(color2.getBlue(), color2.getGreen(), color2.getRed()).brighter().getRGB();
    }

    public static int getMixedColor(List<Integer> colors) {
        int[] aint = new int[3];
        int i = 0;
        int j = 0;
        for (Integer color : colors) {
            float f = (float)(color >> 16 & 0xFF) / 255.0f;
            float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
            float f2 = (float)(color & 0xFF) / 255.0f;
            i = (int)((float)i + Math.max(f, Math.max(f1, f2)) * 255.0f);
            aint[0] = (int)((float)aint[0] + f * 255.0f);
            aint[1] = (int)((float)aint[1] + f1 * 255.0f);
            aint[2] = (int)((float)aint[2] + f2 * 255.0f);
            ++j;
        }
        int j1 = aint[0] / j;
        int k1 = aint[1] / j;
        int l1 = aint[2] / j;
        float f3 = (float)i / (float)j;
        float f4 = Math.max(j1, Math.max(k1, l1));
        j1 = (int)((float)j1 * f3 / f4);
        k1 = (int)((float)k1 * f3 / f4);
        l1 = (int)((float)l1 * f3 / f4);
        int j2 = (j1 << 8) + k1;
        j2 = (j2 << 8) + l1;
        return j2;
    }

    private static class ColorTransformer
    extends VertexTransformer {
        private final float r;
        private final float g;
        private final float b;
        private final float a;

        public ColorTransformer(int color, VertexFormat format) {
            super((IVertexConsumer)new UnpackedBakedQuad.Builder(format));
            int a = color >> 24;
            if (a == 0) {
                a = 255;
            }
            int r = color >> 16 & 0xFF;
            int g = color >> 8 & 0xFF;
            int b = color & 0xFF;
            this.r = (float)r / 255.0f;
            this.g = (float)g / 255.0f;
            this.b = (float)b / 255.0f;
            this.a = (float)a / 255.0f;
        }

        public void put(int element, float ... data) {
            VertexFormatElement.Usage usage = this.parent.getVertexFormat().func_177348_c(element).func_177375_c();
            if (usage == VertexFormatElement.Usage.COLOR && data.length >= 4) {
                data[0] = this.r;
                data[1] = this.g;
                data[2] = this.b;
                data[3] = this.a;
            }
            super.put(element, data);
        }

        public UnpackedBakedQuad build() {
            return ((UnpackedBakedQuad.Builder)this.parent).build();
        }
    }
}

