/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.culinaryconstruct.client.model.utils;

import com.google.common.collect.ImmutableList;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.texture.ISprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ItemLayerModel;
import top.theillusivec4.culinaryconstruct.common.util.CulinaryNBTHelper;

public class ModelHelper {
    public static IBakedModel getBakedLayerModel(ResourceLocation resourceLocation, @Nonnull ModelBakery bakery, @Nonnull Function<ResourceLocation, TextureAtlasSprite> spriteGetter, @Nonnull ISprite sprite, @Nonnull VertexFormat format) {
        return new ItemLayerModel(ImmutableList.of((Object)resourceLocation)).bake(bakery, spriteGetter, sprite, format);
    }

    public static class CacheKey {
        final IBakedModel parent;
        final CompoundNBT data;

        public CacheKey(IBakedModel parent, ItemStack stack) {
            this.parent = parent;
            this.data = CulinaryNBTHelper.getTagSafe(stack);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            if (this.parent != null ? this.parent != cacheKey.parent : cacheKey.parent != null) {
                return false;
            }
            return Objects.equals(this.data, cacheKey.data);
        }

        public int hashCode() {
            int result = this.parent != null ? this.parent.hashCode() : 0;
            result = 31 * result + (this.data != null ? this.data.hashCode() : 0);
            return result;
        }
    }
}

