/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.culinaryconstruct.common.item;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import top.theillusivec4.culinaryconstruct.api.CulinaryConstructAPI;
import top.theillusivec4.culinaryconstruct.common.util.CulinaryNBTHelper;

public class CulinaryItemBase
extends Item {
    public static final Random RANDOM = new Random();

    public CulinaryItemBase() {
        super(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(new Food.Builder().func_221453_d()));
    }

    protected static void generateCreativeNBT(ItemStack sub) {
        CulinaryNBTHelper.setSize(sub, 5);
        CulinaryNBTHelper.setIngredientsList(sub, (NonNullList<ItemStack>)NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])new ItemStack[]{new ItemStack((IItemProvider)Items.field_151156_bN), new ItemStack((IItemProvider)Items.field_151156_bN), new ItemStack((IItemProvider)Items.field_151156_bN), new ItemStack((IItemProvider)Items.field_151156_bN), new ItemStack((IItemProvider)Items.field_151156_bN)}));
        CulinaryNBTHelper.setFoodAmount(sub, 20);
        CulinaryNBTHelper.setSaturation(sub, 1.0f);
        CulinaryNBTHelper.setQuality(sub, 4);
    }

    @Nonnull
    public ItemStack func_77654_b(@Nonnull ItemStack stack, @Nonnull World worldIn, @Nonnull LivingEntity livingEntity) {
        if (livingEntity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)livingEntity;
            int food = CulinaryNBTHelper.getFoodAmount(stack);
            float saturation = CulinaryNBTHelper.getSaturation(stack);
            player.func_71024_bL().func_75122_a(food, saturation);
            ArrayList<ItemStack> consumed = new ArrayList<ItemStack>((Collection<ItemStack>)CulinaryNBTHelper.getIngredientsList(stack));
            consumed.add(CulinaryNBTHelper.getBase(stack));
            consumed.forEach(itemstack -> {
                if (!itemstack.func_190926_b()) {
                    CulinaryConstructAPI.getCulinaryIngredient(itemstack).ifPresent(culinary -> {
                        culinary.onEaten(player);
                        culinary.getEffects().forEach(effect -> {
                            if (RANDOM.nextFloat() < ((Float)effect.getRight()).floatValue()) {
                                player.func_195064_c((EffectInstance)effect.getLeft());
                            }
                        });
                    });
                    Food foodie = itemstack.func_77973_b().func_219967_s();
                    if (foodie != null) {
                        foodie.func_221464_f().forEach(effect -> {
                            if (RANDOM.nextFloat() < ((Float)effect.getRight()).floatValue()) {
                                player.func_195064_c((EffectInstance)effect.getLeft());
                            }
                        });
                    }
                }
            });
        }
        return livingEntity.func_213357_a(worldIn, stack);
    }

    @Nonnull
    public ITextComponent func_200295_i(@Nonnull ItemStack stack) {
        StringBuilder fullName = new StringBuilder();
        NonNullList<ItemStack> ingredients = CulinaryNBTHelper.getIngredientsList(stack);
        if (!ingredients.isEmpty()) {
            Map<Item, Long> countMap = ingredients.stream().collect(Collectors.groupingBy(ItemStack::func_77973_b, Collectors.counting()));
            ArrayList names = new ArrayList();
            countMap.forEach((item, count) -> {
                StringBuilder builder = new StringBuilder();
                if (count > 1L) {
                    builder.append(new TranslationTextComponent("tooltip.culinaryconstruct.count." + count, new Object[0]).func_150261_e());
                    builder.append(" ");
                }
                builder.append(new TranslationTextComponent(item.func_77658_a(), new Object[0]).func_150261_e());
                names.add(builder.toString());
            });
            fullName.append(new TranslationTextComponent("tooltip.culinaryconstruct.list." + names.size(), names.toArray()).func_150261_e());
        }
        fullName.append(" ");
        fullName.append(new TranslationTextComponent(this.func_77667_c(stack), new Object[0]).func_150261_e());
        return new StringTextComponent(fullName.toString());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        ItemStack base = CulinaryNBTHelper.getBase(stack);
        int quality = CulinaryNBTHelper.getQuality(stack);
        tooltip.add(new TranslationTextComponent("tooltip.culinaryconstruct.quality." + quality, new Object[0]).func_211708_a(TextFormatting.GREEN));
        tooltip.add(new TranslationTextComponent(base.func_77977_a(), new Object[0]).func_211708_a(TextFormatting.GRAY));
        tooltip.add((ITextComponent)new StringTextComponent(""));
        if (InputMappings.func_216506_a((long)Minecraft.func_71410_x().field_195558_d.func_198092_i(), (int)340) || InputMappings.func_216506_a((long)Minecraft.func_71410_x().field_195558_d.func_198092_i(), (int)344)) {
            NonNullList<ItemStack> ingredients = CulinaryNBTHelper.getIngredientsList(stack);
            tooltip.add(new TranslationTextComponent("tooltip.culinaryconstruct.ingredients.name", new Object[0]).func_211708_a(TextFormatting.GRAY).func_211708_a(TextFormatting.UNDERLINE));
            for (ItemStack ing : ingredients) {
                if (ing.func_190926_b()) continue;
                tooltip.add(new TranslationTextComponent(ing.func_77977_a(), new Object[0]).func_211708_a(TextFormatting.GRAY));
            }
        } else {
            tooltip.add(new TranslationTextComponent("tooltip.culinaryconstruct.ingredients", new Object[0]).func_211708_a(TextFormatting.GRAY));
        }
    }
}

