/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.culinaryconstruct.common.tileentity;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import top.theillusivec4.culinaryconstruct.api.CulinaryConstructAPI;
import top.theillusivec4.culinaryconstruct.api.capability.ICulinaryIngredient;
import top.theillusivec4.culinaryconstruct.common.CulinaryConstructConfig;
import top.theillusivec4.culinaryconstruct.common.item.CulinaryItemBase;
import top.theillusivec4.culinaryconstruct.common.registry.CulinaryConstructRegistry;
import top.theillusivec4.culinaryconstruct.common.tag.CulinaryTags;

public class CulinaryStationTileEntity
extends TileEntity {
    public final ItemStackHandler base = new CulinaryStackHandler(stack -> stack.func_77973_b().func_206844_a(CulinaryTags.BREAD) || stack.func_77973_b().func_206844_a(CulinaryTags.BOWL), 1);
    public final ItemStackHandler ingredients = new CulinaryStackHandler(stack -> {
        LazyOptional<ICulinaryIngredient> culinary = CulinaryConstructAPI.getCulinaryIngredient(stack);
        return !(stack.func_77973_b() instanceof CulinaryItemBase) && (stack.func_77973_b().func_219971_r() || (Boolean)culinary.map(ICulinaryIngredient::isValid).orElse((Object)false) != false) && !CulinaryConstructConfig.isBlacklistedIngredient(stack);
    }, 5);
    public final ItemStackHandler output = new CulinaryStackHandler(stack -> false, 1);
    protected final LazyOptional<IItemHandler> baseOpt = LazyOptional.of(() -> this.base);
    protected final LazyOptional<IItemHandler> ingredientsOpt = LazyOptional.of(() -> this.ingredients);
    protected final LazyOptional<IItemHandler> outputOpt = LazyOptional.of(() -> this.output);

    public CulinaryStationTileEntity() {
        super(CulinaryConstructRegistry.CULINARY_STATION_TE);
    }

    public void func_145839_a(@Nonnull CompoundNBT compound) {
        super.func_145839_a(compound);
        if (compound.func_150297_b("Holder", 10)) {
            this.base.deserializeNBT(compound.func_74775_l("Holder"));
        }
        if (compound.func_150297_b("Ingredients", 10)) {
            this.ingredients.deserializeNBT(compound.func_74775_l("Ingredients"));
        }
        if (compound.func_150297_b("Output", 10)) {
            this.output.deserializeNBT(compound.func_74775_l("Output"));
        }
    }

    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_218657_a("Holder", (INBT)this.base.serializeNBT());
        compound.func_218657_a("Ingredients", (INBT)this.ingredients.serializeNBT());
        compound.func_218657_a("Output", (INBT)this.output.serializeNBT());
        return compound;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (!this.field_145846_f && facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == Direction.UP) {
                return CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.orEmpty(capability, this.baseOpt);
            }
            if (facing != Direction.DOWN) {
                return CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.orEmpty(capability, this.ingredientsOpt);
            }
        }
        return super.getCapability(capability, facing);
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.baseOpt.invalidate();
        this.ingredientsOpt.invalidate();
        this.outputOpt.invalidate();
    }

    private class CulinaryStackHandler
    extends ItemStackHandler {
        private final Function<ItemStack, Boolean> validity;

        public CulinaryStackHandler(Function<ItemStack, Boolean> validity, int size) {
            super(size);
            this.validity = validity;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return this.validity.apply(stack);
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            CulinaryStationTileEntity.this.func_70296_d();
        }
    }
}

