/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.culinaryconstruct.common.util;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.NonNullList;

public class CulinaryNBTHelper {
    public static final String TAG_BASE = "Base";
    public static final String TAG_INGREDIENTS = "Ingredients";
    public static final String TAG_FOOD = "Food";
    public static final String TAG_SATURATION = "Saturation";
    public static final String TAG_SIZE = "Size";
    public static final String TAG_QUALITY = "Quality";
    public static final String TAG_LIQUIDS = "Liquids";
    public static final String TAG_SOLIDS = "Solids";
    public static final String TAG_SOLIDS_SIZE = "SolidsSize";

    public static CompoundNBT getTagSafe(ItemStack stack) {
        return stack.func_196082_o();
    }

    public static ItemStack getBase(ItemStack stack) {
        CompoundNBT compound = CulinaryNBTHelper.getTagSafe(stack);
        return ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l(TAG_BASE));
    }

    public static int getQuality(ItemStack stack) {
        CompoundNBT compound = CulinaryNBTHelper.getTagSafe(stack);
        return compound.func_74762_e(TAG_QUALITY);
    }

    public static int getSize(ItemStack stack) {
        CompoundNBT compound = CulinaryNBTHelper.getTagSafe(stack);
        return compound.func_74762_e(TAG_SIZE);
    }

    public static int getFoodAmount(ItemStack stack) {
        CompoundNBT compound = CulinaryNBTHelper.getTagSafe(stack);
        return compound.func_74762_e(TAG_FOOD);
    }

    public static float getSaturation(ItemStack stack) {
        CompoundNBT compound = CulinaryNBTHelper.getTagSafe(stack);
        return compound.func_74760_g(TAG_SATURATION);
    }

    public static NonNullList<ItemStack> getIngredientsList(ItemStack stack) {
        CompoundNBT compound = CulinaryNBTHelper.getTagSafe(stack);
        CompoundNBT tag = compound.func_74775_l(TAG_INGREDIENTS);
        NonNullList list = NonNullList.func_191197_a((int)CulinaryNBTHelper.getSize(stack), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((CompoundNBT)tag, (NonNullList)list);
        return list;
    }

    @Nullable
    public static List<Integer> getLiquids(ItemStack stack) {
        CompoundNBT compound = CulinaryNBTHelper.getTagSafe(stack);
        if (!compound.func_74764_b(TAG_LIQUIDS)) {
            return null;
        }
        ListNBT tag = compound.func_150295_c(TAG_LIQUIDS, 3);
        ArrayList<Integer> liquids = new ArrayList<Integer>();
        tag.forEach(nbt -> liquids.add(((IntNBT)nbt).func_150287_d()));
        return liquids;
    }

    public static int getSolidsSize(ItemStack stack) {
        CompoundNBT compound = CulinaryNBTHelper.getTagSafe(stack);
        return compound.func_74762_e(TAG_SOLIDS_SIZE);
    }

    public static NonNullList<ItemStack> getSolids(ItemStack stack) {
        CompoundNBT compound = CulinaryNBTHelper.getTagSafe(stack);
        CompoundNBT tag = compound.func_74775_l(TAG_SOLIDS);
        NonNullList list = NonNullList.func_191197_a((int)CulinaryNBTHelper.getSolidsSize(stack), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((CompoundNBT)tag, (NonNullList)list);
        return list;
    }

    public static void setBase(ItemStack stack, ItemStack base) {
        CulinaryNBTHelper.getTagSafe(stack).func_218657_a(TAG_BASE, (INBT)base.func_77955_b(new CompoundNBT()));
    }

    public static void setQuality(ItemStack stack, int quality) {
        CulinaryNBTHelper.getTagSafe(stack).func_74768_a(TAG_QUALITY, quality);
    }

    public static void setSize(ItemStack stack, int size) {
        CulinaryNBTHelper.getTagSafe(stack).func_74768_a(TAG_SIZE, size);
    }

    public static void setFoodAmount(ItemStack stack, int food) {
        CulinaryNBTHelper.getTagSafe(stack).func_74768_a(TAG_FOOD, food);
    }

    public static void setSaturation(ItemStack stack, float saturation) {
        CulinaryNBTHelper.getTagSafe(stack).func_74776_a(TAG_SATURATION, saturation);
    }

    public static void setIngredientsList(ItemStack stack, NonNullList<ItemStack> ingredients) {
        CompoundNBT compound = CulinaryNBTHelper.getTagSafe(stack);
        CompoundNBT tag = new CompoundNBT();
        ItemStackHelper.func_191282_a((CompoundNBT)tag, ingredients);
        compound.func_218657_a(TAG_INGREDIENTS, (INBT)tag);
    }

    public static void setLiquids(ItemStack stack, List<Integer> liquids) {
        CompoundNBT compound = CulinaryNBTHelper.getTagSafe(stack);
        ListNBT tag = new ListNBT();
        liquids.forEach(liquid -> tag.add((Object)new IntNBT(liquid.intValue())));
        compound.func_218657_a(TAG_LIQUIDS, (INBT)tag);
    }

    public static void setSolidsSize(ItemStack stack, int size) {
        CulinaryNBTHelper.getTagSafe(stack).func_74768_a(TAG_SOLIDS_SIZE, size);
    }

    public static void setSolids(ItemStack stack, NonNullList<ItemStack> solids) {
        CompoundNBT compound = CulinaryNBTHelper.getTagSafe(stack);
        CompoundNBT tag = new CompoundNBT();
        ItemStackHelper.func_191282_a((CompoundNBT)tag, solids);
        compound.func_218657_a(TAG_SOLIDS, (INBT)tag);
    }
}

