/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.tileentity;

import com.lothrazar.cyclicmagic.block.tileentity.ITileRedstoneToggle;
import com.lothrazar.cyclicmagic.block.tileentity.TileEntityBaseMachineInvo;
import com.lothrazar.cyclicmagic.util.UtilItemStack;
import com.lothrazar.cyclicmagic.util.UtilParticle;
import com.lothrazar.cyclicmagic.util.UtilShape;
import com.lothrazar.cyclicmagic.util.UtilSound;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileEntityPatternBuilder
extends TileEntityBaseMachineInvo
implements ITickable,
ITileRedstoneToggle {
    private static final EnumParticleTypes PARTICLE_TARGET = EnumParticleTypes.CLOUD;
    private static final EnumParticleTypes PARTICLE_SRC = EnumParticleTypes.DRAGON_BREATH;
    private static final String NBT_REDST = "redstone";
    private static final String NBT_INV = "Inventory";
    private static final String NBT_SLOT = "Slot";
    private int height = 5;
    private int offsetTargetX = -4;
    private int offsetTargetY = 0;
    private int offsetTargetZ = 1;
    private int offsetSourceX = 4;
    private int offsetSourceY = 0;
    private int offsetSourceZ = 1;
    private int sizeRadius = 3;
    private int timer = 1;
    private int needsRedstone = 1;
    private int renderParticles = 1;
    private static final int TIMER_FULL = 20;
    private static final int TIMER_SKIP = 1;
    private ItemStack[] inv = new ItemStack[18];
    private static final int MAXIMUM = 32;

    @Override
    public int func_174890_g() {
        return Fields.values().length;
    }

    private BlockPos getCenterTarget() {
        return this.func_174877_v().func_177982_a(this.offsetTargetX, this.offsetTargetY, this.offsetTargetZ);
    }

    private BlockPos getCenterSrc() {
        return this.func_174877_v().func_177982_a(this.offsetSourceX, this.offsetSourceY, this.offsetSourceZ);
    }

    private int findSlotForMatch(IBlockState stateToMatch) {
        int slot = -1;
        if (stateToMatch == null || stateToMatch.func_177230_c() == null) {
            return slot;
        }
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            Item itemFromState;
            ItemStack is = this.func_70301_a(i);
            if (UtilItemStack.isEmpty(is) || (itemFromState = Item.func_150898_a((Block)stateToMatch.func_177230_c())) != is.func_77973_b()) continue;
            slot = i;
            break;
        }
        return slot;
    }

    @Override
    public boolean onlyRunIfPowered() {
        return this.needsRedstone == 1;
    }

    public void func_73660_a() {
        if (this.renderParticles == 1) {
            this.renderBoundingBoxes();
        }
        if (!this.isRunning()) {
            return;
        }
        --this.timer;
        if (this.timer <= 0) {
            this.timer = 20;
            BlockPos centerSrc = this.getCenterSrc();
            List<BlockPos> shapeSrc = UtilShape.cubeFilled(centerSrc, this.sizeRadius, this.height);
            if (shapeSrc.size() <= 0) {
                return;
            }
            World world = this.func_145831_w();
            int pTarget = world.field_73012_v.nextInt(shapeSrc.size());
            BlockPos posSrc = shapeSrc.get(pTarget);
            int xOffset = posSrc.func_177958_n() - centerSrc.func_177958_n();
            int yOffset = posSrc.func_177956_o() - centerSrc.func_177956_o();
            int zOffset = posSrc.func_177952_p() - centerSrc.func_177952_p();
            BlockPos centerTarget = this.getCenterTarget();
            BlockPos posTarget = centerTarget.func_177982_a(xOffset, yOffset, zOffset);
            UtilParticle.spawnParticle(this.func_145831_w(), EnumParticleTypes.CRIT_MAGIC, posSrc);
            UtilParticle.spawnParticle(this.func_145831_w(), EnumParticleTypes.CRIT_MAGIC, posTarget);
            if (!world.func_175623_d(posSrc)) {
                IBlockState stateToMatch = world.func_180495_p(posSrc);
                int slot = this.findSlotForMatch(stateToMatch);
                if (slot < 0) {
                    return;
                }
                if (world.func_175623_d(posTarget)) {
                    world.func_175656_a(posTarget, stateToMatch);
                    this.func_70298_a(slot, 1);
                    UtilSound.playSoundPlaceBlock(world, posTarget, stateToMatch.func_177230_c());
                } else {
                    this.timer = 1;
                }
            } else {
                this.timer = 1;
            }
        }
    }

    private void renderBoundingBoxes() {
        BlockPos centerTarget = this.func_174877_v().func_177982_a(this.offsetTargetX, this.offsetTargetY, this.offsetTargetZ);
        List<BlockPos> shapeTarget = UtilShape.cubeFrame(centerTarget, this.sizeRadius, this.height);
        if (this.func_145831_w().field_73012_v.nextDouble() < 0.1) {
            for (BlockPos p : shapeTarget) {
                UtilParticle.spawnParticleNarrow(this.func_145831_w(), PARTICLE_TARGET, p);
            }
        }
        BlockPos centerSrc = this.func_174877_v().func_177982_a(this.offsetSourceX, this.offsetSourceY, this.offsetSourceZ);
        List<BlockPos> shapeSrc = UtilShape.cubeFrame(centerSrc, this.sizeRadius, this.height);
        if (this.func_145831_w().field_73012_v.nextDouble() < 0.1) {
            for (BlockPos p : shapeSrc) {
                UtilParticle.spawnParticleNarrow(this.func_145831_w(), PARTICLE_SRC, p);
            }
        }
    }

    @Override
    public int func_70302_i_() {
        return this.inv.length;
    }

    @Override
    public ItemStack func_70301_a(int index) {
        return this.inv[index];
    }

    @Override
    public ItemStack func_70298_a(int index, int count) {
        ItemStack stack = this.func_70301_a(index);
        if (stack != null) {
            if (stack.field_77994_a <= count) {
                this.func_70299_a(index, null);
            } else {
                stack = stack.func_77979_a(count);
                if (stack.field_77994_a == 0) {
                    this.func_70299_a(index, null);
                }
            }
        }
        return stack;
    }

    @Override
    public ItemStack func_70304_b(int index) {
        ItemStack stack = this.func_70301_a(index);
        if (stack != null) {
            this.func_70299_a(index, null);
        }
        return stack;
    }

    @Override
    public void func_70299_a(int index, ItemStack stack) {
        this.inv[index] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17};
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.offsetTargetX = tagCompound.func_74762_e("ox");
        this.offsetTargetY = tagCompound.func_74762_e("oy");
        this.offsetTargetZ = tagCompound.func_74762_e("oz");
        this.offsetSourceX = tagCompound.func_74762_e("sx");
        this.offsetSourceY = tagCompound.func_74762_e("sy");
        this.offsetSourceZ = tagCompound.func_74762_e("sz");
        this.sizeRadius = tagCompound.func_74762_e("r");
        this.height = tagCompound.func_74762_e("height");
        this.timer = tagCompound.func_74762_e("timer");
        this.renderParticles = tagCompound.func_74762_e("render");
        this.needsRedstone = tagCompound.func_74762_e(NBT_REDST);
        NBTTagList tagList = tagCompound.func_150295_c(NBT_INV, 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tag = tagList.func_150305_b(i);
            byte slot = tag.func_74771_c(NBT_SLOT);
            if (slot < 0 || slot >= this.inv.length) continue;
            this.inv[slot] = ItemStack.func_77949_a((NBTTagCompound)tag);
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        tagCompound.func_74768_a("ox", this.offsetTargetX);
        tagCompound.func_74768_a("oy", this.offsetTargetY);
        tagCompound.func_74768_a("oz", this.offsetTargetZ);
        tagCompound.func_74768_a("sx", this.offsetSourceX);
        tagCompound.func_74768_a("sy", this.offsetSourceY);
        tagCompound.func_74768_a("sz", this.offsetSourceZ);
        tagCompound.func_74768_a("r", this.sizeRadius);
        tagCompound.func_74768_a("height", this.height);
        tagCompound.func_74768_a("timer", this.timer);
        tagCompound.func_74768_a("render", this.renderParticles);
        tagCompound.func_74768_a(NBT_REDST, this.needsRedstone);
        NBTTagList itemList = new NBTTagList();
        for (int i = 0; i < this.inv.length; ++i) {
            ItemStack stack = this.inv[i];
            if (stack == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a(NBT_SLOT, (byte)i);
            stack.func_77955_b(tag);
            itemList.func_74742_a((NBTBase)tag);
        }
        tagCompound.func_74782_a(NBT_INV, (NBTBase)itemList);
        return super.func_189515_b(tagCompound);
    }

    public int getField(Fields f) {
        switch (f) {
            case OFFTARGX: {
                return this.offsetTargetX;
            }
            case OFFTARGY: {
                return this.offsetTargetY;
            }
            case OFFTARGZ: {
                return this.offsetTargetZ;
            }
            case SIZER: {
                return this.sizeRadius;
            }
            case OFFSRCX: {
                return this.offsetSourceX;
            }
            case OFFSRCY: {
                return this.offsetSourceY;
            }
            case OFFSRCZ: {
                return this.offsetSourceZ;
            }
            case HEIGHT: {
                return this.height;
            }
            case TIMER: {
                return this.timer;
            }
            case REDSTONE: {
                return this.needsRedstone;
            }
            case RENDERPARTICLES: {
                return this.renderParticles;
            }
        }
        return 0;
    }

    public void setField(Fields f, int value) {
        if (value > 32) {
            value = 32;
        }
        switch (f) {
            case OFFTARGX: {
                this.offsetTargetX = value;
                break;
            }
            case OFFTARGY: {
                this.offsetTargetY = value;
                break;
            }
            case OFFTARGZ: {
                this.offsetTargetZ = value;
                break;
            }
            case SIZER: {
                this.sizeRadius = value;
                break;
            }
            case OFFSRCX: {
                this.offsetSourceX = value;
                break;
            }
            case OFFSRCY: {
                this.offsetSourceY = value;
                break;
            }
            case OFFSRCZ: {
                this.offsetSourceZ = value;
                break;
            }
            case HEIGHT: {
                this.height = value;
                break;
            }
            case TIMER: {
                this.timer = value;
                break;
            }
            case REDSTONE: {
                this.needsRedstone = value;
                break;
            }
            case RENDERPARTICLES: {
                this.renderParticles = value;
                break;
            }
        }
    }

    @Override
    public int func_174887_a_(int id) {
        return this.getField(Fields.values()[id]);
    }

    @Override
    public void func_174885_b(int id, int value) {
        this.setField(Fields.values()[id], value);
    }

    public void swapTargetSource() {
        int srcX = this.offsetSourceX;
        int srcY = this.offsetSourceY;
        int srcZ = this.offsetSourceZ;
        this.offsetSourceX = this.offsetTargetX;
        this.offsetSourceY = this.offsetTargetY;
        this.offsetSourceZ = this.offsetTargetZ;
        this.offsetTargetX = srcX;
        this.offsetTargetY = srcY;
        this.offsetTargetZ = srcZ;
        this.renderBoundingBoxes();
    }

    @Override
    public void toggleNeedsRedstone() {
        int val = this.needsRedstone + 1;
        if (val > 1) {
            val = 0;
        }
        this.func_174885_b(Fields.REDSTONE.ordinal(), val);
    }

    public void swapShowRender() {
        int val = this.renderParticles + 1;
        if (val > 1) {
            val = 0;
        }
        this.func_174885_b(Fields.RENDERPARTICLES.ordinal(), val);
    }

    public static enum Fields {
        OFFTARGX,
        OFFTARGY,
        OFFTARGZ,
        SIZER,
        OFFSRCX,
        OFFSRCY,
        OFFSRCZ,
        HEIGHT,
        TIMER,
        REDSTONE,
        RENDERPARTICLES;

    }
}

