/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.tileentity;

import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.block.tileentity.ITileRedstoneToggle;
import com.lothrazar.cyclicmagic.block.tileentity.ITileSizeToggle;
import com.lothrazar.cyclicmagic.block.tileentity.TileEntityBaseMachineInvo;
import com.lothrazar.cyclicmagic.util.UtilFakePlayer;
import com.lothrazar.cyclicmagic.util.UtilItemStack;
import com.lothrazar.cyclicmagic.util.UtilParticle;
import com.lothrazar.cyclicmagic.util.UtilShape;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;

public class TileMachineMinerSmart
extends TileEntityBaseMachineInvo
implements ITileRedstoneToggle,
ITileSizeToggle,
ITickable {
    public static int maxHeight = 10;
    private boolean isCurrentlyMining;
    private float curBlockDamage;
    private BlockPos targetPos = null;
    private ItemStack[] inv = new ItemStack[5];
    private static final String NBT_INV = "Inventory";
    private static final String NBT_SLOT = "Slot";
    private static final String NBT_REDST = "redstone";
    private static final String NBTMINING = "mining";
    private static final String NBTDAMAGE = "curBlockDamage";
    private static final String NBTPLAYERID = "uuid";
    private static final String NBTTARGET = "target";
    private static final String NBTHEIGHT = "h";
    private static final String NBT_SIZE = "size";
    private static final String NBT_LIST = "blacklistIfZero";
    private static final int MAX_SIZE = 7;
    private static final int INVENTORY_SIZE = 5;
    private static final int TOOLSLOT_INDEX = 4;
    private int size = 4;
    private int needsRedstone = 1;
    private int height = 6;
    private int blacklistIfZero = 0;
    private WeakReference<FakePlayer> fakePlayer;
    private UUID uuid;

    private void verifyFakePlayer(WorldServer w) {
        if (this.fakePlayer == null) {
            this.fakePlayer = UtilFakePlayer.initFakePlayer(w, this.uuid);
            if (this.fakePlayer == null) {
                ModCyclic.logger.warn("Warning: Fake player failed to init ");
                return;
            }
        }
    }

    public void func_73660_a() {
        World world;
        if (this.isRunning()) {
            this.spawnParticlesAbove();
        }
        if ((world = this.func_145831_w()) instanceof WorldServer) {
            this.verifyUuid(world);
            this.verifyFakePlayer((WorldServer)world);
            this.tryEquipItem();
            if (this.targetPos == null) {
                this.targetPos = this.field_174879_c.func_177972_a(this.getCurrentFacing());
            }
            if (this.isRunning()) {
                if (!this.isCurrentlyMining) {
                    this.updateTargetPos();
                }
                if (this.isTargetValid()) {
                    this.isCurrentlyMining = true;
                } else {
                    this.isCurrentlyMining = false;
                    this.updateTargetPos();
                    this.resetProgress(this.targetPos);
                }
                if (this.isCurrentlyMining) {
                    IBlockState targetState = world.func_180495_p(this.targetPos);
                    this.curBlockDamage += UtilItemStack.getPlayerRelativeBlockHardness(targetState.func_177230_c(), targetState, (EntityPlayer)this.fakePlayer.get(), world, this.targetPos);
                    if (this.curBlockDamage >= 1.0f) {
                        this.isCurrentlyMining = false;
                        this.resetProgress(this.targetPos);
                        if (this.fakePlayer.get() != null) {
                            ((FakePlayer)this.fakePlayer.get()).field_71134_c.func_180237_b(this.targetPos);
                        }
                    } else {
                        world.func_175715_c(this.uuid.hashCode(), this.targetPos, (int)(this.curBlockDamage * 10.0f) - 1);
                    }
                }
            } else if (this.isCurrentlyMining) {
                this.isCurrentlyMining = false;
                this.resetProgress(this.targetPos);
            }
        }
    }

    private void tryEquipItem() {
        int toolSlot = this.inv.length - 1;
        if (this.inv[toolSlot] != null && this.inv[toolSlot].field_77994_a == 0) {
            this.inv[toolSlot] = null;
        }
        if (this.inv[toolSlot] == null) {
            ((FakePlayer)this.fakePlayer.get()).func_184611_a(EnumHand.MAIN_HAND, null);
        } else if (this.inv[toolSlot] != null && !this.inv[toolSlot].equals(((FakePlayer)this.fakePlayer.get()).func_184586_b(EnumHand.MAIN_HAND))) {
            ((FakePlayer)this.fakePlayer.get()).func_184611_a(EnumHand.MAIN_HAND, this.inv[toolSlot]);
        }
    }

    private void verifyUuid(World world) {
        if (this.uuid == null) {
            this.uuid = UUID.randomUUID();
            IBlockState state = world.func_180495_p(this.field_174879_c);
            world.func_184138_a(this.field_174879_c, state, state, 3);
        }
    }

    private boolean isTargetValid() {
        World world = this.func_145831_w();
        if (world.func_175623_d(this.targetPos) || world.func_180495_p(this.targetPos) == null) {
            return false;
        }
        IBlockState targetState = world.func_180495_p(this.targetPos);
        Block target = targetState.func_177230_c();
        if (this.blacklistIfZero == 0) {
            for (int i = 0; i < this.inv.length - 1; ++i) {
                ItemStack item;
                if (this.inv[i] == null || (item = this.inv[i]).func_77973_b() != Item.func_150898_a((Block)target)) continue;
                return false;
            }
            return true;
        }
        for (int i = 0; i < this.inv.length - 1; ++i) {
            ItemStack item;
            if (this.inv[i] == null || (item = this.inv[i]).func_77973_b() != Item.func_150898_a((Block)target)) continue;
            return true;
        }
        return false;
    }

    public BlockPos getTargetCenter() {
        return this.func_174877_v().func_177967_a(this.getCurrentFacing(), this.size + 1);
    }

    private void updateTargetPos() {
        BlockPos center;
        this.targetPos = center = this.getTargetCenter();
        if (this.height == 0) {
            this.height = 6;
        }
        World world = this.func_145831_w();
        int rollHeight = world.field_73012_v.nextInt(this.height);
        if (rollHeight > 0) {
            this.targetPos = this.targetPos.func_177967_a(EnumFacing.UP, rollHeight);
        }
        int randNS = world.field_73012_v.nextInt(this.size * 2 + 1) - this.size;
        int randEW = world.field_73012_v.nextInt(this.size * 2 + 1) - this.size;
        if (randNS > 0) {
            this.targetPos = this.targetPos.func_177967_a(EnumFacing.NORTH, randNS);
        } else if (randNS < 0) {
            this.targetPos = this.targetPos.func_177967_a(EnumFacing.SOUTH, -1 * randNS);
        }
        if (randEW > 0) {
            this.targetPos = this.targetPos.func_177967_a(EnumFacing.EAST, randEW);
        } else if (randEW < 0) {
            this.targetPos = this.targetPos.func_177967_a(EnumFacing.WEST, -1 * randEW);
        }
        this.curBlockDamage = 0.0f;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        tagCompound.func_74768_a(NBT_REDST, this.needsRedstone);
        if (this.uuid != null) {
            tagCompound.func_74778_a(NBTPLAYERID, this.uuid.toString());
        }
        if (this.targetPos != null) {
            tagCompound.func_74783_a(NBTTARGET, new int[]{this.targetPos.func_177958_n(), this.targetPos.func_177956_o(), this.targetPos.func_177952_p()});
        }
        tagCompound.func_74757_a(NBTMINING, this.isCurrentlyMining);
        tagCompound.func_74776_a(NBTDAMAGE, this.curBlockDamage);
        tagCompound.func_74768_a(NBTHEIGHT, this.height);
        tagCompound.func_74768_a(NBT_SIZE, this.size);
        tagCompound.func_74768_a(NBT_LIST, this.blacklistIfZero);
        NBTTagList itemList = new NBTTagList();
        for (int i = 0; i < this.inv.length; ++i) {
            ItemStack stack = this.inv[i];
            if (stack == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a(NBT_SLOT, (byte)i);
            stack.func_77955_b(tag);
            itemList.func_74742_a((NBTBase)tag);
        }
        tagCompound.func_74782_a(NBT_INV, (NBTBase)itemList);
        return super.func_189515_b(tagCompound);
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        int[] coords;
        super.func_145839_a(tagCompound);
        this.needsRedstone = tagCompound.func_74762_e(NBT_REDST);
        this.size = tagCompound.func_74762_e(NBT_SIZE);
        if (tagCompound.func_74764_b(NBTPLAYERID)) {
            this.uuid = UUID.fromString(tagCompound.func_74779_i(NBTPLAYERID));
        }
        if (tagCompound.func_74764_b(NBTTARGET) && (coords = tagCompound.func_74759_k(NBTTARGET)).length >= 3) {
            this.targetPos = new BlockPos(coords[0], coords[1], coords[2]);
        }
        this.isCurrentlyMining = tagCompound.func_74767_n(NBTMINING);
        this.curBlockDamage = tagCompound.func_74760_g(NBTDAMAGE);
        this.height = tagCompound.func_74762_e(NBTHEIGHT);
        this.blacklistIfZero = tagCompound.func_74762_e(NBT_LIST);
        NBTTagList tagList = tagCompound.func_150295_c(NBT_INV, 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tag = tagList.func_150305_b(i);
            byte slot = tag.func_74771_c(NBT_SLOT);
            if (slot < 0 || slot >= this.inv.length) continue;
            this.inv[slot] = ItemStack.func_77949_a((NBTTagCompound)tag);
        }
    }

    public void breakBlock(World worldIn, BlockPos pos, IBlockState state) {
        if (this.isCurrentlyMining && this.uuid != null) {
            this.resetProgress(pos);
        }
    }

    private void resetProgress(BlockPos targetPos) {
        if (this.uuid != null) {
            this.func_145831_w().func_175715_c(this.uuid.hashCode(), targetPos, -1);
            this.curBlockDamage = 0.0f;
        }
    }

    @Override
    public int func_70302_i_() {
        return this.inv.length;
    }

    @Override
    public ItemStack func_70301_a(int index) {
        return this.inv[index];
    }

    @Override
    public ItemStack func_70298_a(int index, int count) {
        ItemStack stack = this.func_70301_a(index);
        if (stack != null) {
            if (stack.field_77994_a <= count) {
                this.func_70299_a(index, null);
            } else {
                stack = stack.func_77979_a(count);
                if (stack.field_77994_a == 0) {
                    this.func_70299_a(index, null);
                }
            }
        }
        return stack;
    }

    @Override
    public ItemStack func_70304_b(int index) {
        ItemStack stack = this.func_70301_a(index);
        if (stack != null) {
            this.func_70299_a(index, null);
        }
        return stack;
    }

    @Override
    public void func_70299_a(int index, ItemStack stack) {
        this.inv[index] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        return new int[]{4};
    }

    @Override
    public int func_174887_a_(int id) {
        switch (Fields.values()[id]) {
            case HEIGHT: {
                return this.getHeight();
            }
            case REDSTONE: {
                return this.needsRedstone;
            }
            case SIZE: {
                return this.size;
            }
            case LISTTYPE: {
                return this.blacklistIfZero;
            }
        }
        return 0;
    }

    @Override
    public void func_174885_b(int id, int value) {
        switch (Fields.values()[id]) {
            case HEIGHT: {
                if (value > maxHeight) {
                    value = maxHeight;
                }
                this.setHeight(value);
            }
            case REDSTONE: {
                this.needsRedstone = value;
                break;
            }
            case SIZE: {
                this.size = value;
                break;
            }
            case LISTTYPE: {
                this.blacklistIfZero = value % 2;
                break;
            }
        }
    }

    public void toggleListType() {
        this.blacklistIfZero = (this.blacklistIfZero + 1) % 2;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int val) {
        this.height = val;
    }

    public boolean func_145842_c(int id, int value) {
        if (id >= 0 && id < this.func_174890_g()) {
            this.func_174885_b(id, value);
            return true;
        }
        return super.func_145842_c(id, value);
    }

    @Override
    public int func_174890_g() {
        return Fields.values().length;
    }

    @Override
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
        super.onDataPacket(net, pkt);
    }

    @Override
    public void toggleNeedsRedstone() {
        int val = this.needsRedstone + 1;
        if (val > 1) {
            val = 0;
        }
        this.func_174885_b(Fields.REDSTONE.ordinal(), val);
    }

    @Override
    public boolean onlyRunIfPowered() {
        return this.needsRedstone == 1;
    }

    @Override
    public void toggleSizeShape() {
        ++this.size;
        if (this.size > 7) {
            this.size = 0;
        }
    }

    @Override
    public void displayPreview() {
        for (int i = 0; i < this.getHeight(); ++i) {
            List<BlockPos> allPos = UtilShape.squareHorizontalHollow(this.getTargetCenter().func_177981_b(i), this.size);
            for (BlockPos pos : allPos) {
                UtilParticle.spawnParticle(this.func_145831_w(), EnumParticleTypes.DRAGON_BREATH, pos);
            }
        }
    }

    public static enum Fields {
        HEIGHT,
        REDSTONE,
        SIZE,
        LISTTYPE;

    }
}

