/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.tileentity;

import com.lothrazar.cyclicmagic.block.tileentity.ITileRedstoneToggle;
import com.lothrazar.cyclicmagic.block.tileentity.ITileSizeToggle;
import com.lothrazar.cyclicmagic.block.tileentity.TileEntityBaseMachineInvo;
import com.lothrazar.cyclicmagic.util.UtilItemStack;
import com.lothrazar.cyclicmagic.util.UtilParticle;
import com.lothrazar.cyclicmagic.util.UtilPlaceBlocks;
import com.lothrazar.cyclicmagic.util.UtilShape;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileMachineStructureBuilder
extends TileEntityBaseMachineInvo
implements ITileRedstoneToggle,
ITileSizeToggle,
ITickable {
    static final int spotsSkippablePerTrigger = 50;
    private static final int maxSpeed = 1;
    public static final int TIMER_FULL = 10;
    private static final int[] hopperInput = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    private static final String NBT_INV = "Inventory";
    private static final String NBT_SLOT = "Slot";
    private static final String NBT_TIMER = "Timer";
    private static final String NBT_BUILDTYPE = "build";
    private static final String NBT_SPEED = "speed";
    private static final String NBT_SIZE = "size";
    private static final String NBT_REDST = "redstone";
    private static final String NBT_SHAPEINDEX = "shapeindex";
    private int timer;
    private int buildType;
    private int buildSpeed;
    private int buildSize = 3;
    private int buildHeight = 3;
    private int needsRedstone = 1;
    private ItemStack[] inv = new ItemStack[9];
    private int shapeIndex = 0;
    public static int maxSize;
    public static int maxHeight;

    public List<BlockPos> rebuildShape() {
        BuildType buildType = this.getBuildTypeEnum();
        List<BlockPos> shape = new ArrayList<BlockPos>();
        switch (buildType) {
            case CIRCLE: {
                shape = UtilShape.circleHorizontal(this.func_174877_v(), this.getSize() * 2);
                break;
            }
            case FACING: {
                shape = UtilShape.line(this.func_174877_v(), this.getCurrentFacing(), this.getSize());
                break;
            }
            case SQUARE: {
                shape = UtilShape.squareHorizontalHollow(this.func_174877_v(), this.getSize());
                break;
            }
            case SOLID: {
                shape = UtilShape.squareHorizontalFull(this.getTargetCenter(), this.getSize());
                break;
            }
            case STAIRWAY: {
                shape = UtilShape.stairway(this.func_174877_v(), this.getCurrentFacing(), this.getSize() * 2, true);
                break;
            }
            case SPHERE: {
                shape = UtilShape.sphere(this.func_174877_v(), this.getSize());
            }
        }
        if (buildType.hasHeight() && this.buildHeight > 1) {
            shape = UtilShape.repeatShapeByHeight(shape, this.buildHeight - 1);
        }
        return shape;
    }

    public BlockPos getTargetCenter() {
        return this.func_174877_v().func_177967_a(this.getCurrentFacing(), this.getSize() + 1);
    }

    @Override
    public int func_70302_i_() {
        return this.inv.length;
    }

    @Override
    public ItemStack func_70301_a(int index) {
        return this.inv[index];
    }

    @Override
    public ItemStack func_70298_a(int index, int count) {
        ItemStack stack = this.func_70301_a(index);
        if (stack != null) {
            if (stack.field_77994_a <= count) {
                this.func_70299_a(index, null);
            } else {
                stack = stack.func_77979_a(count);
                if (stack.field_77994_a == 0) {
                    this.func_70299_a(index, null);
                }
            }
        }
        return stack;
    }

    @Override
    public void func_70299_a(int index, ItemStack stack) {
        this.inv[index] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
    }

    @Override
    public boolean func_94041_b(int index, ItemStack stack) {
        return Block.func_149634_a((Item)stack.func_77973_b()) != null;
    }

    @Override
    public int func_174887_a_(int id) {
        if (id >= 0 && id < this.func_174890_g()) {
            switch (Fields.values()[id]) {
                case TIMER: {
                    return this.timer;
                }
                case BUILDTYPE: {
                    return this.buildType;
                }
                case SPEED: {
                    return this.buildSpeed;
                }
                case SIZE: {
                    return this.buildSize;
                }
                case HEIGHT: {
                    return this.buildHeight;
                }
                case REDSTONE: {
                    return this.needsRedstone;
                }
            }
        }
        return -1;
    }

    @Override
    public void func_174885_b(int id, int value) {
        if (id >= 0 && id < this.func_174890_g()) {
            switch (Fields.values()[id]) {
                case TIMER: {
                    this.timer = value;
                    break;
                }
                case BUILDTYPE: {
                    this.buildType = value;
                    break;
                }
                case SPEED: {
                    this.buildSpeed = value;
                    break;
                }
                case SIZE: {
                    this.buildSize = value;
                    break;
                }
                case HEIGHT: {
                    if (value > maxHeight) {
                        value = maxHeight;
                    }
                    this.buildHeight = value;
                    break;
                }
                case REDSTONE: {
                    this.needsRedstone = value;
                    break;
                }
            }
        }
    }

    @Override
    public boolean onlyRunIfPowered() {
        return this.needsRedstone == 1;
    }

    public int getTimer() {
        return this.func_174887_a_(Fields.TIMER.ordinal());
    }

    public int getHeight() {
        return this.func_174887_a_(Fields.HEIGHT.ordinal());
    }

    public void setHeight(int value) {
        this.func_174885_b(Fields.HEIGHT.ordinal(), value);
    }

    public int getBuildType() {
        return this.func_174887_a_(Fields.BUILDTYPE.ordinal());
    }

    public void setBuildType(int value) {
        this.func_174885_b(Fields.BUILDTYPE.ordinal(), value);
    }

    public BuildType getBuildTypeEnum() {
        int bt = Math.min(this.getBuildType(), BuildType.values().length - 1);
        return BuildType.values()[bt];
    }

    public void setSpeed(int s) {
        if (s <= 0) {
            s = 1;
        }
        if (s >= 1) {
            s = 1;
        }
        this.func_174885_b(Fields.SPEED.ordinal(), s);
    }

    public int getSpeed() {
        int s = this.func_174887_a_(Fields.SPEED.ordinal());
        if (s <= 0) {
            s = 1;
        }
        return s;
    }

    public void setSize(int s) {
        if (s <= 0) {
            s = 1;
        }
        if (s >= maxSize) {
            s = maxSize;
        }
        this.func_174885_b(Fields.SIZE.ordinal(), s);
    }

    public int getSize() {
        int s = this.func_174887_a_(Fields.SIZE.ordinal());
        if (s <= 0) {
            s = 1;
        }
        return s;
    }

    @Override
    public int func_174890_g() {
        return Fields.values().length;
    }

    @Override
    public void func_174888_l() {
        for (int i = 0; i < this.inv.length; ++i) {
            this.inv[i] = null;
        }
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.needsRedstone = tagCompound.func_74762_e(NBT_REDST);
        this.timer = tagCompound.func_74762_e(NBT_TIMER);
        this.shapeIndex = tagCompound.func_74762_e(NBT_SHAPEINDEX);
        NBTTagList tagList = tagCompound.func_150295_c(NBT_INV, 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tag = tagList.func_150305_b(i);
            byte slot = tag.func_74771_c(NBT_SLOT);
            if (slot < 0 || slot >= this.inv.length) continue;
            this.inv[slot] = ItemStack.func_77949_a((NBTTagCompound)tag);
        }
        this.buildType = tagCompound.func_74762_e(NBT_BUILDTYPE);
        this.buildSpeed = tagCompound.func_74762_e(NBT_SPEED);
        this.buildSize = tagCompound.func_74762_e(NBT_SIZE);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        tagCompound.func_74768_a(NBT_TIMER, this.timer);
        tagCompound.func_74768_a(NBT_REDST, this.needsRedstone);
        tagCompound.func_74768_a(NBT_SHAPEINDEX, this.shapeIndex);
        NBTTagList itemList = new NBTTagList();
        for (int i = 0; i < this.inv.length; ++i) {
            ItemStack stack = this.inv[i];
            if (stack == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a(NBT_SLOT, (byte)i);
            stack.func_77955_b(tag);
            itemList.func_74742_a((NBTBase)tag);
        }
        tagCompound.func_74782_a(NBT_INV, (NBTBase)itemList);
        tagCompound.func_74768_a(NBT_BUILDTYPE, this.getBuildType());
        tagCompound.func_74768_a(NBT_SPEED, this.getSpeed());
        tagCompound.func_74768_a(NBT_SIZE, this.getSize());
        return super.func_189515_b(tagCompound);
    }

    public boolean isBurning() {
        return this.timer > 0 && this.timer < 10;
    }

    @Override
    public boolean isRunning() {
        return !this.onlyRunIfPowered() || this.isPowered();
    }

    public void func_73660_a() {
        Block stuff;
        this.shiftAllUp();
        boolean trigger = false;
        if (!this.isRunning()) {
            return;
        }
        this.spawnParticlesAbove();
        World world = this.func_145831_w();
        ItemStack stack = this.func_70301_a(0);
        if (stack != null) {
            this.timer -= this.getSpeed();
            if (this.timer <= 0) {
                this.timer = 10;
                trigger = true;
            }
        }
        if (trigger && (stuff = Block.func_149634_a((Item)stack.func_77973_b())) != null) {
            List<BlockPos> shape = this.rebuildShape();
            if (shape.size() == 0) {
                return;
            }
            if (this.shapeIndex < 0 || this.shapeIndex >= shape.size()) {
                this.shapeIndex = 0;
            }
            BlockPos nextPos = shape.get(this.shapeIndex);
            for (int i = 0; i < 50; ++i) {
                if (world.func_175623_d(nextPos) && stuff.func_176196_c(world, nextPos) && world.func_175716_a(stuff, nextPos, false, EnumFacing.UP, null, stack)) {
                    IBlockState placeState = UtilItemStack.getStateFromMeta(stuff, stack.func_77960_j());
                    if (world.field_72995_K || !world.func_175623_d(nextPos) || !UtilPlaceBlocks.placeStateSafe(world, null, nextPos, placeState)) break;
                    this.func_70298_a(0, 1);
                    break;
                }
                nextPos = shape.get(this.shapeIndex);
                this.incrementPosition(shape);
            }
        }
    }

    private void incrementPosition(List<BlockPos> shape) {
        if (shape == null || shape.size() == 0) {
            return;
        }
        int c = this.shapeIndex + 1;
        if (c < 0 || c >= shape.size()) {
            c = 0;
        }
        this.shapeIndex = c;
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        return hopperInput;
    }

    @Override
    public ItemStack func_70304_b(int index) {
        ItemStack stack = this.func_70301_a(index);
        if (stack != null) {
            this.func_70299_a(index, null);
        }
        return stack;
    }

    public boolean func_145842_c(int id, int value) {
        if (id >= 0 && id < this.func_174890_g()) {
            this.func_174885_b(id, value);
            return true;
        }
        return super.func_145842_c(id, value);
    }

    @Override
    public void toggleNeedsRedstone() {
        int val = this.needsRedstone + 1;
        if (val > 1) {
            val = 0;
        }
        this.func_174885_b(Fields.REDSTONE.ordinal(), val);
    }

    @Override
    public void toggleSizeShape() {
        BuildType old = this.getBuildTypeEnum();
        BuildType next = BuildType.getNextType(old);
        this.setBuildType(next.ordinal());
    }

    @Override
    public void displayPreview() {
        List<BlockPos> shape;
        if (this.buildType == BuildType.SPHERE.ordinal()) {
            shape = UtilShape.circleHorizontal(this.func_174877_v(), this.getSize() * 2);
            shape.addAll(UtilShape.circleVertical(this.func_174877_v(), this.getSize() * 2));
        } else {
            shape = this.rebuildShape();
        }
        for (BlockPos pos : shape) {
            UtilParticle.spawnParticle(this.func_145831_w(), EnumParticleTypes.DRAGON_BREATH, pos, 2);
        }
    }

    static {
        maxHeight = 10;
    }

    public static enum BuildType {
        FACING,
        SQUARE,
        CIRCLE,
        SOLID,
        STAIRWAY,
        SPHERE;


        public static BuildType getNextType(BuildType btype) {
            int type = btype.ordinal();
            if (++type > SPHERE.ordinal()) {
                type = FACING.ordinal();
            }
            return BuildType.values()[type];
        }

        public boolean hasHeight() {
            return this != STAIRWAY && this != SPHERE;
        }
    }

    public static enum Fields {
        TIMER,
        BUILDTYPE,
        SPEED,
        SIZE,
        HEIGHT,
        REDSTONE;

    }
}

