/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.tileentity;

import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.block.tileentity.ITileRedstoneToggle;
import com.lothrazar.cyclicmagic.block.tileentity.TileEntityBaseMachineInvo;
import com.lothrazar.cyclicmagic.util.UtilEntity;
import com.lothrazar.cyclicmagic.util.UtilFakePlayer;
import com.lothrazar.cyclicmagic.util.UtilFluid;
import com.lothrazar.cyclicmagic.util.UtilItemStack;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeMap;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileMachineUser
extends TileEntityBaseMachineInvo
implements ITileRedstoneToggle,
ITickable {
    public static int maxHeight = 10;
    public static int TIMER_FULL = 80;
    private ItemStack[] inv;
    private int[] hopperInput = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    final int RADIUS = 4;
    private static final String NBTPLAYERID = "uuid";
    private static final String NBT_TIMER = "Timer";
    private static final String NBT_REDST = "redstone";
    private static final String NBT_SPEED = "h";
    private static final String NBT_LR = "lr";
    private int speed = 1;
    private int rightClickIfZero = 0;
    private WeakReference<FakePlayer> fakePlayer;
    private UUID uuid;
    private int timer;
    private int needsRedstone = 1;
    int toolSlot = 0;

    public TileMachineUser() {
        this.inv = new ItemStack[9];
        this.timer = TIMER_FULL;
    }

    public void func_73660_a() {
        World world;
        this.shiftAllUp();
        if (this.isRunning()) {
            this.spawnParticlesAbove();
        }
        if ((world = this.func_145831_w()) instanceof WorldServer) {
            this.verifyUuid(world);
            if (this.fakePlayer == null) {
                this.fakePlayer = UtilFakePlayer.initFakePlayer((WorldServer)world, this.uuid);
                if (this.fakePlayer == null) {
                    ModCyclic.logger.warn("Warning: Fake player failed to init ");
                    return;
                }
            }
            ItemStack maybeTool = this.tryEquipItem();
            if (this.isRunning()) {
                this.timer -= this.getSpeed();
                if (this.timer <= 0) {
                    this.timer = 0;
                }
                if (this.timer == 0) {
                    try {
                        this.timer = TIMER_FULL;
                        BlockPos targetPos = this.getCurrentFacingPos();
                        int hRange = 2;
                        int vRange = 1;
                        BlockPos entityCenter = this.func_174877_v().func_177967_a(this.getCurrentFacing(), 1);
                        if (this.rightClickIfZero == 0) {
                            if (maybeTool != null && maybeTool.func_77973_b() instanceof ItemBucket) {
                                TileEntity tank = world.func_175625_s(targetPos);
                                IFluidHandler f = UtilFluid.getFluidHandler(tank, this.getCurrentFacing().func_176734_d());
                                if (f != null) {
                                    int sizeBefore = maybeTool.field_77994_a;
                                    boolean success = FluidUtil.interactWithFluidHandler((ItemStack)maybeTool, (IFluidHandler)f, (EntityPlayer)((EntityPlayer)this.fakePlayer.get()));
                                    int AFTER = maybeTool.field_77994_a;
                                    if (success) {
                                        if (sizeBefore == AFTER) {
                                            UtilItemStack.dropItemStackInWorld(this.field_145850_b, this.getCurrentFacingPos(), maybeTool.func_77979_a(1));
                                        }
                                        this.tryDumpFakePlayerInvo();
                                    }
                                } else {
                                    ItemStack r = UtilFluid.dispenseStack(world, targetPos, maybeTool, this.getCurrentFacing());
                                    if (r != null) {
                                        --maybeTool.field_77994_a;
                                        UtilItemStack.dropItemStackInWorld(this.field_145850_b, this.getCurrentFacingPos(), r);
                                    }
                                }
                            } else {
                                if (world.func_175623_d(targetPos)) {
                                    targetPos = targetPos.func_177977_b();
                                }
                                ((FakePlayer)this.fakePlayer.get()).field_71134_c.func_187251_a((EntityPlayer)this.fakePlayer.get(), world, maybeTool, EnumHand.MAIN_HAND, targetPos, EnumFacing.UP, 0.5f, 0.5f, 0.5f);
                            }
                            this.func_145831_w().func_175646_b(targetPos, (TileEntity)this);
                            AxisAlignedBB range = UtilEntity.makeBoundingBox(entityCenter, hRange, vRange);
                            List all = world.func_72872_a(EntityLivingBase.class, range);
                            for (EntityLivingBase ent : all) {
                                if (world.field_72995_K || ent == null || ent.field_70128_L || this.fakePlayer == null || this.fakePlayer.get() == null) continue;
                                this.validateTool();
                                if (((FakePlayer)this.fakePlayer.get()).func_184822_a((Entity)ent, maybeTool, EnumHand.MAIN_HAND) == EnumActionResult.FAIL) continue;
                                this.tryDumpFakePlayerInvo();
                                break;
                            }
                            this.tryDumpFakePlayerInvo();
                        }
                        AxisAlignedBB range = UtilEntity.makeBoundingBox(entityCenter, 1, 1);
                        List all = world.func_72872_a(EntityLivingBase.class, range);
                        ItemStack held = ((FakePlayer)this.fakePlayer.get()).func_184614_ca();
                        ((FakePlayer)this.fakePlayer.get()).field_70122_E = true;
                        for (EntityLivingBase ent : all) {
                            ((FakePlayer)this.fakePlayer.get()).func_71059_n((Entity)ent);
                            IAttributeInstance damage = new AttributeMap().func_111150_b(SharedMonsterAttributes.field_111264_e);
                            if (held != null) {
                                for (AttributeModifier modifier : held.func_111283_C(EntityEquipmentSlot.MAINHAND).get((Object)SharedMonsterAttributes.field_111264_e.func_111108_a())) {
                                    damage.func_111121_a(modifier);
                                }
                            }
                            float dmgVal = (float)damage.func_111126_e();
                            float f1 = EnchantmentHelper.func_152377_a((ItemStack)held, (EnumCreatureAttribute)ent.func_70668_bt());
                            ent.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)this.fakePlayer.get())), dmgVal + f1);
                        }
                    }
                    catch (Exception e) {
                        ModCyclic.logger.error("Automated User Error");
                        ModCyclic.logger.error(e.getLocalizedMessage());
                        e.printStackTrace();
                    }
                }
            } else {
                this.timer = 1;
            }
        }
    }

    private void tryDumpFakePlayerInvo() {
        for (ItemStack s : ((FakePlayer)this.fakePlayer.get()).field_71071_by.field_70462_a) {
            if (s == null || s.equals(((FakePlayer)this.fakePlayer.get()).func_184614_ca())) continue;
            UtilItemStack.dropItemStackInWorld(this.field_145850_b, this.getCurrentFacingPos(), s.func_77946_l());
            s.field_77994_a = 0;
            s = null;
        }
    }

    private void validateTool() {
        ItemStack maybeTool = this.func_70301_a(this.toolSlot);
        if (maybeTool != null && maybeTool.field_77994_a < 0) {
            maybeTool = null;
            ((FakePlayer)this.fakePlayer.get()).func_184611_a(EnumHand.MAIN_HAND, null);
            this.inv[this.toolSlot] = null;
        }
    }

    private ItemStack tryEquipItem() {
        ItemStack maybeTool = this.func_70301_a(this.toolSlot);
        if (maybeTool != null && maybeTool.field_77994_a <= 0) {
            maybeTool = null;
        }
        ((FakePlayer)this.fakePlayer.get()).func_70107_b((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p());
        ((FakePlayer)this.fakePlayer.get()).func_70071_h_();
        if (maybeTool == null) {
            ((FakePlayer)this.fakePlayer.get()).func_184611_a(EnumHand.MAIN_HAND, null);
            this.inv[this.toolSlot] = null;
        } else if (!maybeTool.equals(((FakePlayer)this.fakePlayer.get()).func_184586_b(EnumHand.MAIN_HAND))) {
            ((FakePlayer)this.fakePlayer.get()).func_184611_a(EnumHand.MAIN_HAND, maybeTool);
        }
        return maybeTool;
    }

    private void verifyUuid(World world) {
        if (this.uuid == null) {
            this.uuid = UUID.randomUUID();
            IBlockState state = world.func_180495_p(this.field_174879_c);
            world.func_184138_a(this.field_174879_c, state, state, 3);
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        tagCompound.func_74768_a(NBT_TIMER, this.timer);
        if (this.uuid != null) {
            tagCompound.func_74778_a(NBTPLAYERID, this.uuid.toString());
        }
        tagCompound.func_74768_a(NBT_REDST, this.needsRedstone);
        tagCompound.func_74768_a(NBT_SPEED, this.speed);
        tagCompound.func_74768_a(NBT_LR, this.rightClickIfZero);
        NBTTagList itemList = new NBTTagList();
        for (int i = 0; i < this.inv.length; ++i) {
            ItemStack stack = this.inv[i];
            if (stack == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("Slot", (byte)i);
            stack.func_77955_b(tag);
            itemList.func_74742_a((NBTBase)tag);
        }
        tagCompound.func_74782_a("Inventory", (NBTBase)itemList);
        return super.func_189515_b(tagCompound);
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.timer = tagCompound.func_74762_e(NBT_TIMER);
        if (tagCompound.func_74764_b(NBTPLAYERID)) {
            this.uuid = UUID.fromString(tagCompound.func_74779_i(NBTPLAYERID));
        }
        this.needsRedstone = tagCompound.func_74762_e(NBT_REDST);
        this.rightClickIfZero = tagCompound.func_74762_e(NBT_LR);
        this.speed = tagCompound.func_74762_e(NBT_SPEED);
        NBTTagList tagList = tagCompound.func_150295_c("Inventory", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tag = tagList.func_150305_b(i);
            byte slot = tag.func_74771_c("Slot");
            if (slot < 0 || slot >= this.inv.length) continue;
            this.inv[slot] = ItemStack.func_77949_a((NBTTagCompound)tag);
        }
    }

    @Override
    public int func_70302_i_() {
        return this.inv.length;
    }

    @Override
    public ItemStack func_70301_a(int index) {
        return this.inv[index];
    }

    @Override
    public ItemStack func_70298_a(int index, int count) {
        ItemStack stack = this.func_70301_a(index);
        if (stack != null) {
            if (stack.field_77994_a <= count) {
                this.func_70299_a(index, null);
            } else {
                stack = stack.func_77979_a(count);
                if (stack.field_77994_a == 0) {
                    this.func_70299_a(index, null);
                }
            }
        }
        return stack;
    }

    @Override
    public ItemStack func_70304_b(int index) {
        ItemStack stack = this.func_70301_a(index);
        if (stack != null) {
            this.func_70299_a(index, null);
        }
        return stack;
    }

    @Override
    public void func_70299_a(int index, ItemStack stack) {
        this.inv[index] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        return this.hopperInput;
    }

    @Override
    public int func_174887_a_(int id) {
        switch (Fields.values()[id]) {
            case SPEED: {
                return this.getSpeed();
            }
            case TIMER: {
                return this.getTimer();
            }
            case REDSTONE: {
                return this.needsRedstone;
            }
            default: {
                break;
            }
            case LEFTRIGHT: {
                return this.rightClickIfZero;
            }
        }
        return 0;
    }

    @Override
    public void func_174885_b(int id, int value) {
        switch (Fields.values()[id]) {
            case SPEED: {
                if (value > maxHeight) {
                    value = maxHeight;
                }
                this.setSpeed(value);
                break;
            }
            case TIMER: {
                this.timer = value;
                if (this.timer > TIMER_FULL) {
                    this.timer = TIMER_FULL;
                }
                if (this.timer >= 0) break;
                this.timer = 0;
                break;
            }
            case REDSTONE: {
                this.needsRedstone = value;
                break;
            }
            case LEFTRIGHT: {
                this.rightClickIfZero = value;
            }
        }
    }

    public int getSpeed() {
        return this.speed;
    }

    public void setSpeed(int val) {
        this.speed = val;
    }

    public boolean func_145842_c(int id, int value) {
        if (id >= 0 && id < this.func_174890_g()) {
            this.func_174885_b(id, value);
            return true;
        }
        return super.func_145842_c(id, value);
    }

    @Override
    public int func_174890_g() {
        return Fields.values().length;
    }

    @Override
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
        super.onDataPacket(net, pkt);
    }

    public int getTimer() {
        return this.timer;
    }

    @Override
    public void toggleNeedsRedstone() {
        int val = this.needsRedstone == 1 ? 0 : 1;
        this.func_174885_b(Fields.REDSTONE.ordinal(), val);
    }

    public void toggleLeftRight() {
        int val = this.rightClickIfZero == 1 ? 0 : 1;
        this.func_174885_b(Fields.LEFTRIGHT.ordinal(), val);
    }

    @Override
    public boolean onlyRunIfPowered() {
        return this.needsRedstone == 1;
    }

    public static enum Fields {
        TIMER,
        SPEED,
        REDSTONE,
        LEFTRIGHT;

    }
}

