/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.gui.storage;

import com.lothrazar.cyclicmagic.util.UtilNBT;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.text.ITextComponent;

public class InventoryStorage
implements IInventory {
    public static final int INV_SIZE = 66;
    private ItemStack[] inventory = new ItemStack[66];
    private final ItemStack internalWand;
    private EntityPlayer thePlayer;

    public EntityPlayer getPlayer() {
        return this.thePlayer;
    }

    public InventoryStorage(EntityPlayer player, ItemStack wand) {
        this.internalWand = wand;
        this.inventory = InventoryStorage.readFromNBT(this.internalWand);
        this.thePlayer = player;
    }

    public String func_70005_c_() {
        return "";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return null;
    }

    public int func_70302_i_() {
        return 66;
    }

    public ItemStack func_70301_a(int index) {
        return this.inventory[index];
    }

    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null) {
            if (stack.field_77994_a > amount) {
                stack = stack.func_77979_a(amount);
                this.func_70296_d();
            } else {
                this.func_70299_a(slot, null);
            }
        }
        return stack;
    }

    public ItemStack func_70304_b(int index) {
        ItemStack stack = this.func_70301_a(index);
        this.func_70299_a(index, null);
        return stack;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inventory[slot] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
        int i;
        if (this.internalWand == null) {
            return;
        }
        for (i = 0; i < this.func_70302_i_(); ++i) {
            if (this.func_70301_a(i) == null || this.func_70301_a((int)i).field_77994_a != 0) continue;
            this.inventory[i] = null;
        }
        for (i = 0; i < this.thePlayer.field_71071_by.func_70302_i_(); ++i) {
            if (this.thePlayer.field_71071_by.func_70301_a(i) == null || this.thePlayer.field_71071_by.func_70301_a((int)i).field_77994_a != 0) continue;
            this.thePlayer.field_71071_by.func_70299_a(i, null);
        }
        InventoryStorage.writeToNBT(this.internalWand, this.inventory);
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    public static int countNonEmpty(ItemStack stack) {
        ItemStack[] inv = InventoryStorage.readFromNBT(stack);
        int count = 0;
        for (int i = 0; i < inv.length; ++i) {
            if (inv[i] == null) continue;
            ++count;
        }
        return count;
    }

    public static ItemStack[] readFromNBT(ItemStack stack) {
        ItemStack[] inv = new ItemStack[66];
        if (stack == null) {
            return inv;
        }
        NBTTagList items = UtilNBT.getItemStackNBT(stack).func_150295_c("ItemInventory", 10);
        for (int i = 0; i < items.func_74745_c(); ++i) {
            NBTTagCompound item = items.func_150305_b(i);
            int slot = item.func_74762_e("Slot");
            if (slot < 0 || slot >= 66) continue;
            inv[slot] = ItemStack.func_77949_a((NBTTagCompound)item);
        }
        return inv;
    }

    public static void writeToNBT(ItemStack item, ItemStack[] theInventory) {
        if (item == null) {
            return;
        }
        NBTTagCompound tagcompound = UtilNBT.getItemStackNBT(item);
        NBTTagList items = new NBTTagList();
        for (int i = 0; i < theInventory.length; ++i) {
            ItemStack stack = theInventory[i];
            if (stack != null && stack.field_77994_a == 0) {
                stack = null;
            }
            if (stack == null) continue;
            NBTTagCompound itemTags = new NBTTagCompound();
            itemTags.func_74768_a("Slot", i);
            stack.func_77955_b(itemTags);
            items.func_74742_a((NBTBase)itemTags);
        }
        tagcompound.func_74782_a("ItemInventory", (NBTBase)items);
    }

    public static void decrementSlot(ItemStack stack, int itemSlot) {
        ItemStack[] invv = InventoryStorage.readFromNBT(stack);
        --invv[itemSlot].field_77994_a;
        if (invv[itemSlot].field_77994_a == 0) {
            invv[itemSlot] = null;
        }
        InventoryStorage.writeToNBT(stack, invv);
    }

    public static ItemStack getFromSlot(ItemStack stack, int i) {
        if (i < 0 || i >= 66) {
            return null;
        }
        return InventoryStorage.readFromNBT(stack)[i];
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }
}

