/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.item.tool;

import com.lothrazar.cyclicmagic.IHasRecipe;
import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.item.BaseTool;
import com.lothrazar.cyclicmagic.module.ItemToolsModule;
import com.lothrazar.cyclicmagic.net.PacketSwapBlock;
import com.lothrazar.cyclicmagic.registry.SoundRegistry;
import com.lothrazar.cyclicmagic.util.UtilChat;
import com.lothrazar.cyclicmagic.util.UtilNBT;
import com.lothrazar.cyclicmagic.util.UtilPlayer;
import com.lothrazar.cyclicmagic.util.UtilSound;
import java.util.ConcurrentModificationException;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemToolSwap
extends BaseTool
implements IHasRecipe {
    private static final int durability = 1000;
    private static final int COOLDOWN = 30;
    public static String[] swapBlacklist;
    private WandType wandType;

    public ItemToolSwap(WandType t) {
        super(1000);
        this.setWandType(t);
    }

    @SubscribeEvent
    public void onHit(PlayerInteractEvent.LeftClickBlock event) {
        EntityPlayer player = event.getEntityPlayer();
        ItemStack held = player.func_184586_b(event.getHand());
        if (held != null && held.func_77973_b() == this) {
            if (ActionType.getTimeout(held) > 0) {
                return;
            }
            ActionType.setTimeout(held);
            event.setCanceled(true);
            UtilSound.playSound(player, player.func_180425_c(), SoundRegistry.dcoin, SoundCategory.PLAYERS);
            if (!player.func_130014_f_().field_72995_K) {
                ActionType.toggle(held);
                UtilChat.addChatMessage(player, UtilChat.lang(ActionType.getName(held)));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onRender(RenderGameOverlayEvent.Post event) {
        int slot;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        ItemStack held = player.func_184586_b(EnumHand.MAIN_HAND);
        if (event.isCanceled() || event.getType() != RenderGameOverlayEvent.ElementType.EXPERIENCE) {
            return;
        }
        if (held != null && held.func_77973_b() == this && (slot = UtilPlayer.getFirstSlotWithBlock((EntityPlayer)player)) >= 0) {
            ItemStack stack = player.field_71071_by.func_70301_a(slot);
            int leftOff = 0;
            int rightOff = -18;
            int topOff = 0;
            int bottOff = 0;
            int xmain = ItemToolsModule.RenderLoc.locToX(ItemToolsModule.renderLocation, leftOff, rightOff);
            int ymain = ItemToolsModule.RenderLoc.locToY(ItemToolsModule.renderLocation, topOff, bottOff);
            if (stack != null) {
                ModCyclic.proxy.renderItemOnScreen(stack, xmain, ymain);
            }
        }
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer player, World worldObj, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        try {
            if (worldObj.field_72995_K) {
                ModCyclic.network.sendToServer((IMessage)new PacketSwapBlock(pos, side, ActionType.values()[ActionType.get(stack)], this.getWandType()));
            }
            player.func_184609_a(hand);
            player.func_184811_cZ().func_185145_a((Item)this, 30);
        }
        catch (ConcurrentModificationException e) {
            ModCyclic.logger.warn("ConcurrentModificationException");
            ModCyclic.logger.warn(e.getMessage());
            ModCyclic.logger.warn(e.getStackTrace().toString());
        }
        return super.func_180614_a(stack, player, worldObj, pos, hand, side, hitX, hitY, hitZ);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        tooltip.add(TextFormatting.GREEN + UtilChat.lang(ActionType.getName(stack)));
        super.func_77624_a(stack, playerIn, tooltip, advanced);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        ActionType.tickTimeout(stack);
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    @Override
    public void addRecipe() {
        ItemStack ingredient = null;
        switch (this.getWandType()) {
            case MATCH: {
                ingredient = new ItemStack(Items.field_151166_bC);
                break;
            }
            case NORMAL: {
                ingredient = new ItemStack(Blocks.field_150368_y);
            }
        }
        GameRegistry.addRecipe((ItemStack)new ItemStack((Item)this), (Object[])new Object[]{" gi", "oig", "oo ", Character.valueOf('i'), Blocks.field_150339_S, Character.valueOf('g'), ingredient, Character.valueOf('o'), Blocks.field_150343_Z});
    }

    public WandType getWandType() {
        return this.wandType;
    }

    public void setWandType(WandType wandType) {
        this.wandType = wandType;
    }

    public static enum ActionType {
        SINGLE,
        X3,
        X5,
        X7,
        X9;

        private static final String NBT = "ActionType";
        private static final String NBTTIMEOUT = "timeout";

        public static int getTimeout(ItemStack wand) {
            return UtilNBT.getItemStackNBT(wand).func_74762_e(NBTTIMEOUT);
        }

        public static void setTimeout(ItemStack wand) {
            UtilNBT.getItemStackNBT(wand).func_74768_a(NBTTIMEOUT, 15);
        }

        public static void tickTimeout(ItemStack wand) {
            NBTTagCompound tags = UtilNBT.getItemStackNBT(wand);
            int t = tags.func_74762_e(NBTTIMEOUT);
            if (t > 0) {
                UtilNBT.getItemStackNBT(wand).func_74768_a(NBTTIMEOUT, t - 1);
            }
        }

        public static int get(ItemStack wand) {
            if (wand == null) {
                return 0;
            }
            NBTTagCompound tags = UtilNBT.getItemStackNBT(wand);
            return tags.func_74762_e(NBT);
        }

        public static String getName(ItemStack wand) {
            try {
                NBTTagCompound tags = UtilNBT.getItemStackNBT(wand);
                return "tool.action." + ActionType.values()[tags.func_74762_e(NBT)].toString().toLowerCase();
            }
            catch (Exception e) {
                return "tool.action." + SINGLE.toString().toLowerCase();
            }
        }

        public static void toggle(ItemStack wand) {
            NBTTagCompound tags = UtilNBT.getItemStackNBT(wand);
            int type = tags.func_74762_e(NBT);
            if (++type > X9.ordinal()) {
                type = SINGLE.ordinal();
            }
            tags.func_74768_a(NBT, type);
            wand.func_77982_d(tags);
        }
    }

    public static enum WandType {
        NORMAL,
        MATCH;

    }
}

