/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.module;

import com.lothrazar.cyclicmagic.IHasConfig;
import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.block.BlockHarvester;
import com.lothrazar.cyclicmagic.block.BlockMiner;
import com.lothrazar.cyclicmagic.block.BlockMinerSmart;
import com.lothrazar.cyclicmagic.block.BlockPassword;
import com.lothrazar.cyclicmagic.block.BlockPatternBuilder;
import com.lothrazar.cyclicmagic.block.BlockPlacer;
import com.lothrazar.cyclicmagic.block.BlockStructureBuilder;
import com.lothrazar.cyclicmagic.block.BlockUncrafting;
import com.lothrazar.cyclicmagic.block.BlockUser;
import com.lothrazar.cyclicmagic.block.BlockXpPylon;
import com.lothrazar.cyclicmagic.block.tileentity.TileEntityPassword;
import com.lothrazar.cyclicmagic.block.tileentity.TileEntityPatternBuilder;
import com.lothrazar.cyclicmagic.block.tileentity.TileEntityXpPylon;
import com.lothrazar.cyclicmagic.block.tileentity.TileMachineBlockMiner;
import com.lothrazar.cyclicmagic.block.tileentity.TileMachineHarvester;
import com.lothrazar.cyclicmagic.block.tileentity.TileMachineMinerSmart;
import com.lothrazar.cyclicmagic.block.tileentity.TileMachinePlacer;
import com.lothrazar.cyclicmagic.block.tileentity.TileMachineStructureBuilder;
import com.lothrazar.cyclicmagic.block.tileentity.TileMachineUncrafter;
import com.lothrazar.cyclicmagic.block.tileentity.TileMachineUser;
import com.lothrazar.cyclicmagic.module.BaseModule;
import com.lothrazar.cyclicmagic.registry.BlockRegistry;
import com.lothrazar.cyclicmagic.registry.ConfigRegistry;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class BlockMachineModule
extends BaseModule
implements IHasConfig {
    private boolean enableUncrafter;
    private boolean enableBuilderBlock;
    private boolean enableHarvester;
    private boolean enableMiner;
    private boolean enableMinerEnhanced;
    private boolean enablePlacer;
    private boolean enablePassword;
    private boolean enableMinerSmart;
    private boolean enableUser;
    private boolean enablePattern;

    @Override
    public void onInit() {
        BlockXpPylon exp_pylon = new BlockXpPylon();
        BlockRegistry.registerBlock(exp_pylon, "exp_pylon");
        GameRegistry.registerTileEntity(TileEntityXpPylon.class, (String)"exp_pylon_te");
        if (this.enablePattern) {
            BlockPatternBuilder builder_pattern = new BlockPatternBuilder();
            BlockRegistry.registerBlock(builder_pattern, "builder_pattern");
            GameRegistry.registerTileEntity(TileEntityPatternBuilder.class, (String)"builder_pattern_te");
        }
        if (this.enableBuilderBlock) {
            BlockStructureBuilder builder_block = new BlockStructureBuilder();
            BlockRegistry.registerBlock(builder_block, "builder_block");
            GameRegistry.registerTileEntity(TileMachineStructureBuilder.class, (String)"builder_te");
        }
        if (this.enableHarvester) {
            BlockHarvester harvester_block = new BlockHarvester();
            BlockRegistry.registerBlock(harvester_block, "harvester_block");
            GameRegistry.registerTileEntity(TileMachineHarvester.class, (String)"harveseter_te");
            ConfigRegistry.register(harvester_block);
        }
        if (this.enableUncrafter) {
            BlockUncrafting uncrafting_block = new BlockUncrafting();
            BlockRegistry.registerBlock(uncrafting_block, "uncrafting_block");
            GameRegistry.registerTileEntity(TileMachineUncrafter.class, (String)"uncrafting_block_te");
        }
        if (this.enableMiner) {
            BlockMiner miner_block = new BlockMiner(BlockMiner.MinerType.SINGLE);
            BlockRegistry.registerBlock(miner_block, "block_miner");
        }
        if (this.enableMinerEnhanced) {
            BlockMiner block_miner_tunnel = new BlockMiner(BlockMiner.MinerType.TUNNEL);
            BlockRegistry.registerBlock(block_miner_tunnel, "block_miner_tunnel");
        }
        if (this.enableMiner || this.enableMinerEnhanced) {
            GameRegistry.registerTileEntity(TileMachineBlockMiner.class, (String)"miner_te");
        }
        if (this.enableMinerSmart) {
            BlockMinerSmart block_miner_smart = new BlockMinerSmart();
            BlockRegistry.registerBlock(block_miner_smart, "block_miner_smart");
            GameRegistry.registerTileEntity(TileMachineMinerSmart.class, (String)"cyclicmagicminer_smart_te");
        }
        if (this.enablePlacer) {
            BlockPlacer placer_block = new BlockPlacer();
            BlockRegistry.registerBlock(placer_block, "placer_block");
            GameRegistry.registerTileEntity(TileMachinePlacer.class, (String)"placer_block_te");
        }
        if (this.enablePassword) {
            BlockPassword password_block = new BlockPassword();
            BlockRegistry.registerBlock(password_block, "password_block");
            GameRegistry.registerTileEntity(TileEntityPassword.class, (String)"password_block_te");
            ModCyclic.instance.events.register(password_block);
        }
        if (this.enableUser) {
            BlockUser block_user = new BlockUser();
            BlockRegistry.registerBlock(block_user, "block_user");
            GameRegistry.registerTileEntity(TileMachineUser.class, (String)"cyclicmagicblock_user_te");
        }
    }

    @Override
    public void syncConfig(Configuration config) {
        this.enablePattern = config.getBoolean("PatternReplicator", "cyclicmagic.content", true, "Set false to delete - requires restart");
        this.enableUser = config.getBoolean("AutomatedUser", "cyclicmagic.content", true, "Set false to delete - requires restart");
        this.enablePassword = config.getBoolean("PasswordTrigger", "cyclicmagic.content", true, "Set false to delete - requires restart");
        this.enablePlacer = config.getBoolean("BlockPlacer", "cyclicmagic.content", true, "Set false to delete - requires restart");
        this.enableMiner = config.getBoolean("MinerBlock", "cyclicmagic.content", true, "Set false to delete - requires restart.  This is the one that mines a single block");
        this.enableMinerEnhanced = config.getBoolean("MinerBlockAdvanced", "cyclicmagic.content", true, "Set false to delete - requires restart.  This is the one that mines a 3x3x3 area");
        this.enableBuilderBlock = config.getBoolean("BuilderBlock", "cyclicmagic.content", true, "Set false to delete - requires restart");
        TileMachineStructureBuilder.maxSize = config.getInt("builder.maxRange", "modpacks", 64, 3, 64, "Maximum range of the builder block that you can increase it to in the GUI");
        TileMachineStructureBuilder.maxHeight = config.getInt("builder.maxHeight", "modpacks", 64, 3, 64, "Maximum height of the builder block that you can increase it to in the GUI");
        this.enableHarvester = config.getBoolean("HarvesterBlock", "cyclicmagic.content", true, "Set false to delete - requires restart");
        this.enableUncrafter = config.getBoolean("UncraftingGrinder", "cyclicmagic.content", true, "Set false to delete - requires restart");
        this.enableMinerSmart = config.getBoolean("ControlledMiner", "cyclicmagic.content", true, "Set false to delete - requires restart");
        TileMachineMinerSmart.maxHeight = config.getInt("ControlledMiner.maxHeight", "modpacks", 32, 3, 128, "Maximum height of the controlled miner block that you can increase it to in the GUI");
    }
}

