/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.module;

import com.lothrazar.cyclicmagic.IHasConfig;
import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.module.BaseEventModule;
import com.lothrazar.cyclicmagic.registry.LootTableRegistry;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class LootTableModule
extends BaseEventModule
implements IHasConfig {
    private static final String LOOTPOOLNAME = "main";
    private Set<ResourceLocation> chests = new HashSet<ResourceLocation>();
    private boolean enablePolarbears;
    private boolean enableBats;
    private boolean enableElderGuardianDiam;
    private boolean enableEndermiteEyeCrystal;
    private boolean enableShulkerDiamCryst;
    private boolean enableSilverfishIron;
    private boolean enableStrayPackedIce;
    private boolean enableChestLoot;

    public LootTableModule() {
        this.chests.add(LootTableList.field_186424_f);
        this.chests.add(LootTableList.field_186429_k);
        this.chests.add(LootTableList.field_186430_l);
        this.chests.add(LootTableList.field_186425_g);
        this.chests.add(LootTableList.field_186422_d);
        this.chests.add(LootTableList.field_186428_j);
        this.chests.add(LootTableList.field_186427_i);
        this.chests.add(LootTableList.field_186426_h);
        this.chests.add(LootTableList.field_186423_e);
    }

    @SubscribeEvent
    public void onLootTableLoad(LootTableLoadEvent event) {
        LootPool main = event.getTable().getPool(LOOTPOOLNAME);
        if (main == null) {
            event.getTable().addPool(new LootPool(new LootEntry[0], new LootCondition[0], new RandomValueRange(1.0f, 2.0f), new RandomValueRange(1.0f, 1.0f), LOOTPOOLNAME));
            main = event.getTable().getPool(LOOTPOOLNAME);
            if (main == null) {
                ModCyclic.logger.error("could not insert Loot Pool for table :" + event.getName().toString());
                return;
            }
        }
        if (this.enableChestLoot) {
            this.onLootChestTableLoad(main, event);
        }
        this.onLootEntityTableLoad(main, event);
    }

    private void onLootChestTableLoad(LootPool main, LootTableLoadEvent event) {
        if (event.getName() == LootTableList.field_186420_b) {
            this.fillBonusChest(main);
        } else if (event.getName() == LootTableList.field_186431_m) {
            this.fillIglooChest(main);
        } else if (event.getName() == LootTableList.field_186421_c) {
            this.fillEndCityChest(main);
        } else if (this.chests.contains(event.getName())) {
            this.fillGenericChest(main);
        }
    }

    private void onLootEntityTableLoad(LootPool main, LootTableLoadEvent event) {
        if (this.enableBats && event.getName() == LootTableList.field_186377_ab) {
            this.addLoot(main, Items.field_151116_aA, ConfigLootTable.BatLeather);
        } else if (this.enablePolarbears && event.getName() == LootTableList.field_189969_E) {
            this.addLoot(main, Items.field_151116_aA, ConfigLootTable.PolarbearLeather);
            this.addLoot(main, Item.func_150898_a((Block)Blocks.field_150325_L), ConfigLootTable.PolarbearWool);
        } else if (this.enableStrayPackedIce && event.getName() == LootTableList.field_189968_an) {
            this.addLoot(main, Item.func_150898_a((Block)Blocks.field_150403_cj), ConfigLootTable.StrayPackedIce);
        } else if (this.enableEndermiteEyeCrystal && event.getName() == LootTableList.field_186382_ag) {
            this.addLoot(main, Items.field_151061_bv, ConfigLootTable.EndermiteEnderEye);
            this.addLoot(main, Items.field_185158_cP, ConfigLootTable.EndermiteCrystal);
        } else if (this.enableSilverfishIron && event.getName() == LootTableList.field_186438_t) {
            this.addLoot(main, Items.field_151042_j, ConfigLootTable.SilverfishIron);
        } else if (this.enableShulkerDiamCryst && event.getName() == LootTableList.field_186442_x) {
            this.addLoot(main, Items.field_151045_i, ConfigLootTable.ShulkerDiam);
            this.addLoot(main, Items.field_185158_cP, ConfigLootTable.ShulkerCrystal);
        } else if (this.enableElderGuardianDiam && event.getName() == LootTableList.field_186441_w) {
            this.addLoot(main, Items.field_151045_i, ConfigLootTable.ElderGuardianDiam);
            this.addLoot(main, Item.func_150898_a((Block)Blocks.field_150484_ah), ConfigLootTable.ElderGuardianDiamBlock);
        }
    }

    private void fillEndCityChest(LootPool main) {
        this.fillPoolFromMap(main, LootTableRegistry.endCityChest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillPoolFromMap(LootPool main, Map<Item, Integer> map) {
        Map<Item, Integer> map2 = map;
        synchronized (map2) {
            for (Map.Entry<Item, Integer> entry : map.entrySet()) {
                this.addLoot(main, entry.getKey(), entry.getValue());
            }
        }
    }

    private void fillGenericChest(LootPool main) {
        this.fillPoolFromMap(main, LootTableRegistry.genericChest);
    }

    private void fillIglooChest(LootPool main) {
        this.fillPoolFromMap(main, LootTableRegistry.iglooChest);
    }

    private void fillBonusChest(LootPool main) {
        this.fillPoolFromMap(main, LootTableRegistry.bonusChest);
    }

    private void addLoot(LootPool main, Item item) {
        this.addLoot(main, item, LootTableRegistry.lootChanceDefault);
    }

    private void addLoot(LootPool main, Item item, int rando) {
        if (item != null) {
            main.addEntry((LootEntry)new LootEntryItem(item, rando, 0, new LootFunction[0], new LootCondition[0], "cyclicmagic:" + item.func_77658_a()));
        }
    }

    @Override
    public void syncConfig(Configuration config) {
        this.enablePolarbears = config.getBoolean("PolarBearLoot", "cyclicmagic.mobs", true, "Polar Bears also drop wool and leather");
        this.enableBats = config.getBoolean("BatsLeather", "cyclicmagic.mobs", true, "Bats can drop leather");
        this.enableElderGuardianDiam = config.getBoolean("ElderGuardianDiamonds", "cyclicmagic.mobs", true, "Elder Guardians (the boss ones) can drop diamonds.");
        this.enableEndermiteEyeCrystal = config.getBoolean("EndermiteEyeCrystal", "cyclicmagic.mobs", true, "Endermites can drop ender eyes, and rarely ender crystals");
        this.enableShulkerDiamCryst = config.getBoolean("ShulkerLoot", "cyclicmagic.mobs", true, "Shulkers now drop loot: Diamonds and rare ender crystals");
        this.enableSilverfishIron = config.getBoolean("SilverfishIron", "cyclicmagic.mobs", true, "Silverfish can drop iron ingots");
        this.enableStrayPackedIce = config.getBoolean("StraySkeletonPackedIce", "cyclicmagic.mobs", true, "Strays (he new skeleton variants from cold biomes) can drop packed ice");
        this.enableChestLoot = config.getBoolean("ChestLoot", "cyclicmagic.world generation", true, "If true, then enabled items and blocks from this mod can appear in loot chests");
        LootTableRegistry.lootChanceDefault = config.getInt("ChestLootChance", "cyclicmagic.world generation", 4, 1, 99, "If ChestLoot is true, this is the default chance a cyclic item will show up as treasure.");
        String category = "cyclicmagic.mobs.mobloottable";
        String comment = "Customize mob loot table percentage.  Only works if the respective config is true";
        int minValue = 1;
        int maxValue = 99;
        ConfigLootTable.BatLeather = config.getInt("BatLeather", category, 90, minValue, maxValue, comment);
        ConfigLootTable.PolarbearWool = config.getInt("PolarbearWool", category, 75, minValue, maxValue, comment);
        ConfigLootTable.PolarbearLeather = config.getInt("PolarbearLeather", category, 95, minValue, maxValue, comment);
        ConfigLootTable.StrayPackedIce = config.getInt("StrayPackedIce", category, 35, minValue, maxValue, comment);
        ConfigLootTable.EndermiteCrystal = config.getInt("EndermiteCrystal", category, 10, minValue, maxValue, comment);
        ConfigLootTable.EndermiteEnderEye = config.getInt("EndermiteEnderEye", category, 25, minValue, maxValue, comment);
        ConfigLootTable.SilverfishIron = config.getInt("SilverfishIron", category, 25, minValue, maxValue, comment);
        ConfigLootTable.ShulkerCrystal = config.getInt("ShulkerCrystal", category, 5, minValue, maxValue, comment);
        ConfigLootTable.ShulkerDiam = config.getInt("ShulkerDiamond", category, 45, minValue, maxValue, comment);
        ConfigLootTable.ElderGuardianDiamBlock = config.getInt("ElderGuardianDiamBlock", category, 35, minValue, maxValue, comment);
        ConfigLootTable.ElderGuardianDiam = config.getInt("ElderGuardianDiam", category, 95, minValue, maxValue, comment);
    }

    public static class ConfigLootTable {
        public static int BatLeather;
        public static int PolarbearWool;
        public static int PolarbearLeather;
        public static int StrayPackedIce;
        public static int EndermiteCrystal;
        public static int EndermiteEnderEye;
        public static int SilverfishIron;
        public static int ShulkerCrystal;
        public static int ShulkerDiam;
        public static int ElderGuardianDiamBlock;
        public static int ElderGuardianDiam;
    }
}

