/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.module;

import com.lothrazar.cyclicmagic.IHasConfig;
import com.lothrazar.cyclicmagic.module.BaseEventModule;
import com.lothrazar.cyclicmagic.util.UtilItemStack;
import com.lothrazar.cyclicmagic.util.UtilNBT;
import java.util.List;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class MobDropChangesModule
extends BaseEventModule
implements IHasConfig {
    private static final int chanceZombieVillagerEmerald = 25;
    public static boolean sheepShearBuffed;
    private boolean zombieVillagerEmeralds;
    private boolean extraLeather;
    private boolean bonusPork;
    private boolean bonusGolemIron;
    private boolean zombieDropsNerfed;
    private boolean endermanDrop;
    private boolean nameTagDeath;

    @SubscribeEvent
    public void onEntityInteractSpecific(PlayerInteractEvent.EntityInteractSpecific event) {
        if (sheepShearBuffed && event.getEntityPlayer() != null && event.getTarget() instanceof EntitySheep) {
            EntityPlayer p = event.getEntityPlayer();
            EntitySheep s = (EntitySheep)event.getTarget();
            if (event.getHand() != null && p.func_184586_b(event.getHand()) != null && p.func_184586_b(event.getHand()).func_77973_b() == Items.field_151097_aZ && !s.func_70892_o()) {
                int meta = s.func_175509_cj().func_176765_a();
                int rand = MathHelper.func_76136_a((Random)event.getWorld().field_73012_v, (int)1, (int)6);
                UtilItemStack.dropItemStackInWorld(event.getWorld(), event.getPos(), new ItemStack(Blocks.field_150325_L, rand, meta));
            }
        }
    }

    @SubscribeEvent
    public void onLivingDropsEvent(LivingDropsEvent event) {
        EntityZombie z;
        EntityEnderman mob;
        IBlockState bs;
        Entity entity = event.getEntity();
        World world = entity.func_130014_f_();
        List drops = event.getDrops();
        BlockPos pos = entity.func_180425_c();
        if (this.nameTagDeath && entity.func_95999_t() != null && entity.func_95999_t() != "" && !world.field_72995_K) {
            ItemStack nameTag = UtilNBT.buildEnchantedNametag(entity.func_95999_t());
            UtilItemStack.dropItemStackInWorld(world, entity.func_180425_c(), nameTag);
        }
        if (this.endermanDrop && entity instanceof EntityEnderman && (bs = (mob = (EntityEnderman)entity).func_175489_ck()) != null && bs.func_177230_c() != null && !world.field_72995_K) {
            UtilItemStack.dropItemStackInWorld(world, mob.func_180425_c(), bs.func_177230_c());
        }
        if (entity instanceof EntityZombie && this.zombieVillagerEmeralds && (z = (EntityZombie)entity).func_82231_m() && world.field_73012_v.nextInt(100) <= 25) {
            drops.add(new EntityItem(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), new ItemStack(Items.field_151166_bC)));
        }
        if (this.extraLeather && entity instanceof EntityCow) {
            int rand = MathHelper.func_76136_a((Random)world.field_73012_v, (int)1, (int)8);
            UtilItemStack.dropItemStackInWorld(world, pos, new ItemStack(Items.field_151116_aA, rand));
        }
        if (this.bonusPork && entity instanceof EntityPig) {
            int rand = MathHelper.func_76136_a((Random)world.field_73012_v, (int)1, (int)8);
            UtilItemStack.dropItemStackInWorld(world, pos, new ItemStack(Items.field_151147_al, rand));
        }
        if (this.bonusGolemIron && entity instanceof EntityIronGolem) {
            int rand = MathHelper.func_76136_a((Random)world.field_73012_v, (int)1, (int)18);
            UtilItemStack.dropItemStackInWorld(world, pos, new ItemStack(Items.field_151042_j, rand));
            if (world.field_73012_v.nextDouble() < 0.1) {
                UtilItemStack.dropItemStackInWorld(world, pos, new ItemStack(Blocks.field_150339_S, 1));
            }
        }
        if (this.zombieDropsNerfed && entity instanceof EntityZombie) {
            for (int i = 0; i < drops.size(); ++i) {
                Item item = ((EntityItem)drops.get(i)).func_92059_d().func_77973_b();
                if (item != Items.field_151172_bF && item != Items.field_151174_bG && item != Items.field_151042_j) continue;
                drops.remove(i);
            }
        }
    }

    @Override
    public void syncConfig(Configuration config) {
        String category = "cyclicmagic.mobs";
        config.addCustomCategoryComment(category, "Changes to vanilla mobs");
        this.nameTagDeath = config.getBoolean("Name Tag Death", category, true, "When an entity dies that is named with a tag, it drops the nametag");
        this.endermanDrop = config.getBoolean("Enderman Block", category, true, "Enderman will always drop block they are carrying 100%");
        this.zombieDropsNerfed = config.getBoolean("Zombie Drops Nerfed", category, true, "Zombies no longer drops carrots, potatoes, or iron ingots");
        sheepShearBuffed = config.getBoolean("Sheep Shear Bonus", category, true, "Shearing sheep randomly adds bonus wool");
        this.zombieVillagerEmeralds = config.getBoolean("Zombie Villager Emerald", category, true, "Zombie villagers have a 25% chance to drop an emerald");
        this.extraLeather = config.getBoolean("Leather Bonus", category, true, "Leather drops from cows randomly increased");
        this.bonusPork = config.getBoolean("Pork Bonus", category, true, "Pig drops randomly increased");
        this.bonusGolemIron = config.getBoolean("Iron Bonus", category, true, "Iron Golem drops randomly increased by a few ingots, and a low chance to drop an iron block");
    }
}

