/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.net;

import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.item.tool.ItemToolSwap;
import com.lothrazar.cyclicmagic.util.UtilItemStack;
import com.lothrazar.cyclicmagic.util.UtilPlaceBlocks;
import com.lothrazar.cyclicmagic.util.UtilPlayer;
import com.lothrazar.cyclicmagic.util.UtilWorld;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketSwapBlock
implements IMessage,
IMessageHandler<PacketSwapBlock, IMessage> {
    private BlockPos pos;
    private ItemToolSwap.ActionType actionType;
    private ItemToolSwap.WandType wandType;
    private EnumFacing side;

    public PacketSwapBlock() {
    }

    public PacketSwapBlock(BlockPos mouseover, EnumFacing s, ItemToolSwap.ActionType t, ItemToolSwap.WandType w) {
        this.pos = mouseover;
        this.actionType = t;
        this.wandType = w;
        this.side = s;
    }

    public void fromBytes(ByteBuf buf) {
        NBTTagCompound tags = ByteBufUtils.readTag((ByteBuf)buf);
        int x = tags.func_74762_e("x");
        int y = tags.func_74762_e("y");
        int z = tags.func_74762_e("z");
        this.pos = new BlockPos(x, y, z);
        int s = tags.func_74762_e("s");
        this.side = EnumFacing.values()[s];
        int t = tags.func_74762_e("t");
        this.actionType = ItemToolSwap.ActionType.values()[t];
        int w = tags.func_74762_e("w");
        this.wandType = ItemToolSwap.WandType.values()[w];
    }

    public void toBytes(ByteBuf buf) {
        NBTTagCompound tags = new NBTTagCompound();
        tags.func_74768_a("x", this.pos.func_177958_n());
        tags.func_74768_a("y", this.pos.func_177956_o());
        tags.func_74768_a("z", this.pos.func_177952_p());
        tags.func_74768_a("t", this.actionType.ordinal());
        tags.func_74768_a("w", this.wandType.ordinal());
        tags.func_74768_a("s", this.side.ordinal());
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tags);
    }

    public IMessage onMessage(final PacketSwapBlock message, final MessageContext ctx) {
        if (ctx.side.isServer() && message != null && message.pos != null) {
            MinecraftServer s = FMLCommonHandler.instance().getMinecraftServerInstance();
            if (s == null) {
                this.handle(message, ctx);
            } else {
                s.func_152344_a(new Runnable(){

                    @Override
                    public void run() {
                        PacketSwapBlock.this.handle(message, ctx);
                    }
                });
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handle(PacketSwapBlock message, MessageContext ctx) {
        EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
        World world = player.func_130014_f_();
        IBlockState matched = null;
        if (message.wandType == ItemToolSwap.WandType.MATCH) {
            matched = world.func_180495_p(message.pos);
        }
        List<BlockPos> places = PacketSwapBlock.getSelectedBlocks(world, message.pos, message.actionType, message.wandType, message.side, matched);
        HashMap<BlockPos, Integer> processed = new HashMap<BlockPos, Integer>();
        try {
            List<BlockPos> list = places;
            synchronized (list) {
                for (BlockPos curPos : places) {
                    ItemStack cur;
                    IBlockState newToPlace;
                    if (!processed.containsKey(curPos)) {
                        processed.put(curPos, 0);
                    }
                    if ((Integer)processed.get(curPos) > 0) continue;
                    processed.put(curPos, (Integer)processed.get(curPos) + 1);
                    int slot = UtilPlayer.getFirstSlotWithBlock((EntityPlayer)player);
                    if (slot < 0 || world.func_175625_s(curPos) != null) continue;
                    IBlockState replaced = world.func_180495_p(curPos);
                    Block replacedBlock = replaced.func_177230_c();
                    if (world.func_175623_d(curPos) || replaced == null) continue;
                    String itemName = UtilItemStack.getStringForBlock(replacedBlock);
                    boolean isInBlacklist = false;
                    for (String s : ItemToolSwap.swapBlacklist) {
                        if (s == null || !s.equals(itemName)) continue;
                        isInBlacklist = true;
                        break;
                    }
                    if (isInBlacklist || UtilItemStack.getBlockHardness(replaced, world, curPos) < 0.0f || UtilWorld.doBlockStatesMatch(replaced, newToPlace = UtilPlayer.getBlockstateFromSlot((EntityPlayer)player, slot)) || (cur = player.field_71071_by.func_70301_a(slot)) == null || cur.field_77994_a <= 0) continue;
                    world.func_175698_g(curPos);
                    boolean success = false;
                    if (cur.func_179546_a((EntityPlayer)player, world, curPos, EnumHand.MAIN_HAND, message.side, 0.5f, 0.5f, 0.5f) == EnumActionResult.SUCCESS) {
                        success = true;
                        if (cur.field_77994_a == 0) {
                            player.field_71071_by.func_70299_a(slot, null);
                        }
                    } else {
                        success = UtilPlaceBlocks.placeStateSafe(world, (EntityPlayer)player, curPos, newToPlace);
                        if (success) {
                            UtilPlayer.decrStackSize((EntityPlayer)player, slot);
                        }
                    }
                    if (!success) continue;
                    replacedBlock.func_176226_b(world, curPos, replaced, 0);
                    ItemStack held = player.func_184614_ca();
                    if (held != null && held.func_77973_b() instanceof ItemToolSwap) {
                        UtilItemStack.damageItem((EntityPlayer)player, held);
                        continue;
                    }
                    held = player.func_184592_cb();
                    if (held == null || !(held.func_77973_b() instanceof ItemToolSwap)) continue;
                    UtilItemStack.damageItem((EntityPlayer)player, held);
                }
            }
        }
        catch (ConcurrentModificationException e) {
            ModCyclic.logger.warn("ConcurrentModificationException");
            ModCyclic.logger.warn(e.getMessage());
            ModCyclic.logger.warn(e.getStackTrace().toString());
        }
    }

    public static List<BlockPos> getSelectedBlocks(World world, BlockPos pos, ItemToolSwap.ActionType actionType, ItemToolSwap.WandType wandType, EnumFacing side, IBlockState matched) {
        List<BlockPos> places = new ArrayList<BlockPos>();
        int xMin = pos.func_177958_n();
        int yMin = pos.func_177956_o();
        int zMin = pos.func_177952_p();
        int xMax = pos.func_177958_n();
        int yMax = pos.func_177956_o();
        int zMax = pos.func_177952_p();
        boolean isVertical = side == EnumFacing.UP || side == EnumFacing.DOWN;
        int offsetRadius = 0;
        switch (actionType) {
            case SINGLE: {
                places.add(pos);
                offsetRadius = 0;
                break;
            }
            case X3: {
                offsetRadius = 1;
                break;
            }
            case X5: {
                offsetRadius = 2;
                break;
            }
            case X7: {
                offsetRadius = 3;
                break;
            }
            case X9: {
                offsetRadius = 4;
                break;
            }
        }
        if (offsetRadius > 0) {
            if (isVertical) {
                xMin -= offsetRadius;
                xMax += offsetRadius;
                zMin -= offsetRadius;
                zMax += offsetRadius;
            } else if (side == EnumFacing.EAST || side == EnumFacing.WEST) {
                zMin -= offsetRadius;
                zMax += offsetRadius;
                yMin -= offsetRadius;
                yMax += offsetRadius;
            } else {
                xMin -= offsetRadius;
                xMax += offsetRadius;
                yMin -= offsetRadius;
                yMax += offsetRadius;
            }
            places = UtilWorld.getPositionsInRange(pos, xMin, xMax, yMin, yMax, zMin, zMax);
        }
        ArrayList<BlockPos> retPlaces = new ArrayList<BlockPos>();
        for (BlockPos p : places) {
            if (world.func_175623_d(p) || wandType == ItemToolSwap.WandType.MATCH && matched != null && !UtilWorld.doBlockStatesMatch(matched, world.func_180495_p(p))) continue;
            retPlaces.add(p);
        }
        return retPlaces;
    }
}

