/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.util;

import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.net.PacketPlayerFalldamage;
import com.lothrazar.cyclicmagic.registry.ReflectionRegistry;
import com.lothrazar.cyclicmagic.util.UtilSound;
import com.lothrazar.cyclicmagic.util.Vector3;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class UtilEntity {
    private static final double ENTITY_PULL_DIST = 0.4;
    private static final double ENTITY_PULL_SPEED_CUTOFF = 3.0;
    private static final float ITEMSPEEDFAR = 0.9f;
    private static final float ITEMSPEEDCLOSE = 0.2f;
    static final float lowEnough = 0.001f;
    private static final int TICKS_FALLDIST_SYNC = 22;

    public static void teleportWallSafe(EntityLivingBase player, World world, BlockPos coords) {
        player.func_70634_a((double)coords.func_177958_n(), (double)coords.func_177956_o(), (double)coords.func_177952_p());
        UtilEntity.moveEntityWallSafe(player, world);
    }

    public static void moveEntityWallSafe(EntityLivingBase entity, World world) {
        while (world.func_184143_b(entity.func_174813_aQ())) {
            entity.func_70634_a(entity.field_70165_t, entity.field_70163_u + 1.0, entity.field_70161_v);
        }
    }

    public static void setMaxHealth(EntityLivingBase living, double max) {
        living.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(max);
    }

    public static double getMaxHealth(EntityLivingBase living) {
        return living.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b();
    }

    public static int incrementMaxHealth(EntityLivingBase living, int by) {
        int newVal = (int)UtilEntity.getMaxHealth(living) + by;
        UtilEntity.setMaxHealth(living, newVal);
        return newVal;
    }

    public static EnumFacing getFacing(EntityLivingBase entity) {
        int yaw = (int)entity.field_70177_z;
        if (yaw < 0) {
            yaw += 360;
        }
        yaw += 22;
        int facing = (yaw %= 360) / 45;
        return EnumFacing.func_176731_b((int)(facing / 2));
    }

    public static double getSpeedTranslated(double speed) {
        return speed * 100.0;
    }

    public static double getJumpTranslated(double jump) {
        double jumpHeight = 0.0;
        double gravity = 0.98;
        while (jump > 0.0) {
            jumpHeight += jump;
            jump -= 0.08;
            jump *= gravity;
        }
        return jumpHeight;
    }

    public static void launchDirection(Entity entity, float rotationPitch, float power, EnumFacing facing) {
        double velX = 0.0;
        double velZ = 0.0;
        double velY = 0.0;
        switch (facing) {
            case EAST: {
                velX = Math.abs(power);
                velZ = 0.0;
                break;
            }
            case WEST: {
                velX = -1.0f * Math.abs(power);
                velZ = 0.0;
                break;
            }
            case NORTH: {
                velX = 0.0;
                velZ = -1.0f * Math.abs(power);
                break;
            }
            case SOUTH: {
                velX = 0.0;
                velZ = Math.abs(power);
                break;
            }
        }
        Entity ridingEntity = entity.func_184187_bx();
        if (ridingEntity != null) {
            ridingEntity.field_70181_x = 0.0;
            ridingEntity.field_70143_R = 0.0f;
            ridingEntity.func_70024_g(velX, velY, velZ);
        } else {
            entity.field_70181_x = 0.0;
            entity.field_70143_R = 0.0f;
            entity.func_70024_g(velX, velY, velZ);
        }
    }

    public static void launch(Entity entity, float rotationPitch, float power) {
        float rotationYaw = entity.field_70177_z;
        UtilEntity.launch(entity, rotationPitch, rotationYaw, power);
    }

    public static void setVelocity(Entity entity, float rotationPitch, float rotationYaw, float power) {
        entity.field_70159_w = 0.0;
        entity.field_70181_x = 0.0;
        entity.field_70179_y = 0.0;
        double velX = -MathHelper.func_76126_a((float)(rotationYaw / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(rotationPitch / 180.0f * (float)Math.PI)) * power;
        double velZ = MathHelper.func_76134_b((float)(rotationYaw / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(rotationPitch / 180.0f * (float)Math.PI)) * power;
        double velY = -MathHelper.func_76126_a((float)(rotationPitch / 180.0f * (float)Math.PI)) * power;
        if (velY < 0.0) {
            velY *= -1.0;
        }
        if (Math.abs(velX) < (double)0.001f) {
            velX = 0.0;
        }
        if (Math.abs(velY) < (double)0.001f) {
            velY = 0.0;
        }
        if (Math.abs(velZ) < (double)0.001f) {
            velZ = 0.0;
        }
        entity.func_70024_g(velX, velY, velZ);
    }

    public static void launch(Entity entity, float rotationPitch, float rotationYaw, float power) {
        Entity ridingEntity;
        float mountPower = (float)((double)power - 0.5);
        double velX = -MathHelper.func_76126_a((float)(rotationYaw / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(rotationPitch / 180.0f * (float)Math.PI)) * power;
        double velZ = MathHelper.func_76134_b((float)(rotationYaw / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(rotationPitch / 180.0f * (float)Math.PI)) * power;
        double velY = -MathHelper.func_76126_a((float)(rotationPitch / 180.0f * (float)Math.PI)) * power;
        if (velY < 0.0) {
            velY *= -1.0;
        }
        if ((ridingEntity = entity.func_184187_bx()) != null) {
            ridingEntity.field_70181_x = 0.0;
            ridingEntity.field_70143_R = 0.0f;
            ridingEntity.func_70024_g(velX * (double)mountPower, velY * (double)mountPower, velZ * (double)mountPower);
        } else {
            entity.field_70181_x = 0.0;
            entity.field_70143_R = 0.0f;
            entity.func_70024_g(velX, velY, velZ);
        }
    }

    public static AxisAlignedBB makeBoundingBox(BlockPos center, int ITEM_HRADIUS, int ITEM_VRADIUS) {
        double x = center.func_177958_n();
        double y = center.func_177956_o();
        double z = center.func_177952_p();
        return new AxisAlignedBB(x - (double)ITEM_HRADIUS, y - (double)ITEM_VRADIUS, z - (double)ITEM_HRADIUS, x + (double)ITEM_HRADIUS, y + (double)ITEM_VRADIUS, z + (double)ITEM_HRADIUS);
    }

    public static AxisAlignedBB makeBoundingBox(double x, double y, double z, int ITEM_HRADIUS, int ITEM_VRADIUS) {
        return new AxisAlignedBB(x - (double)ITEM_HRADIUS, y - (double)ITEM_VRADIUS, z - (double)ITEM_HRADIUS, x + (double)ITEM_HRADIUS, y + (double)ITEM_VRADIUS, z + (double)ITEM_HRADIUS);
    }

    public static int moveEntityItemsInRegion(World world, BlockPos pos, int ITEM_HRADIUS, int ITEM_VRADIUS) {
        return UtilEntity.moveEntityItemsInRegion(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), ITEM_HRADIUS, ITEM_VRADIUS, true);
    }

    public static int moveEntityItemsInRegion(World world, double x, double y, double z, int ITEM_HRADIUS, int ITEM_VRADIUS, boolean towardsPos) {
        AxisAlignedBB range = UtilEntity.makeBoundingBox(x, y, z, ITEM_HRADIUS, ITEM_VRADIUS);
        List<Entity> all = UtilEntity.getItemExp(world, range);
        return UtilEntity.pullEntityList(x, y, z, towardsPos, all);
    }

    public static List<Entity> getItemExp(World world, AxisAlignedBB range) {
        ArrayList<Entity> all = new ArrayList<Entity>();
        all.addAll(world.func_72872_a(EntityItem.class, range));
        all.addAll(world.func_72872_a(EntityXPOrb.class, range));
        return all;
    }

    public static void speedupEntityIfMoving(EntityLivingBase entity, float factor) {
        if (entity.field_70701_bs > 0.0f) {
            if (entity.func_184187_bx() != null && entity.func_184187_bx() instanceof EntityLivingBase) {
                UtilEntity.speedupEntity((EntityLivingBase)entity.func_184187_bx(), factor);
            } else {
                UtilEntity.speedupEntity(entity, factor);
            }
        }
    }

    public static void speedupEntity(EntityLivingBase entity, float factor) {
        entity.field_70159_w += (double)(MathHelper.func_76126_a((float)(-entity.field_70177_z * ((float)Math.PI / 180))) * factor);
        entity.field_70179_y += (double)(MathHelper.func_76134_b((float)(entity.field_70177_z * ((float)Math.PI / 180))) * factor);
    }

    public static int moveEntityLivingNonplayers(World world, double x, double y, double z, int ITEM_HRADIUS, int ITEM_VRADIUS, boolean towardsPos) {
        AxisAlignedBB range = UtilEntity.makeBoundingBox(x, y, z, ITEM_HRADIUS, ITEM_VRADIUS);
        List<EntityLivingBase> nonPlayer = UtilEntity.getLivingHostile(world, range);
        return UtilEntity.pullEntityList(x, y, z, towardsPos, nonPlayer);
    }

    public static List<EntityLivingBase> getLivingHostile(World world, AxisAlignedBB range) {
        List all = world.func_72872_a(EntityLivingBase.class, range);
        ArrayList<EntityLivingBase> nonPlayer = new ArrayList<EntityLivingBase>();
        for (EntityLivingBase ent : all) {
            if (ent instanceof EntityPlayer || !ent.isCreatureType(EnumCreatureType.MONSTER, false)) continue;
            nonPlayer.add(ent);
        }
        return nonPlayer;
    }

    public static int pullEntityList(double x, double y, double z, boolean towardsPos, List<? extends Entity> all) {
        return UtilEntity.pullEntityList(x, y, z, towardsPos, all, 0.2f, 0.9f);
    }

    public static int pullEntityList(double x, double y, double z, boolean towardsPos, List<? extends Entity> all, float speedClose, float speedFar) {
        int moved = 0;
        int direction = towardsPos ? 1 : -1;
        for (Entity entity : all) {
            double zDist;
            double xDist;
            double hdist;
            Entity entity2 = entity;
            if (entity2 == null || !((hdist = Math.sqrt((xDist = Math.abs(x - (double)entity2.func_180425_c().func_177958_n())) * xDist + (zDist = Math.abs(z - (double)entity2.func_180425_c().func_177952_p())) * zDist)) > 0.4)) continue;
            float speed = hdist > 3.0 ? speedFar : speedClose;
            Vector3.setEntityMotionFromVector(entity2, x, y, z, (float)direction * speed);
            ++moved;
        }
        return moved;
    }

    public static void addOrMergePotionEffect(EntityLivingBase player, PotionEffect newp) {
        if (player.func_70644_a(newp.func_188419_a())) {
            PotionEffect p = player.func_70660_b(newp.func_188419_a());
            int ampMax = Math.max(p.func_76458_c(), newp.func_76458_c());
            int dur = newp.func_76459_b() + p.func_76459_b();
            player.func_70690_d(new PotionEffect(newp.func_188419_a(), dur, ampMax));
        } else {
            player.func_70690_d(newp);
        }
    }

    public static void centerEntityHoriz(Entity entity, BlockPos pos) {
        float fixedX = (float)pos.func_177958_n() + 0.5f;
        float fixedZ = (float)pos.func_177952_p() + 0.5f;
        entity.func_70107_b((double)fixedX, entity.field_70163_u, (double)fixedZ);
    }

    public static void tryMakeEntityClimb(World worldIn, EntityLivingBase entity, double climbSpeed) {
        if (entity.func_70093_af()) {
            entity.field_70181_x = 0.0;
        } else if (entity.field_70701_bs > 0.0f && entity.field_70181_x < climbSpeed) {
            entity.field_70181_x = climbSpeed;
        }
        if (worldIn.field_72995_K && entity instanceof EntityPlayer && entity.field_70173_aa % 22 == 0) {
            UtilSound.playSound(entity, SoundEvents.field_187653_cW);
            ModCyclic.network.sendToServer((IMessage)new PacketPlayerFalldamage());
        }
    }

    public static List<EntityVillager> getVillagers(World world, BlockPos p, int r) {
        BlockPos start = p.func_177982_a(-r, -r, -r);
        BlockPos end = p.func_177982_a(r, r, r);
        return world.func_72872_a(EntityVillager.class, new AxisAlignedBB(start, end));
    }

    public static EntityLivingBase getClosestEntity(World world, EntityPlayer player, List<? extends EntityLivingBase> list) {
        EntityLivingBase closest = null;
        double minDist = 999999.0;
        for (EntityLivingBase entityLivingBase : list) {
            double zDistance;
            double xDistance = Math.abs(player.field_70165_t - entityLivingBase.field_70165_t);
            double dist = Math.sqrt(xDistance * xDistance + (zDistance = Math.abs(player.field_70161_v - entityLivingBase.field_70161_v)) * zDistance);
            if (!(dist < minDist)) continue;
            minDist = dist;
            closest = entityLivingBase;
        }
        return closest;
    }

    public static EntityVillager getVillager(World world, int x, int y, int z) {
        List all = world.func_72872_a(EntityVillager.class, new AxisAlignedBB(new BlockPos(x, y, z)));
        if (all.size() == 0) {
            return null;
        }
        return (EntityVillager)all.get(0);
    }

    public static int getVillagerCareer(EntityVillager merchant) {
        try {
            return ReflectionRegistry.fieldCareer.getInt(merchant);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public static String getCareerName(EntityVillager merchant) {
        return merchant.func_145748_c_().func_150254_d();
    }
}

