/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.util;

import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class UtilFluid {
    public static ItemStack dispenseStack(World world, BlockPos pos, ItemStack stack, EnumFacing facing) {
        if (FluidUtil.getFluidContained((ItemStack)stack) != null) {
            return UtilFluid.dumpContainer(world, pos, stack);
        }
        return UtilFluid.fillContainer(world, pos, stack, facing);
    }

    public static ItemStack fillContainer(World world, BlockPos pos, ItemStack stackIn, EnumFacing facing) {
        ItemStack result = stackIn.func_77946_l();
        result = FluidUtil.tryPickUpFluid((ItemStack)result, null, (World)world, (BlockPos)pos, (EnumFacing)facing);
        return result;
    }

    public static ItemStack dumpContainer(World world, BlockPos pos, ItemStack stackIn) {
        ItemStack dispensedStack = stackIn.func_77946_l();
        dispensedStack.field_77994_a = 1;
        IFluidHandler fluidHandler = FluidUtil.getFluidHandler((ItemStack)dispensedStack);
        if (fluidHandler == null) {
            return null;
        }
        FluidStack fluidStack = fluidHandler.drain(1000, false);
        if (fluidStack != null && fluidStack.amount == 1000 && FluidUtil.tryPlaceFluid(null, (World)world, (FluidStack)fluidStack, (BlockPos)pos)) {
            fluidHandler.drain(1000, true);
        }
        return dispensedStack;
    }

    public static IFluidHandler getFluidHandler(TileEntity tile, EnumFacing side) {
        return tile != null && tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side) ? (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side) : null;
    }
}

