/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.util;

import com.lothrazar.cyclicmagic.util.UtilItemStack;
import com.lothrazar.cyclicmagic.util.UtilPlayer;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class UtilInventoryTransfer {
    public static void dumpFromPlayerToIInventory(World world, IInventory inventory, EntityPlayer player) {
        int start;
        block0: for (int islotInvo = start = 0; islotInvo < inventory.func_70302_i_(); ++islotInvo) {
            ItemStack chestEmptySlot = inventory.func_70301_a(islotInvo);
            if (chestEmptySlot != null) continue;
            for (int islotPlayer = 9; islotPlayer < UtilInventoryTransfer.getInvoEnd(player); ++islotPlayer) {
                ItemStack playerItem = player.field_71071_by.func_70301_a(islotPlayer);
                if (playerItem == null) continue;
                inventory.func_70299_a(islotInvo, playerItem);
                player.field_71071_by.func_70299_a(islotPlayer, null);
                continue block0;
            }
        }
        UtilPlayer.updatePlayerContainerClient(player);
    }

    public static void dumpFromIInventoryToPlayer(World world, IInventory inventory, EntityPlayer player) {
        int start = 0;
        block0: for (int islotPlayer = 9; islotPlayer < UtilInventoryTransfer.getInvoEnd(player); ++islotPlayer) {
            ItemStack playerEmptySlot = player.field_71071_by.func_70301_a(islotPlayer);
            if (playerEmptySlot != null) continue;
            for (int islotInvo = start; islotInvo < inventory.func_70302_i_(); ++islotInvo) {
                ItemStack chestItem = inventory.func_70301_a(islotInvo);
                if (chestItem == null) continue;
                player.field_71071_by.func_70299_a(islotPlayer, chestItem);
                inventory.func_70299_a(islotInvo, null);
                start = islotInvo + 1;
                continue block0;
            }
        }
        UtilPlayer.updatePlayerContainerClient(player);
    }

    public static void sortFromPlayerToInventory(World world, IInventory chest, EntityPlayer player) {
        int START_CHEST = 0;
        int END_CHEST = chest.func_70302_i_();
        for (int islotChest = START_CHEST; islotChest < END_CHEST; ++islotChest) {
            ItemStack chestItem = chest.func_70301_a(islotChest);
            if (chestItem == null) continue;
            for (int islotInv = 9; islotInv < UtilInventoryTransfer.getInvoEnd(player); ++islotInv) {
                int chestMax;
                int room;
                ItemStack playerItem = player.field_71071_by.func_70301_a(islotInv);
                if (playerItem == null || !UtilItemStack.canMerge(playerItem, chestItem) || (room = (chestMax = chestItem.func_77973_b().getItemStackLimit(chestItem)) - chestItem.field_77994_a) <= 0) continue;
                int toDeposit = Math.min(playerItem.field_77994_a, room);
                chestItem.field_77994_a += toDeposit;
                chest.func_70299_a(islotChest, chestItem);
                playerItem.field_77994_a -= toDeposit;
                if (playerItem.field_77994_a <= 0) {
                    player.field_71071_by.func_70299_a(islotInv, null);
                    continue;
                }
                player.field_71071_by.func_70299_a(islotInv, playerItem);
            }
        }
        UtilPlayer.updatePlayerContainerClient(player);
    }

    public static void sortFromInventoryToPlayer(World world, IInventory chest, EntityPlayer player, boolean restockLeaveOne) {
        int START_CHEST = 0;
        int END_CHEST = chest.func_70302_i_();
        for (int islotChest = START_CHEST; islotChest < END_CHEST; ++islotChest) {
            ItemStack chestItem = chest.func_70301_a(islotChest);
            if (chestItem == null) continue;
            for (int islotInv = 9; islotInv < UtilInventoryTransfer.getInvoEnd(player); ++islotInv) {
                int invMax;
                int room;
                ItemStack playerItem = player.field_71071_by.func_70301_a(islotInv);
                if (playerItem == null || !UtilItemStack.canMerge(playerItem, chestItem) || (room = (invMax = playerItem.func_77973_b().getItemStackLimit(playerItem)) - playerItem.field_77994_a) <= 0) continue;
                int toDeposit = Math.min(chestItem.field_77994_a, room);
                if (restockLeaveOne && chestItem.field_77994_a - toDeposit == 0 && --toDeposit == 0) continue;
                playerItem.field_77994_a += toDeposit;
                player.field_71071_by.func_70299_a(islotInv, playerItem);
                chestItem.field_77994_a -= toDeposit;
                if (chestItem.field_77994_a <= 0) {
                    chest.func_70299_a(islotChest, null);
                    continue;
                }
                chest.func_70299_a(islotChest, chestItem);
            }
        }
        UtilPlayer.updatePlayerContainerClient(player);
    }

    private static int getInvoEnd(EntityPlayer p) {
        return p.field_71071_by.func_70302_i_() - 4 - 1;
    }

    public static ArrayList<ItemStack> dumpToIInventory(ArrayList<ItemStack> stacks, IInventory inventory, int startingSlot) {
        ArrayList<ItemStack> remaining = new ArrayList<ItemStack>();
        for (ItemStack current : stacks) {
            if (current == null) continue;
            for (int i = startingSlot; i < inventory.func_70302_i_(); ++i) {
                int space;
                int toDeposit;
                if (current == null) continue;
                ItemStack chestStack = inventory.func_70301_a(i);
                if (chestStack == null) {
                    inventory.func_70299_a(i, current);
                    current = null;
                    continue;
                }
                if (!UtilItemStack.canMerge(chestStack, current) || (toDeposit = Math.min(space = chestStack.func_77976_d() - chestStack.field_77994_a, current.field_77994_a)) <= 0) continue;
                current.field_77994_a -= toDeposit;
                chestStack.field_77994_a += toDeposit;
                if (current.field_77994_a != 0) continue;
                current = null;
            }
            if (current == null) continue;
            remaining.add(current);
        }
        return remaining;
    }

    public static BagDepositReturn dumpFromListToIInventory(World world, IInventory chest, ItemStack[] stacks, boolean onlyMatchingItems) {
        int itemsMoved = 0;
        block0: for (int islotStacks = 0; islotStacks < stacks.length; ++islotStacks) {
            ItemStack bagItem = stacks[islotStacks];
            if (bagItem == null || bagItem.field_77994_a == 0) continue;
            for (int islotChest = 0; islotChest < chest.func_70302_i_(); ++islotChest) {
                ItemStack chestItem = chest.func_70301_a(islotChest);
                if (chestItem == null && !onlyMatchingItems) {
                    if (!chest.func_94041_b(islotStacks, bagItem)) continue;
                    itemsMoved += bagItem.field_77994_a;
                    chest.func_70299_a(islotChest, bagItem);
                    stacks[islotStacks] = null;
                    bagItem = null;
                    continue block0;
                }
                if (chestItem == null) continue;
                if (bagItem == null || bagItem.field_77994_a == 0) continue block0;
                bagItem = stacks[islotStacks];
                if (UtilItemStack.canMerge(bagItem, chestItem)) {
                    int chestMax = chestItem.func_77973_b().getItemStackLimit(chestItem);
                    int room = chestMax - chestItem.field_77994_a;
                    if (room <= 0) continue;
                    int toDeposit = Math.min(bagItem.field_77994_a, room);
                    chestItem.field_77994_a += toDeposit;
                    chest.func_70299_a(islotChest, chestItem);
                    bagItem.field_77994_a -= toDeposit;
                    itemsMoved += toDeposit;
                    stacks[islotStacks] = bagItem.field_77994_a <= 0 ? null : bagItem;
                }
                if (bagItem == null || bagItem.field_77994_a == 0) continue block0;
            }
        }
        return new BagDepositReturn(itemsMoved, stacks);
    }

    public static class BagDepositReturn {
        public int moved;
        public ItemStack[] stacks;

        public BagDepositReturn(int m, ItemStack[] s) {
            this.moved = m;
            this.stacks = s;
        }
    }
}

