/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.world.gen;

import com.google.common.base.Predicate;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.IWorldGenerator;

public class WorldGenOcean
implements IWorldGenerator {
    private static int clayChance;
    private static int clayNumBlocks;
    private static int dirtChance;
    private static int dirtNumBlocks;
    private static int sandChance;
    private static int sandNumBlocks;
    private WorldGenerator genClay = new WorldGenMinable(Blocks.field_150435_aG.func_176223_P(), clayNumBlocks, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150351_n));
    private WorldGenerator genSand = new WorldGenMinable(Blocks.field_150346_d.func_176223_P(), dirtNumBlocks, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150351_n));
    private WorldGenerator genDirt = new WorldGenMinable(Blocks.field_150354_m.func_176223_P(), sandNumBlocks, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150351_n));
    private static int MIN_HEIGHT;
    private static int MAX_HEIGHT;

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (world.field_73011_w.getDimension() == 0 && MIN_HEIGHT < MAX_HEIGHT) {
            if (clayChance > 0 && clayNumBlocks > 0) {
                this.run(this.genClay, world, random, chunkX * 16, chunkZ * 16, clayChance, MIN_HEIGHT, MAX_HEIGHT);
            }
            if (sandChance > 0 && sandNumBlocks > 0) {
                this.run(this.genSand, world, random, chunkX * 16, chunkZ * 16, sandChance, MIN_HEIGHT, MAX_HEIGHT);
            }
            if (dirtChance > 0 && dirtNumBlocks > 0) {
                this.run(this.genDirt, world, random, chunkX * 16, chunkZ * 16, dirtChance, MIN_HEIGHT, MAX_HEIGHT);
            }
        }
    }

    private void run(WorldGenerator generator, World world, Random rand, int chunk_X, int chunk_Z, int chancesToSpawn, int minHeight, int maxHeight) {
        if (minHeight < 0 || maxHeight > 256 || minHeight > maxHeight) {
            throw new IllegalArgumentException("Illegal Height Arguments for WorldGenerator");
        }
        int heightDiff = maxHeight - minHeight;
        for (int i = 0; i < chancesToSpawn; ++i) {
            int z;
            int y;
            int x = chunk_X + rand.nextInt(16);
            BlockPos pos = new BlockPos(x, y = minHeight + rand.nextInt(heightDiff), z = chunk_Z + rand.nextInt(16));
            Biome biome = world.func_180494_b(pos);
            if (biome != Biomes.field_76771_b && biome != Biomes.field_150575_M && biome != Biomes.field_76776_l) continue;
            generator.func_180709_b(world, rand, pos);
        }
    }

    public static void syncConfig(Configuration config) {
        String category = "cyclicmagic.world generation.ocean";
        Property prop = config.get(category, "clayChance", 30, "Chances of a clay patch.", 0, 90);
        prop.setRequiresMcRestart(true);
        clayChance = prop.getInt();
        prop = config.get(category, "dirtChance", 30, "Chances of a dirt patch.", 0, 90);
        prop.setRequiresMcRestart(true);
        dirtChance = prop.getInt();
        prop = config.get(category, "sandChance", 45, "Chances of a sand patch.", 0, 90);
        prop.setRequiresMcRestart(true);
        sandChance = prop.getInt();
        prop = config.get(category, "claySize", 50, "Approximate size of clay patch.", 0, 64);
        prop.setRequiresMcRestart(true);
        clayNumBlocks = prop.getInt();
        prop = config.get(category, "dirtSize", 40, "Approximate size of dirt patch.", 0, 64);
        prop.setRequiresMcRestart(true);
        dirtNumBlocks = prop.getInt();
        prop = config.get(category, "sandSize", 25, "Approximate size of a sand patch.", 0, 64);
        prop.setRequiresMcRestart(true);
        sandNumBlocks = prop.getInt();
        prop = config.get(category, "MinHeight", 20, "Lowest point this ocean biome generator to run.", 1, 255);
        prop.setRequiresMcRestart(true);
        MIN_HEIGHT = prop.getInt();
        prop = config.get(category, "MaxHeight", 255, "Highest point this ocean biome generator to run.", 1, 255);
        prop.setRequiresMcRestart(true);
        MAX_HEIGHT = prop.getInt();
    }
}

