/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic;

import amerifrance.guideapi.api.GuideAPI;
import amerifrance.guideapi.api.GuideBook;
import amerifrance.guideapi.api.IGuideBook;
import amerifrance.guideapi.api.IPage;
import amerifrance.guideapi.api.impl.Book;
import amerifrance.guideapi.api.impl.abstraction.CategoryAbstract;
import amerifrance.guideapi.api.impl.abstraction.EntryAbstract;
import amerifrance.guideapi.api.util.PageHelper;
import amerifrance.guideapi.category.CategoryItemStack;
import amerifrance.guideapi.entry.EntryItemStack;
import amerifrance.guideapi.page.PageBrewingRecipe;
import amerifrance.guideapi.page.PageIRecipe;
import com.lothrazar.cyclicmagic.registry.GuideRegistry;
import com.lothrazar.cyclicmagic.registry.RecipeRegistry;
import com.lothrazar.cyclicmagic.util.UtilChat;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Optional;

@Optional.Interface(iface="amerifrance.guideapi.api.GuideAPI", modid="guideapi", striprefs=true)
@GuideBook
public class CyclicGuideBook
implements IGuideBook {
    private static final int MAX_PAGE_LENGTH = 314;
    private static Book book;
    private List<CategoryAbstract> categories = new ArrayList<CategoryAbstract>();
    private Map<ResourceLocation, EntryAbstract> entriesBlocks = new HashMap<ResourceLocation, EntryAbstract>();
    private Map<ResourceLocation, EntryAbstract> entriesItems = new HashMap<ResourceLocation, EntryAbstract>();
    private Map<ResourceLocation, EntryAbstract> entriesGear = new HashMap<ResourceLocation, EntryAbstract>();
    private Map<ResourceLocation, EntryAbstract> entriesPotion = new HashMap<ResourceLocation, EntryAbstract>();
    private Map<ResourceLocation, EntryAbstract> entriesWorld = new HashMap<ResourceLocation, EntryAbstract>();
    private Map<ResourceLocation, EntryAbstract> entriesEnchants = new HashMap<ResourceLocation, EntryAbstract>();
    private Map<ResourceLocation, EntryAbstract> entriesBlockMachine = new HashMap<ResourceLocation, EntryAbstract>();
    private Map<ResourceLocation, EntryAbstract> entriesBlockPlate = new HashMap<ResourceLocation, EntryAbstract>();
    private Map<ResourceLocation, EntryAbstract> entriesItemBaubles = new HashMap<ResourceLocation, EntryAbstract>();
    private Map<ResourceLocation, EntryAbstract> entriesItemThrow = new HashMap<ResourceLocation, EntryAbstract>();
    private Map<ResourceLocation, EntryAbstract> entriesTransport = new HashMap<ResourceLocation, EntryAbstract>();

    private void addEntry(GuideRegistry.GuideCategory cat, List<IPage> page, String pageTitle, ItemStack icon) {
        switch (cat) {
            case BLOCK: {
                this.entriesBlocks.put(new ResourceLocation("cyclicmagic", pageTitle), (EntryAbstract)new EntryItemStack(page, pageTitle, icon));
                break;
            }
            case ITEM: {
                this.entriesItems.put(new ResourceLocation("cyclicmagic", pageTitle), (EntryAbstract)new EntryItemStack(page, pageTitle, icon));
                break;
            }
            case GEAR: {
                this.entriesGear.put(new ResourceLocation("cyclicmagic", pageTitle), (EntryAbstract)new EntryItemStack(page, pageTitle, icon));
                break;
            }
            case POTION: {
                this.entriesPotion.put(new ResourceLocation("cyclicmagic", pageTitle), (EntryAbstract)new EntryItemStack(page, pageTitle, icon));
                break;
            }
            case WORLD: {
                this.entriesWorld.put(new ResourceLocation("cyclicmagic", pageTitle), (EntryAbstract)new EntryItemStack(page, pageTitle, icon));
                break;
            }
            case ENCHANT: {
                this.entriesEnchants.put(new ResourceLocation("cyclicmagic", pageTitle), (EntryAbstract)new EntryItemStack(page, pageTitle, icon));
                break;
            }
            case BLOCKMACHINE: {
                this.entriesBlockMachine.put(new ResourceLocation("cyclicmagic", pageTitle), (EntryAbstract)new EntryItemStack(page, pageTitle, icon));
                break;
            }
            case BLOCKPLATE: {
                this.entriesBlockPlate.put(new ResourceLocation("cyclicmagic", pageTitle), (EntryAbstract)new EntryItemStack(page, pageTitle, icon));
                break;
            }
            case ITEMBAUBLES: {
                this.entriesItemBaubles.put(new ResourceLocation("cyclicmagic", pageTitle), (EntryAbstract)new EntryItemStack(page, pageTitle, icon));
                break;
            }
            case ITEMTHROW: {
                this.entriesItemThrow.put(new ResourceLocation("cyclicmagic", pageTitle), (EntryAbstract)new EntryItemStack(page, pageTitle, icon));
                break;
            }
            case TRANSPORT: {
                this.entriesTransport.put(new ResourceLocation("cyclicmagic", pageTitle), (EntryAbstract)new EntryItemStack(page, pageTitle, icon));
                break;
            }
        }
    }

    private void buildPages() {
        List<GuideRegistry.GuideItem> items = GuideRegistry.getItems();
        for (GuideRegistry.GuideItem item : items) {
            ArrayList<IPage> pages = new ArrayList<IPage>();
            for (GuideRegistry.GuidePage p : item.pages) {
                if (p.text != null) {
                    for (IPage textPage : PageHelper.pagesForLongText((String)p.text, (int)314)) {
                        pages.add(textPage);
                    }
                }
                if (p.recipe != null) {
                    pages.add((IPage)new PageIRecipe(p.recipe));
                }
                if (p.brewRecipe == null) continue;
                pages.add((IPage)new PageBrewingRecipe(p.brewRecipe));
            }
            this.addEntry(item.cat, pages, item.title, item.icon);
        }
    }

    public Book buildBook() {
        this.buildPages();
        this.buildCategories();
        this.buildBookItem();
        return book;
    }

    private void buildCategories() {
        this.addCategory(this.entriesBlocks, GuideRegistry.GuideCategory.BLOCK);
        this.addCategory(this.entriesBlockMachine, GuideRegistry.GuideCategory.BLOCKMACHINE);
        this.addCategory(this.entriesItems, GuideRegistry.GuideCategory.ITEM);
        this.addCategory(this.entriesGear, GuideRegistry.GuideCategory.GEAR);
        this.addCategory(this.entriesPotion, GuideRegistry.GuideCategory.POTION);
        this.addCategory(this.entriesEnchants, GuideRegistry.GuideCategory.ENCHANT);
        this.addCategory(this.entriesWorld, GuideRegistry.GuideCategory.WORLD);
        this.addCategory(this.entriesBlockPlate, GuideRegistry.GuideCategory.BLOCKPLATE);
        this.addCategory(this.entriesItemBaubles, GuideRegistry.GuideCategory.ITEMBAUBLES);
        this.addCategory(this.entriesItemThrow, GuideRegistry.GuideCategory.ITEMTHROW);
        this.addCategory(this.entriesTransport, GuideRegistry.GuideCategory.TRANSPORT);
    }

    private void addCategory(Map<ResourceLocation, EntryAbstract> entriesBlockPlate, GuideRegistry.GuideCategory cat) {
        this.categories.add((CategoryAbstract)new CategoryItemStack(entriesBlockPlate, cat.text(), cat.icon()));
    }

    private void buildBookItem() {
        book = new Book();
        book.setTitle("guide.title");
        book.setDisplayName(UtilChat.lang("item.guide.name"));
        book.setWelcomeMessage(UtilChat.lang("guide.welcome"));
        book.setAuthor("Lothrazar");
        book.setColor(Color.MAGENTA);
        book.setCategoryList(this.categories);
        book.setRegistryName(new ResourceLocation("cyclicmagic", "guide"));
        book.setSpawnWithBook(true);
    }

    public void handleModel(ItemStack bookStack) {
        GuideAPI.setModel((Book)book);
    }

    public void handlePost(ItemStack bookStack) {
        RecipeRegistry.addShapelessRecipe(bookStack, Items.field_151122_aG, "stickWood", Items.field_151044_h, "cobblestone", Blocks.field_150471_bO);
    }
}

