/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block;

import com.google.common.base.Predicate;
import com.lothrazar.cyclicmagic.util.UtilChat;
import com.lothrazar.cyclicmagic.util.UtilEntity;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBasePressurePlate;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockConveyor
extends BlockBasePressurePlate {
    protected static final AxisAlignedBB AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.03125, 1.0);
    private static final PropertyDirection PROPERTYFACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    private static final float ANGLE = 1.0f;
    private static final float powerCorrection = 0.02f;
    private float power;
    private SoundEvent sound;
    public static boolean doCorrections = true;
    public static boolean keepEntityGrounded = true;

    public BlockConveyor(float p) {
        super(Material.field_151571_B, MapColor.field_151661_c);
        this.func_149672_a(SoundType.field_185859_l);
        this.power = p;
        this.sound = SoundEvents.field_187677_b;
        this.func_149711_c(2.0f).func_149752_b(2.0f);
    }

    protected void func_185507_b(World worldIn, BlockPos pos) {
        worldIn.func_184133_a((EntityPlayer)null, pos, this.sound, SoundCategory.BLOCKS, 0.3f, 0.5f);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    protected void func_185508_c(World worldIn, BlockPos pos) {
    }

    protected int func_180669_e(World worldIn, BlockPos pos) {
        return 0;
    }

    protected int func_176576_e(IBlockState state) {
        return 0;
    }

    protected IBlockState func_176575_a(IBlockState state, int strength) {
        return null;
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entity) {
        EnumFacing face = this.getFacingFromState(state);
        if (keepEntityGrounded) {
            entity.field_70122_E = true;
        }
        UtilEntity.launchDirection(entity, 1.0f, this.power, face);
        if (doCorrections) {
            double diff;
            if (face == EnumFacing.NORTH || face == EnumFacing.SOUTH) {
                double xDiff = (double)pos.func_177958_n() + 0.5 - entity.field_70165_t;
                if (Math.abs(xDiff) > 0.09) {
                    if (xDiff < 0.0) {
                        UtilEntity.launchDirection(entity, 1.0f, 0.02f, EnumFacing.WEST);
                    } else {
                        UtilEntity.launchDirection(entity, 1.0f, 0.02f, EnumFacing.EAST);
                    }
                }
            } else if ((face == EnumFacing.EAST || face == EnumFacing.WEST) && Math.abs(diff = (double)pos.func_177952_p() + 0.5 - entity.field_70161_v) > 0.09) {
                if (diff < 0.0) {
                    UtilEntity.launchDirection(entity, 1.0f, 0.02f, EnumFacing.NORTH);
                } else {
                    UtilEntity.launchDirection(entity, 1.0f, 0.02f, EnumFacing.SOUTH);
                }
            }
        }
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing facing = EnumFacing.func_176731_b((int)meta);
        return this.func_176223_P().func_177226_a((IProperty)PROPERTYFACING, (Comparable)facing);
    }

    public EnumFacing getFacingFromState(IBlockState state) {
        return (EnumFacing)state.func_177229_b((IProperty)PROPERTYFACING);
    }

    public int func_176201_c(IBlockState state) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)PROPERTYFACING);
        int facingbits = facing.func_176736_b();
        return facingbits;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return state;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{PROPERTYFACING});
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing blockFaceClickedOn, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        EnumFacing enumfacing = placer == null ? EnumFacing.NORTH : EnumFacing.func_176733_a((double)placer.field_70177_z);
        return this.func_176223_P().func_177226_a((IProperty)PROPERTYFACING, (Comparable)enumfacing);
    }

    public IBlockState onBlockPlaced(World worldIn, BlockPos pos, EnumFacing blockFaceClickedOn, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_180642_a(worldIn, pos, blockFaceClickedOn, hitX, hitY, hitZ, meta, placer);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        int speed = (int)(this.power * 100.0f);
        tooltip.add(UtilChat.lang("tile.plate_push.tooltip") + speed);
    }
}

