/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block;

import com.lothrazar.cyclicmagic.IHasRecipe;
import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.block.base.BlockBase;
import com.lothrazar.cyclicmagic.registry.RecipeRegistry;
import com.lothrazar.cyclicmagic.util.UtilChat;
import com.lothrazar.cyclicmagic.util.UtilWorld;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.ITickableSound;
import net.minecraft.client.audio.Sound;
import net.minecraft.client.audio.SoundEventAccessor;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockSoundSuppress
extends BlockBase
implements IHasRecipe {
    private static final int VOL_REDUCE_PER_BLOCK = 4;
    private static final int RADIUS = 6;

    public BlockSoundSuppress() {
        super(Material.field_151571_B);
        this.myTooltip = UtilChat.lang("tile.block_soundproofing.tooltip") + 6;
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onPlaySound(PlaySoundEvent event) {
        if (event.getResultSound() == null || event.getResultSound() instanceof ITickableSound || ModCyclic.proxy.getClientWorld() == null) {
            return;
        }
        ISound sound = event.getResultSound();
        ArrayList<BlockPos> blocks = UtilWorld.findBlocks(ModCyclic.proxy.getClientWorld(), new BlockPos((double)sound.func_147649_g(), (double)sound.func_147654_h(), (double)sound.func_147651_i()), this, 6);
        if (blocks == null || blocks.size() == 0) {
            return;
        }
        try {
            SoundVolumeControlled newSound = new SoundVolumeControlled(sound);
            float pct = 0.04f;
            newSound.setVolume(pct / (float)blocks.size());
            event.setResultSound((ISound)newSound);
        }
        catch (Exception e) {
            ModCyclic.logger.error("Error trying to detect volume of sound from 3rd party ");
            ModCyclic.logger.error(e.getMessage());
            e.printStackTrace();
        }
    }

    @Override
    public IRecipe addRecipe() {
        return RecipeRegistry.addShapedRecipe(new ItemStack((Block)this, 8), " s ", "sos", " s ", Character.valueOf('s'), "dyeOrange", Character.valueOf('o'), Blocks.field_189880_di);
    }

    private static class SoundVolumeControlled
    implements ISound {
        public float volume;
        public ISound sound;

        public SoundVolumeControlled(ISound s) {
            this.sound = s;
        }

        public void setVolume(float v) {
            this.volume = v;
        }

        public float func_147653_e() {
            return this.volume * this.sound.func_147653_e();
        }

        public ResourceLocation func_147650_b() {
            return this.sound.func_147650_b();
        }

        public SoundEventAccessor func_184366_a(SoundHandler handler) {
            return this.sound.func_184366_a(handler);
        }

        public Sound func_184364_b() {
            return this.sound.func_184364_b();
        }

        public SoundCategory func_184365_d() {
            return this.sound.func_184365_d();
        }

        public boolean func_147657_c() {
            return this.sound.func_147657_c();
        }

        public int func_147652_d() {
            return this.sound.func_147652_d();
        }

        public float func_147655_f() {
            return this.sound.func_147655_f();
        }

        public float func_147649_g() {
            return this.sound.func_147649_g();
        }

        public float func_147654_h() {
            return this.sound.func_147654_h();
        }

        public float func_147651_i() {
            return this.sound.func_147651_i();
        }

        public ISound.AttenuationType func_147656_j() {
            return this.sound.func_147656_j();
        }
    }
}

