/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.base;

import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.block.base.TileEntityBaseMachine;
import com.lothrazar.cyclicmagic.gui.ITileFuel;
import com.lothrazar.cyclicmagic.util.UtilItemStack;
import com.lothrazar.cyclicmagic.util.UtilNBT;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public abstract class TileEntityBaseMachineInvo
extends TileEntityBaseMachine
implements IInventory,
ISidedInventory,
ITileFuel {
    private static final int SPEED_DEFAULT = 1;
    private static final int SPEED_FUELED = 8;
    private static final int MAX_SPEED = 10;
    private static final int FUEL_FACTOR = 2;
    private static final String NBT_INV = "Inventory";
    private static final String NBT_SLOT = "Slot";
    public static final String NBT_TIMER = "Timer";
    public static final String NBT_REDST = "redstone";
    public static final String NBT_SIZE = "size";
    public static final String NBT_FUEL = "fuel";
    public static final String NBTPLAYERID = "uuid";
    public static final String NBT_SPEED = "speed";
    public static final String NBT_RENDER = "render";
    public static final String NBT_FUELMAX = "maxFuel";
    protected NonNullList<ItemStack> inv;
    private int currentMaxFuel;
    private int fuelSlot = -1;
    private int currentFuel;
    protected int speed = 1;
    protected int timer;
    private boolean usesFuel = false;
    IItemHandler handlerTop = new SidedInvWrapper((ISidedInventory)this, EnumFacing.UP);
    IItemHandler handlerBottom = new SidedInvWrapper((ISidedInventory)this, EnumFacing.DOWN);
    IItemHandler handlerSide = new SidedInvWrapper((ISidedInventory)this, EnumFacing.WEST);

    public TileEntityBaseMachineInvo(int invoSize) {
        this.inv = NonNullList.func_191197_a((int)invoSize, (Object)ItemStack.field_190927_a);
        this.fuelSlot = -1;
    }

    protected void setFuelSlot(int slot) {
        this.usesFuel = true;
        this.fuelSlot = slot;
    }

    public int getFuelMax() {
        return this.currentMaxFuel;
    }

    protected void setFuelMax(int f) {
        this.currentMaxFuel = f;
    }

    public int getFuelCurrent() {
        return this.currentFuel;
    }

    protected void setFuelCurrent(int f) {
        this.currentFuel = f;
    }

    public double getPercentFormatted() {
        if (this.currentMaxFuel == 0) {
            return 0.0;
        }
        double percent = (float)this.currentFuel / (float)this.currentMaxFuel;
        double pctOneDecimal = Math.floor(percent * 1000.0) / 10.0;
        return pctOneDecimal;
    }

    public void consumeFuel() {
        if (this.usesFuel && !this.field_145850_b.field_72995_K) {
            if (this.currentFuel > 0) {
                --this.currentFuel;
            } else {
                ItemStack itemstack = this.func_70301_a(this.fuelSlot);
                if (this.isItemFuel(itemstack)) {
                    this.currentMaxFuel = this.currentFuel = 2 * TileEntityFurnace.func_145952_a((ItemStack)itemstack);
                    if (itemstack.func_77973_b() instanceof ItemBucket && itemstack.func_190916_E() == 1) {
                        this.func_70299_a(this.fuelSlot, new ItemStack(Items.field_151133_ar));
                    } else {
                        itemstack.func_190918_g(1);
                    }
                }
            }
        }
    }

    public int[] getFieldArray(int length) {
        return IntStream.rangeClosed(0, length - 1).toArray();
    }

    private boolean isItemFuel(ItemStack itemstack) {
        return TileEntityFurnace.func_145954_b((ItemStack)itemstack);
    }

    public boolean updateFuelIsBurning() {
        if (this.usesFuel) {
            this.consumeFuel();
            return this.currentFuel > 0;
        }
        return true;
    }

    protected boolean updateTimerIsZero() {
        this.timer -= this.getSpeed();
        if (this.timer < 0) {
            this.timer = 0;
        }
        return this.timer == 0;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public String func_70005_c_() {
        if (this.func_145838_q() == null) {
            ModCyclic.logger.error(" null blockType:" + this.getClass().getName());
            return "";
        }
        return this.func_145838_q().func_149739_a() + ".name";
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return true;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return null;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public void func_174888_l() {
        for (int i = 0; i < this.inv.size(); ++i) {
            this.inv.set(i, (Object)ItemStack.field_190927_a);
        }
    }

    protected void shiftAllUp() {
        this.shiftAllUp(0);
    }

    protected void shiftAllUp(int endOffset) {
        for (int i = 0; i < this.func_70302_i_() - endOffset - 1; ++i) {
            this.shiftPairUp(i, i + 1);
        }
    }

    protected void shiftPairUp(int low, int high) {
        ItemStack main = this.func_70301_a(low);
        ItemStack second = this.func_70301_a(high);
        if (main.func_190926_b() && !second.func_190926_b()) {
            this.func_70299_a(high, ItemStack.field_190927_a);
            this.func_70299_a(low, second);
        }
    }

    public int func_70302_i_() {
        return this.inv.size();
    }

    public ItemStack func_70301_a(int index) {
        if (index < 0 || index >= this.func_70302_i_()) {
            return ItemStack.field_190927_a;
        }
        return (ItemStack)this.inv.get(index);
    }

    public ItemStack decrStackSize(int index) {
        return this.func_70298_a(index, 1);
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack stack = this.func_70301_a(index);
        if (!stack.func_190926_b()) {
            if (stack.func_77976_d() <= count) {
                this.func_70299_a(index, ItemStack.field_190927_a);
            } else if ((stack = stack.func_77979_a(count)).func_77976_d() == 0) {
                this.func_70299_a(index, ItemStack.field_190927_a);
            }
        }
        return stack;
    }

    public ItemStack func_70304_b(int index) {
        ItemStack stack = this.func_70301_a(index);
        this.func_70299_a(index, ItemStack.field_190927_a);
        return stack;
    }

    public void func_70299_a(int index, ItemStack stack) {
        if (stack == null) {
            stack = ItemStack.field_190927_a;
        }
        if (!stack.func_190926_b() && stack.func_77976_d() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        this.inv.set(index, (Object)stack);
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[0];
    }

    public boolean func_191420_l() {
        return false;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.readInvoFromNBT(compound);
        this.timer = compound.func_74762_e(NBT_TIMER);
        this.speed = compound.func_74762_e(NBT_SPEED);
        this.currentMaxFuel = compound.func_74762_e(NBT_FUELMAX);
        this.setFuelCurrent(compound.func_74762_e(NBT_FUEL));
        super.func_145839_a(compound);
    }

    private void readInvoFromNBT(NBTTagCompound tagCompound) {
        NBTTagList tagList = tagCompound.func_150295_c(NBT_INV, 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tag = tagList.func_150305_b(i);
            byte slot = tag.func_74771_c(NBT_SLOT);
            if (slot < 0 || slot >= this.inv.size()) continue;
            this.inv.set((int)slot, (Object)UtilNBT.itemFromNBT(tag));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        this.writeInvoToNBT(compound);
        compound.func_74768_a(NBT_SPEED, this.speed);
        compound.func_74768_a(NBT_FUEL, this.getFuelCurrent());
        compound.func_74768_a(NBT_FUELMAX, this.currentMaxFuel);
        compound.func_74768_a(NBT_TIMER, this.timer);
        return super.func_189515_b(compound);
    }

    private void writeInvoToNBT(NBTTagCompound compound) {
        NBTTagList itemList = new NBTTagList();
        for (int i = 0; i < this.inv.size(); ++i) {
            ItemStack stack = (ItemStack)this.inv.get(i);
            if (stack.func_190926_b()) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a(NBT_SLOT, (byte)i);
            stack.func_77955_b(tag);
            itemList.func_74742_a((NBTBase)tag);
        }
        compound.func_74782_a(NBT_INV, (NBTBase)itemList);
    }

    public boolean func_145842_c(int id, int value) {
        if (id >= 0 && id < this.func_174890_g()) {
            this.func_174885_b(id, value);
            return true;
        }
        return super.func_145842_c(id, value);
    }

    public ItemStack tryMergeStackIntoSlot(ItemStack held, int furnaceSlot) {
        ItemStack current = this.func_70301_a(furnaceSlot);
        boolean success = false;
        if (current.func_190926_b()) {
            this.func_70299_a(furnaceSlot, held);
            held = ItemStack.field_190927_a;
            success = true;
        } else if (held.func_77969_a(current)) {
            success = true;
            UtilItemStack.mergeItemsBetweenStacks(held, current);
        }
        if (success) {
            if (held != ItemStack.field_190927_a && held.func_77976_d() == 0) {
                held = ItemStack.field_190927_a;
            }
            this.func_70296_d();
        }
        return held;
    }

    public int[] getFieldOrdinals() {
        return new int[0];
    }

    @Override
    public int getSpeed() {
        if (!this.usesFuel) {
            return this.speed;
        }
        if (this.currentFuel == 0) {
            return 1;
        }
        return 8;
    }

    public void setSpeed(int value) {
        if (value < 0) {
            value = 0;
        }
        this.speed = Math.min(value, 10);
    }

    @Override
    public void incrementSpeed() {
        this.setSpeed(this.getSpeed() - 1);
    }

    @Override
    public void decrementSpeed() {
        this.setSpeed(this.getSpeed() + 1);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == EnumFacing.DOWN) {
                return (T)this.handlerBottom;
            }
            if (facing == EnumFacing.UP) {
                return (T)this.handlerTop;
            }
            return (T)this.handlerSide;
        }
        return (T)super.getCapability(capability, facing);
    }
}

