/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.component.autouser;

import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.block.base.TileEntityBaseMachineInvo;
import com.lothrazar.cyclicmagic.gui.ITilePreviewToggle;
import com.lothrazar.cyclicmagic.gui.ITileRedstoneToggle;
import com.lothrazar.cyclicmagic.gui.ITileSizeToggle;
import com.lothrazar.cyclicmagic.util.UtilEntity;
import com.lothrazar.cyclicmagic.util.UtilFakePlayer;
import com.lothrazar.cyclicmagic.util.UtilFluid;
import com.lothrazar.cyclicmagic.util.UtilInventoryTransfer;
import com.lothrazar.cyclicmagic.util.UtilItemStack;
import com.lothrazar.cyclicmagic.util.UtilShape;
import com.lothrazar.cyclicmagic.util.UtilWorld;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeMap;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fluids.FluidActionResult;

public class TileEntityUser
extends TileEntityBaseMachineInvo
implements ITileRedstoneToggle,
ITileSizeToggle,
ITilePreviewToggle,
ITickable {
    private static final String NBT_LR = "lr";
    private static final int MAX_SIZE = 4;
    public static final int TIMER_FULL = 120;
    public static int maxHeight = 10;
    private int[] hopperInput = new int[]{0, 1, 2};
    private int[] hopperOutput = new int[]{3, 4, 5, 6, 7, 8};
    private int[] hopperInputFuel = new int[]{9};
    private int rightClickIfZero = 0;
    private WeakReference<FakePlayer> fakePlayer;
    private UUID uuid;
    private int needsRedstone = 1;
    private int renderParticles = 0;
    private int toolSlot = 0;
    private int size;
    public int yOffset = 0;

    public TileEntityUser() {
        super(10);
        this.timer = 120;
        this.setFuelSlot(9);
    }

    @Override
    public int[] getFieldOrdinals() {
        return super.getFieldArray(Fields.values().length);
    }

    public void func_73660_a() {
        if (!this.isRunning()) {
            return;
        }
        this.shiftAllUp(7);
        this.spawnParticlesAbove();
        this.updateFuelIsBurning();
        boolean triggered = this.updateTimerIsZero();
        if (this.field_145850_b instanceof WorldServer) {
            this.verifyUuid(this.field_145850_b);
            if (this.fakePlayer == null) {
                this.fakePlayer = UtilFakePlayer.initFakePlayer((WorldServer)this.field_145850_b, this.uuid);
                if (this.fakePlayer == null) {
                    ModCyclic.logger.error("Fake player failed to init ");
                    return;
                }
            }
            this.tryEquipItem();
            if (triggered) {
                this.timer = 120;
                try {
                    BlockPos targetPos = this.getTargetPos();
                    if (this.rightClickIfZero == 0) {
                        this.rightClickBlock(targetPos);
                    }
                    this.interactEntities(targetPos);
                }
                catch (Exception e) {
                    ModCyclic.logger.error("Automated User Error");
                    ModCyclic.logger.error(e.getLocalizedMessage());
                    e.printStackTrace();
                }
            }
        }
    }

    private void interactEntities(BlockPos targetPos) {
        BlockPos entityCenter = this.func_174877_v().func_177967_a(this.getCurrentFacing(), 1);
        int vRange = 1;
        AxisAlignedBB entityRange = UtilEntity.makeBoundingBox(entityCenter, this.size + 1, vRange);
        List living = this.field_145850_b.func_72872_a(EntityLivingBase.class, entityRange);
        List carts = this.field_145850_b.func_72872_a(EntityMinecart.class, entityRange);
        ArrayList all = new ArrayList(living);
        all.addAll(carts);
        if (this.rightClickIfZero == 0) {
            this.func_145831_w().func_175646_b(targetPos, (TileEntity)this);
            for (Entity ent : all) {
                if (this.field_145850_b.field_72995_K || ent == null || ent.field_70128_L || this.fakePlayer == null || this.fakePlayer.get() == null) continue;
                this.validateTool();
                if (EnumActionResult.FAIL == ((FakePlayer)this.fakePlayer.get()).func_190775_a(ent, EnumHand.MAIN_HAND)) continue;
                this.tryDumpFakePlayerInvo();
                break;
            }
        } else {
            ItemStack held = ((FakePlayer)this.fakePlayer.get()).func_184614_ca();
            ((FakePlayer)this.fakePlayer.get()).field_70122_E = true;
            for (Entity e : living) {
                EntityLivingBase ent = (EntityLivingBase)e;
                if (e == null) continue;
                ((FakePlayer)this.fakePlayer.get()).func_71059_n((Entity)ent);
                IAttributeInstance damage = new AttributeMap().func_111150_b(SharedMonsterAttributes.field_111264_e);
                if (!held.func_190926_b()) {
                    for (AttributeModifier modifier : held.func_111283_C(EntityEquipmentSlot.MAINHAND).get((Object)SharedMonsterAttributes.field_111264_e.func_111108_a())) {
                        damage.func_111121_a(modifier);
                    }
                }
                float dmgVal = (float)damage.func_111126_e();
                float f1 = EnchantmentHelper.func_152377_a((ItemStack)held, (EnumCreatureAttribute)ent.func_70668_bt());
                ent.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)this.fakePlayer.get())), dmgVal + f1);
            }
        }
    }

    private void rightClickBlock(BlockPos targetPos) {
        ActionResult res;
        EnumActionResult r;
        if (this.rightClickFluidAttempt(targetPos)) {
            return;
        }
        if (Block.func_149634_a((Item)((FakePlayer)this.fakePlayer.get()).func_184614_ca().func_77973_b()) == Blocks.field_150350_a && (r = ((FakePlayer)this.fakePlayer.get()).field_71134_c.func_187251_a((EntityPlayer)this.fakePlayer.get(), this.field_145850_b, ((FakePlayer)this.fakePlayer.get()).func_184614_ca(), EnumHand.MAIN_HAND, targetPos, EnumFacing.UP, 0.5f, 0.5f, 0.5f)) != EnumActionResult.SUCCESS && (r = ((FakePlayer)this.fakePlayer.get()).field_71134_c.func_187250_a((EntityPlayer)this.fakePlayer.get(), this.field_145850_b, ((FakePlayer)this.fakePlayer.get()).func_184614_ca(), EnumHand.MAIN_HAND)) != EnumActionResult.SUCCESS && ((res = ((FakePlayer)this.fakePlayer.get()).func_184614_ca().func_77973_b().func_77659_a(this.field_145850_b, (EntityPlayer)this.fakePlayer.get(), EnumHand.MAIN_HAND)) == null || res.func_188397_a() != EnumActionResult.SUCCESS) && ((FakePlayer)this.fakePlayer.get()).func_184614_ca().func_77973_b() == Items.field_151069_bo && this.field_145850_b.func_180495_p(targetPos).func_185904_a() == Material.field_151586_h) {
            ItemStack itemstack = ((FakePlayer)this.fakePlayer.get()).func_184614_ca();
            EntityPlayer p = (EntityPlayer)this.fakePlayer.get();
            this.field_145850_b.func_184148_a(p, p.field_70165_t, p.field_70163_u, p.field_70161_v, SoundEvents.field_187615_H, SoundCategory.NEUTRAL, 1.0f, 1.0f);
            itemstack.func_190918_g(1);
            ItemStack is = new ItemStack((Item)Items.field_151068_bn);
            PotionUtils.func_185188_a((ItemStack)is, (PotionType)PotionTypes.field_185230_b);
            this.tryDumpStacks(Arrays.asList(is));
        }
    }

    private void tryDumpStacks(List<ItemStack> toDump) {
        ArrayList<ItemStack> toDrop = UtilInventoryTransfer.dumpToIInventory(toDump, this, 3, 9);
        BlockPos dropHere = this.getTargetPos();
        for (ItemStack s : toDrop) {
            if (s.func_190926_b()) continue;
            EntityItem entityItem = UtilItemStack.dropItemStackInWorld(this.field_145850_b, dropHere, s.func_77946_l());
            if (entityItem != null) {
                entityItem.func_70016_h(0.0, 0.0, 0.0);
            }
            s.func_190920_e(0);
        }
    }

    private void tryDumpFakePlayerInvo() {
        ArrayList<ItemStack> toDrop = new ArrayList<ItemStack>();
        for (ItemStack s : ((FakePlayer)this.fakePlayer.get()).field_71071_by.field_70462_a) {
            if (s.func_190926_b() || s.equals(((FakePlayer)this.fakePlayer.get()).func_184614_ca())) continue;
            toDrop.add(s);
        }
        this.tryDumpStacks(toDrop);
    }

    private boolean rightClickFluidAttempt(BlockPos targetPos) {
        ItemStack maybeTool = ((FakePlayer)this.fakePlayer.get()).func_184614_ca();
        if (maybeTool != null && !maybeTool.func_190926_b() && UtilFluid.stackHasFluidHandler(maybeTool)) {
            if (UtilFluid.hasFluidHandler(this.field_145850_b.func_175625_s(targetPos), this.getCurrentFacing().func_176734_d())) {
                ItemStack originalRef = maybeTool.func_77946_l();
                int hack = maybeTool.func_190916_E() == 1 ? 1 : 0;
                maybeTool.func_190917_f(hack);
                boolean success = UtilFluid.interactWithFluidHandler((EntityPlayer)this.fakePlayer.get(), this.field_145850_b, targetPos, this.getCurrentFacing().func_176734_d());
                if (success) {
                    if (UtilFluid.isEmptyOfFluid(originalRef)) {
                        maybeTool.func_190918_g(1 + hack);
                    } else {
                        ItemStack drained = UtilFluid.drainOneBucket(maybeTool.func_77979_a(1));
                        maybeTool.func_190918_g(1 + hack);
                    }
                    this.tryDumpFakePlayerInvo();
                }
            } else {
                if (UtilFluid.isEmptyOfFluid(maybeTool)) {
                    FluidActionResult res = UtilFluid.fillContainer(this.field_145850_b, targetPos, maybeTool, this.getCurrentFacing());
                    if (res != FluidActionResult.FAILURE) {
                        maybeTool.func_190918_g(1);
                        UtilItemStack.dropItemStackInWorld(this.field_145850_b, this.getCurrentFacingPos(), res.getResult());
                        return true;
                    }
                } else {
                    ItemStack drainedStackOrNull = UtilFluid.dumpContainer(this.field_145850_b, targetPos, maybeTool);
                    if (drainedStackOrNull != null) {
                        maybeTool.func_190918_g(1);
                        UtilItemStack.dropItemStackInWorld(this.field_145850_b, this.getCurrentFacingPos(), drainedStackOrNull);
                    }
                }
                return true;
            }
        }
        return false;
    }

    private void validateTool() {
        ItemStack maybeTool = this.func_70301_a(this.toolSlot);
        if (!maybeTool.func_190926_b() && maybeTool.func_190916_E() < 0) {
            maybeTool = ItemStack.field_190927_a;
            ((FakePlayer)this.fakePlayer.get()).func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
            this.inv.set(this.toolSlot, (Object)ItemStack.field_190927_a);
        }
    }

    private ItemStack tryEquipItem() {
        ItemStack maybeTool = this.func_70301_a(this.toolSlot);
        if (!maybeTool.func_190926_b() && maybeTool.func_190916_E() <= 0) {
            maybeTool = ItemStack.field_190927_a;
        }
        ((FakePlayer)this.fakePlayer.get()).func_70107_b((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p());
        ((FakePlayer)this.fakePlayer.get()).func_70071_h_();
        if (maybeTool.func_190926_b()) {
            ((FakePlayer)this.fakePlayer.get()).func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
            this.inv.set(this.toolSlot, (Object)ItemStack.field_190927_a);
        } else if (!maybeTool.equals(((FakePlayer)this.fakePlayer.get()).func_184586_b(EnumHand.MAIN_HAND))) {
            ((FakePlayer)this.fakePlayer.get()).func_184611_a(EnumHand.MAIN_HAND, maybeTool);
        }
        return maybeTool;
    }

    private void verifyUuid(World world) {
        if (this.uuid == null) {
            this.uuid = UUID.randomUUID();
            IBlockState state = world.func_180495_p(this.field_174879_c);
            world.func_184138_a(this.field_174879_c, state, state, 3);
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        if (this.uuid != null) {
            compound.func_74778_a("uuid", this.uuid.toString());
        }
        compound.func_74768_a("redstone", this.needsRedstone);
        compound.func_74768_a(NBT_LR, this.rightClickIfZero);
        compound.func_74768_a("size", this.size);
        compound.func_74768_a("render", this.renderParticles);
        compound.func_74768_a("yoff", this.yOffset);
        return super.func_189515_b(compound);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b("uuid")) {
            this.uuid = UUID.fromString(compound.func_74779_i("uuid"));
        }
        this.needsRedstone = compound.func_74762_e("redstone");
        this.rightClickIfZero = compound.func_74762_e(NBT_LR);
        this.size = compound.func_74762_e("size");
        this.renderParticles = compound.func_74762_e("render");
        this.yOffset = compound.func_74762_e("yoff");
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        if (side == EnumFacing.UP) {
            return this.hopperInput;
        }
        if (side == EnumFacing.DOWN) {
            return this.hopperOutput;
        }
        return this.hopperInputFuel;
    }

    @Override
    public int func_174887_a_(int id) {
        switch (Fields.values()[id]) {
            case SPEED: {
                return this.getSpeed();
            }
            case TIMER: {
                return this.getTimer();
            }
            case REDSTONE: {
                return this.needsRedstone;
            }
            case SIZE: {
                return this.size;
            }
            case LEFTRIGHT: {
                return this.rightClickIfZero;
            }
            case FUEL: {
                return this.getFuelCurrent();
            }
            case FUELMAX: {
                return this.getFuelMax();
            }
            case RENDERPARTICLES: {
                return this.renderParticles;
            }
            case Y_OFFSET: {
                return this.yOffset;
            }
        }
        return 0;
    }

    @Override
    public void func_174885_b(int id, int value) {
        switch (Fields.values()[id]) {
            case Y_OFFSET: {
                if (value > 1) {
                    value = -1;
                }
                this.yOffset = value;
                break;
            }
            case SPEED: {
                this.setSpeed(value);
                break;
            }
            case TIMER: {
                if (value < 0) {
                    value = 0;
                }
                this.timer = Math.min(value, 120);
                break;
            }
            case REDSTONE: {
                this.needsRedstone = value;
                break;
            }
            case LEFTRIGHT: {
                if (value > 1) {
                    value = 0;
                }
                this.rightClickIfZero = value;
                break;
            }
            case SIZE: {
                this.size = value;
                break;
            }
            case FUEL: {
                this.setFuelCurrent(value);
                break;
            }
            case FUELMAX: {
                this.setFuelMax(value);
                break;
            }
            case RENDERPARTICLES: {
                this.renderParticles = value % 2;
                break;
            }
        }
    }

    @Override
    public int func_174890_g() {
        return Fields.values().length;
    }

    @Override
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
        super.onDataPacket(net, pkt);
    }

    public int getTimer() {
        return this.timer;
    }

    @Override
    public void toggleNeedsRedstone() {
        int val = this.needsRedstone == 1 ? 0 : 1;
        this.func_174885_b(Fields.REDSTONE.ordinal(), val);
    }

    @Override
    public boolean onlyRunIfPowered() {
        return this.needsRedstone == 1;
    }

    @Override
    public void toggleSizeShape() {
        ++this.size;
        if (this.size > 4) {
            this.size = 0;
        }
    }

    private BlockPos getTargetPos() {
        BlockPos targetPos = UtilWorld.getRandomPos(this.func_145831_w().field_73012_v, this.getTargetCenter(), this.size);
        return targetPos;
    }

    public BlockPos getTargetCenter() {
        return this.func_174877_v().func_177967_a(this.getCurrentFacing(), this.size + 1).func_177967_a(EnumFacing.UP, this.yOffset);
    }

    @Override
    public void togglePreview() {
        this.renderParticles = (this.renderParticles + 1) % 2;
    }

    @Override
    public List<BlockPos> getShape() {
        return UtilShape.squareHorizontalHollow(this.getTargetCenter(), this.size);
    }

    @Override
    public boolean isPreviewVisible() {
        return this.func_174887_a_(Fields.RENDERPARTICLES.ordinal()) == 1;
    }

    public static enum Fields {
        TIMER,
        SPEED,
        REDSTONE,
        LEFTRIGHT,
        SIZE,
        RENDERPARTICLES,
        FUEL,
        FUELMAX,
        Y_OFFSET;

    }
}

