/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.component.bucketstorage;

import com.lothrazar.cyclicmagic.block.base.BlockBase;
import com.lothrazar.cyclicmagic.component.bucketstorage.TileEntityBucketStorage;
import com.lothrazar.cyclicmagic.registry.BlockRegistry;
import com.lothrazar.cyclicmagic.util.UtilChat;
import com.lothrazar.cyclicmagic.util.UtilNBT;
import com.lothrazar.cyclicmagic.util.UtilParticle;
import com.lothrazar.cyclicmagic.util.UtilSound;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockBucketStorage
extends BlockBase
implements ITileEntityProvider {
    private Item bucketItem;
    public static final String NBTBUCKETS = "buckets";

    public BlockBucketStorage(Item bucketIn) {
        super(Material.field_151573_f);
        this.func_149711_c(7.0f);
        this.func_149752_b(7.0f);
        this.func_149672_a(SoundType.field_185853_f);
        this.setHarvestLevel("pickaxe", 1);
        this.bucketItem = bucketIn;
    }

    public static int getBucketsStored(ItemStack item) {
        if (item.func_77973_b() == Item.func_150898_a((Block)BlockRegistry.block_storeempty)) {
            return 0;
        }
        if (item.func_77978_p() == null) {
            item.func_77982_d(new NBTTagCompound());
        }
        return item.func_77978_p().func_74762_e(NBTBUCKETS) + 1;
    }

    public static int getItemStackBucketNBT(ItemStack item) {
        if (item.func_77978_p() == null) {
            item.func_77982_d(new NBTTagCompound());
        }
        return item.func_77978_p().func_74762_e(NBTBUCKETS);
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (stack.func_77978_p() != null) {
            int b = BlockBucketStorage.getItemStackBucketNBT(stack);
            TileEntityBucketStorage container = (TileEntityBucketStorage)worldIn.func_175625_s(pos);
            container.setBuckets(b);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World world, BlockPos pos) {
        TileEntityBucketStorage container = (TileEntityBucketStorage)world.func_175625_s(pos);
        return container.getBuckets();
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityBucketStorage(meta);
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (willHarvest) {
            return true;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te, ItemStack tool) {
        super.func_180657_a(world, player, pos, state, te, tool);
        world.func_175698_g(pos);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        Item item = Item.func_150898_a((Block)this);
        TileEntity ent = world.func_175625_s(pos);
        ItemStack stack = new ItemStack(item);
        if (ent != null && ent instanceof TileEntityBucketStorage) {
            TileEntityBucketStorage t = (TileEntityBucketStorage)ent;
            UtilNBT.setItemStackNBTVal(stack, NBTBUCKETS, t.getBuckets());
            t.setBuckets(0);
        }
        ret.add(stack);
        return ret;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer entityPlayer, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (hand != EnumHand.MAIN_HAND) {
            return false;
        }
        ItemStack held = entityPlayer.func_184586_b(hand);
        if (!held.func_190926_b()) {
            return false;
        }
        Block blockClicked = state.func_177230_c();
        if (!(blockClicked instanceof BlockBucketStorage)) {
            return false;
        }
        BlockBucketStorage block = (BlockBucketStorage)blockClicked;
        TileEntityBucketStorage container = (TileEntityBucketStorage)world.func_175625_s(pos);
        if (block.bucketItem != null && block.bucketItem == this.bucketItem) {
            if (!world.field_72995_K) {
                if (container.getBuckets() > 0) {
                    this.removeBucket(entityPlayer, world, container, block.bucketItem);
                } else {
                    this.removeBucket(entityPlayer, world, container, block.bucketItem);
                    world.func_175656_a(pos, BlockRegistry.block_storeempty.func_176223_P());
                }
                world.func_175666_e(pos, blockClicked);
            }
            UtilSound.playSound(world, pos, SoundEvents.field_187715_dR, SoundCategory.BLOCKS);
            this.spawnMyParticle(world, block.bucketItem, pos);
        }
        return super.func_180639_a(world, pos, state, entityPlayer, hand, side, hitX, hitY, hitZ);
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer entityPlayer) {
        EnumHand hand = entityPlayer.func_184600_cs();
        if (hand == null) {
            hand = EnumHand.MAIN_HAND;
        }
        ItemStack held = entityPlayer.func_184586_b(hand);
        if (pos == null) {
            return;
        }
        IBlockState bstate = world.func_180495_p(pos);
        if (bstate == null) {
            return;
        }
        Block blockClicked = bstate.func_177230_c();
        if (blockClicked == null || blockClicked == Blocks.field_150350_a) {
            return;
        }
        if (!(blockClicked instanceof BlockBucketStorage)) {
            return;
        }
        BlockBucketStorage block = (BlockBucketStorage)blockClicked;
        TileEntityBucketStorage container = (TileEntityBucketStorage)world.func_175625_s(pos);
        if (entityPlayer.func_70093_af() && !world.field_72995_K) {
            int inside = block.bucketItem == null ? 0 : container.getBuckets() + 1;
            UtilChat.addChatMessage(entityPlayer, (ITextComponent)new TextComponentTranslation(inside + "", new Object[0]));
            return;
        }
        if (held.func_190926_b()) {
            return;
        }
        if (block.bucketItem == null) {
            IBlockState state = null;
            if (held.func_77973_b() == Items.field_151129_at) {
                state = BlockRegistry.block_storelava.func_176223_P();
            } else if (held.func_77973_b() == Items.field_151131_as) {
                state = BlockRegistry.block_storewater.func_176223_P();
            }
            if (held.func_77973_b() == Items.field_151117_aB) {
                state = BlockRegistry.block_storemilk.func_176223_P();
            }
            if (state != null) {
                if (!world.field_72995_K) {
                    world.func_175656_a(pos, state);
                    container.addBucket();
                    entityPlayer.field_71071_by.func_70298_a(entityPlayer.field_71071_by.field_70461_c, 1);
                    world.func_175666_e(pos, blockClicked);
                }
                UtilSound.playSound(world, pos, SoundEvents.field_187715_dR, SoundCategory.BLOCKS);
                this.spawnMyParticle(world, held.func_77973_b(), pos);
            }
            return;
        }
        if (held != null && held.func_77973_b() == block.bucketItem) {
            if (!world.field_72995_K) {
                container.addBucket();
                entityPlayer.field_71071_by.func_70298_a(entityPlayer.field_71071_by.field_70461_c, 1);
                world.func_175666_e(pos, blockClicked);
            }
            UtilSound.playSound(world, pos, SoundEvents.field_187715_dR, SoundCategory.BLOCKS);
            this.spawnMyParticle(world, block.bucketItem, pos);
            return;
        }
        super.func_180649_a(world, pos, entityPlayer);
    }

    private void spawnMyParticle(World world, Item item, BlockPos pos) {
        if (item == Items.field_151117_aB) {
            UtilParticle.spawnParticle(world, EnumParticleTypes.SNOW_SHOVEL, pos);
        } else if (item == Items.field_151129_at) {
            UtilParticle.spawnParticle(world, EnumParticleTypes.LAVA, pos);
        } else if (item == Items.field_151131_as) {
            UtilParticle.spawnParticle(world, EnumParticleTypes.WATER_SPLASH, pos);
        }
    }

    private void removeBucket(EntityPlayer entityPlayer, World world, TileEntityBucketStorage storage, Item bucketItem) {
        storage.removeBucket();
        entityPlayer.func_184611_a(EnumHand.MAIN_HAND, new ItemStack(bucketItem));
    }
}

