/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.component.builder;

import com.lothrazar.cyclicmagic.component.builder.ButtonBuildSize;
import com.lothrazar.cyclicmagic.component.builder.ButtonBuilderType;
import com.lothrazar.cyclicmagic.component.builder.ContainerBuilder;
import com.lothrazar.cyclicmagic.component.builder.TileEntityStructureBuilder;
import com.lothrazar.cyclicmagic.data.Const;
import com.lothrazar.cyclicmagic.gui.ProgressBar;
import com.lothrazar.cyclicmagic.gui.base.GuiBaseContainer;
import com.lothrazar.cyclicmagic.util.UtilChat;
import net.minecraft.client.gui.Gui;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class GuiBuilder
extends GuiBaseContainer {
    private TileEntityStructureBuilder tile;
    private ButtonBuilderType btn;
    private ButtonBuildSize btnSizeUp;
    private ButtonBuildSize btnSizeDown;
    private ButtonBuildSize btnHeightUp;
    private ButtonBuildSize btnHeightDown;
    private int xSizeTextbox;
    private int ySizeTxtbox;
    private int xHeightTextbox;
    private int yHeightTxtbox;
    private int yOffset = 18;

    public GuiBuilder(InventoryPlayer inventoryPlayer, TileEntityStructureBuilder tileEntity) {
        super(new ContainerBuilder(inventoryPlayer, tileEntity), tileEntity);
        this.tile = tileEntity;
        this.setScreenSize(Const.ScreenSize.LARGE);
        this.fieldRedstoneBtn = TileEntityStructureBuilder.Fields.REDSTONE.ordinal();
        this.progressBar = new ProgressBar(this, 10, 116, TileEntityStructureBuilder.Fields.TIMER.ordinal(), 100);
        this.fieldPreviewBtn = TileEntityStructureBuilder.Fields.RENDERPARTICLES.ordinal();
        this.setFieldFuel(TileEntityStructureBuilder.Fields.FUEL.ordinal());
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        int width = 50;
        int id = 2;
        int y = this.field_147009_r + this.yOffset + 8;
        this.btn = new ButtonBuilderType(this.tile.func_174877_v(), id++, this.field_147003_i + 8 + 20, y, width);
        this.field_146292_n.add(this.btn);
        width = 15;
        this.xSizeTextbox = 124;
        this.btnSizeUp = new ButtonBuildSize(this.tile.func_174877_v(), id++, this.field_147003_i + this.xSizeTextbox, this.field_147009_r + this.yOffset, width, true, "size");
        this.field_146292_n.add(this.btnSizeUp);
        this.btnSizeDown = new ButtonBuildSize(this.tile.func_174877_v(), id++, this.field_147003_i + this.xSizeTextbox, this.field_147009_r + 21 + this.yOffset, width, false, "size");
        this.field_146292_n.add(this.btnSizeDown);
        this.xSizeTextbox += width / 2 - 2;
        this.ySizeTxtbox = 16;
        this.xHeightTextbox = this.xSizeTextbox - 28;
        this.btnHeightUp = new ButtonBuildSize(this.tile.func_174877_v(), id++, this.field_147003_i + this.xHeightTextbox, this.field_147009_r + this.yOffset, width, true, "height");
        this.field_146292_n.add(this.btnHeightUp);
        this.btnHeightDown = new ButtonBuildSize(this.tile.func_174877_v(), id++, this.field_147003_i + this.xHeightTextbox, this.field_147009_r + 21 + this.yOffset, width, false, "height");
        this.field_146292_n.add(this.btnHeightDown);
        this.xHeightTextbox += width / 2 - 2;
        this.yHeightTxtbox = this.ySizeTxtbox;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void func_146979_b(int mouseX, int mouseY) {
        int x;
        String display;
        super.func_146979_b(mouseX, mouseY);
        this.btn.field_146126_j = UtilChat.lang("buildertype." + this.tile.getBuildTypeEnum().name().toLowerCase() + ".name");
        if (this.tile.getSize() > 0) {
            display = "" + this.tile.getSize();
            x = display.length() > 1 ? this.xSizeTextbox - 3 : this.xSizeTextbox;
            this.field_146289_q.func_78276_b(display, x, this.ySizeTxtbox + this.yOffset - 4, 0x404040);
        }
        if (this.tile.getHeight() > 0 && this.tile.getBuildTypeEnum().hasHeight()) {
            display = "" + this.tile.getHeight();
            x = display.length() > 1 ? this.xHeightTextbox - 3 : this.xHeightTextbox;
            this.field_146289_q.func_78276_b(display, x, this.yHeightTxtbox + this.yOffset - 4, 0x404040);
        }
        super.func_146979_b(mouseX, mouseY);
        this.updateDisabledButtons();
    }

    private void updateDisabledButtons() {
        this.btnSizeDown.field_146124_l = this.tile.getSize() > 1;
        this.btnSizeUp.field_146124_l = this.tile.getSize() < TileEntityStructureBuilder.maxSize;
        this.btnHeightDown.field_146124_l = this.tile.getHeight() > 1;
        this.btnHeightUp.field_146124_l = this.tile.getHeight() < TileEntityStructureBuilder.maxHeight;
        this.btnHeightDown.field_146125_m = this.tile.getBuildTypeEnum().hasHeight();
        this.btnHeightUp.field_146125_m = this.tile.getBuildTypeEnum().hasHeight();
    }

    @Override
    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        super.func_146976_a(partialTicks, mouseX, mouseY);
        boolean u = false;
        boolean v = false;
        this.field_146297_k.func_110434_K().func_110577_a(Const.Res.SLOT);
        for (int k = 0; k < this.tile.func_70302_i_() - 1; ++k) {
            Gui.func_146110_a((int)(this.field_147003_i + 8 - 1 + k * 18), (int)(this.field_147009_r + 94 - 1), (float)((float)u), (float)((float)v), (int)18, (int)18, (float)18.0f, (float)18.0f);
        }
        this.field_146297_k.func_110434_K().func_110577_a(Const.Res.SLOT_COAL);
        Gui.func_146110_a((int)(this.field_147003_i + 152 - 1), (int)(this.field_147009_r + 8 - 1), (float)((float)u), (float)((float)v), (int)18, (int)18, (float)18.0f, (float)18.0f);
    }
}

