/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.component.builder;

import com.lothrazar.cyclicmagic.block.base.TileEntityBaseMachineInvo;
import com.lothrazar.cyclicmagic.gui.ITilePreviewToggle;
import com.lothrazar.cyclicmagic.gui.ITileRedstoneToggle;
import com.lothrazar.cyclicmagic.gui.ITileSizeToggle;
import com.lothrazar.cyclicmagic.util.UtilItemStack;
import com.lothrazar.cyclicmagic.util.UtilPlaceBlocks;
import com.lothrazar.cyclicmagic.util.UtilShape;
import com.lothrazar.cyclicmagic.util.UtilSound;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;

public class TileEntityStructureBuilder
extends TileEntityBaseMachineInvo
implements ITileRedstoneToggle,
ITileSizeToggle,
ITilePreviewToggle,
ITickable {
    private static final int spotsSkippablePerTrigger = 50;
    public static final int TIMER_FULL = 100;
    private static int[] hopperInput = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    private int[] hopperInputFuel = new int[]{9};
    private static final String NBT_BUILDTYPE = "build";
    private static final String NBT_SHAPEINDEX = "shapeindex";
    private int buildType;
    private int buildSize = 3;
    private int buildHeight = 3;
    private int needsRedstone = 1;
    private int shapeIndex = 0;
    private int renderParticles = 1;
    public static int maxSize;
    public static int maxHeight;

    public TileEntityStructureBuilder() {
        super(10);
        this.setFuelSlot(9);
    }

    @Override
    public int[] getFieldOrdinals() {
        return super.getFieldArray(Fields.values().length);
    }

    @Override
    public List<BlockPos> getShape() {
        BuildType buildType = this.getBuildTypeEnum();
        List<BlockPos> shape = new ArrayList<BlockPos>();
        switch (buildType) {
            case CIRCLE: {
                shape = UtilShape.circleHorizontal(this.func_174877_v(), this.getSize() * 2);
                break;
            }
            case FACING: {
                shape = UtilShape.line(this.func_174877_v(), this.getCurrentFacing(), this.getSize());
                break;
            }
            case SQUARE: {
                shape = UtilShape.squareHorizontalHollow(this.func_174877_v(), this.getSize());
                break;
            }
            case SOLID: {
                shape = UtilShape.squareHorizontalFull(this.getTargetCenter(), this.getSize());
                break;
            }
            case STAIRWAY: {
                shape = UtilShape.stairway(this.func_174877_v(), this.getCurrentFacing(), this.getSize() * 2, true);
                break;
            }
            case SPHERE: {
                shape = UtilShape.sphere(this.func_174877_v(), this.getSize());
            }
        }
        if (buildType.hasHeight() && this.buildHeight > 1) {
            shape = UtilShape.repeatShapeByHeight(shape, this.buildHeight - 1);
        }
        return shape;
    }

    public BlockPos getTargetCenter() {
        return this.func_174877_v().func_177967_a(this.getCurrentFacing(), this.getSize() + 1);
    }

    @Override
    public boolean func_94041_b(int index, ItemStack stack) {
        return Block.func_149634_a((Item)stack.func_77973_b()) != null;
    }

    @Override
    public int func_174887_a_(int id) {
        if (id >= 0 && id < this.func_174890_g()) {
            switch (Fields.values()[id]) {
                case TIMER: {
                    return this.timer;
                }
                case BUILDTYPE: {
                    return this.buildType;
                }
                case SPEED: {
                    return this.speed;
                }
                case SIZE: {
                    return this.buildSize;
                }
                case HEIGHT: {
                    return this.buildHeight;
                }
                case REDSTONE: {
                    return this.needsRedstone;
                }
                case RENDERPARTICLES: {
                    return this.renderParticles;
                }
                case FUEL: {
                    return this.getFuelCurrent();
                }
                case FUELMAX: {
                    return this.getFuelMax();
                }
            }
        }
        return -1;
    }

    @Override
    public void func_174885_b(int id, int value) {
        if (id >= 0 && id < this.func_174890_g()) {
            switch (Fields.values()[id]) {
                case TIMER: {
                    this.timer = value;
                    break;
                }
                case BUILDTYPE: {
                    this.buildType = value;
                    break;
                }
                case SPEED: {
                    this.speed = value;
                    break;
                }
                case SIZE: {
                    this.buildSize = value;
                    break;
                }
                case HEIGHT: {
                    if (value > maxHeight) {
                        value = maxHeight;
                    }
                    this.buildHeight = value;
                    break;
                }
                case REDSTONE: {
                    this.needsRedstone = value;
                    break;
                }
                case RENDERPARTICLES: {
                    this.renderParticles = value;
                    break;
                }
                case FUEL: {
                    this.setFuelCurrent(value);
                    break;
                }
                case FUELMAX: {
                    this.setFuelMax(value);
                }
            }
        }
    }

    @Override
    public boolean onlyRunIfPowered() {
        return this.needsRedstone == 1;
    }

    public int getTimer() {
        return this.func_174887_a_(Fields.TIMER.ordinal());
    }

    public int getHeight() {
        return this.func_174887_a_(Fields.HEIGHT.ordinal());
    }

    public void setHeight(int value) {
        this.func_174885_b(Fields.HEIGHT.ordinal(), value);
    }

    public int getBuildType() {
        return this.func_174887_a_(Fields.BUILDTYPE.ordinal());
    }

    public void setBuildType(int value) {
        this.func_174885_b(Fields.BUILDTYPE.ordinal(), value);
    }

    public BuildType getBuildTypeEnum() {
        int bt = Math.min(this.getBuildType(), BuildType.values().length - 1);
        return BuildType.values()[bt];
    }

    public void setSize(int s) {
        if (s <= 0) {
            s = 1;
        }
        if (s >= maxSize) {
            s = maxSize;
        }
        this.func_174885_b(Fields.SIZE.ordinal(), s);
    }

    public int getSize() {
        int s = this.func_174887_a_(Fields.SIZE.ordinal());
        if (s <= 0) {
            s = 1;
        }
        return s;
    }

    @Override
    public int func_174890_g() {
        return Fields.values().length;
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.needsRedstone = tagCompound.func_74762_e("redstone");
        this.timer = tagCompound.func_74762_e("Timer");
        this.shapeIndex = tagCompound.func_74762_e(NBT_SHAPEINDEX);
        this.buildType = tagCompound.func_74762_e(NBT_BUILDTYPE);
        this.buildSize = tagCompound.func_74762_e("size");
        this.renderParticles = tagCompound.func_74762_e("render");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        tagCompound.func_74768_a("Timer", this.timer);
        tagCompound.func_74768_a("redstone", this.needsRedstone);
        tagCompound.func_74768_a(NBT_SHAPEINDEX, this.shapeIndex);
        tagCompound.func_74768_a(NBT_BUILDTYPE, this.getBuildType());
        tagCompound.func_74768_a("size", this.getSize());
        tagCompound.func_74768_a("render", this.renderParticles);
        return super.func_189515_b(tagCompound);
    }

    public void func_73660_a() {
        if (!this.isRunning()) {
            return;
        }
        this.shiftAllUp(1);
        this.updateFuelIsBurning();
        if (this.updateTimerIsZero()) {
            this.timer = 100;
            this.spawnParticlesAbove();
            ItemStack stack = this.func_70301_a(0);
            if (stack.func_190926_b()) {
                return;
            }
            Block stuff = Block.func_149634_a((Item)stack.func_77973_b());
            if (stuff != null) {
                List<BlockPos> shape = this.getShape();
                if (shape.size() == 0) {
                    return;
                }
                if (this.shapeIndex < 0 || this.shapeIndex >= shape.size()) {
                    this.shapeIndex = 0;
                }
                BlockPos nextPos = shape.get(this.shapeIndex);
                for (int i = 0; i < 50; ++i) {
                    if (this.field_145850_b.func_175623_d(nextPos) && stuff.func_176196_c(this.field_145850_b, nextPos) && this.field_145850_b.func_190527_a(stuff, nextPos, true, EnumFacing.UP, null)) {
                        IBlockState placeState = UtilItemStack.getStateFromMeta(stuff, stack.func_77960_j());
                        if (this.field_145850_b.field_72995_K || !this.field_145850_b.func_175623_d(nextPos) || !UtilPlaceBlocks.placeStateSafe(this.field_145850_b, null, nextPos, placeState)) break;
                        this.func_70298_a(0, 1);
                        SoundType type = UtilSound.getSoundFromBlockstate(placeState, this.field_145850_b, nextPos);
                        if (type == null || type.func_185841_e() == null) break;
                        int dim = this.getDimension();
                        int range = 18;
                        UtilSound.playSoundFromServer(type.func_185841_e(), SoundCategory.BLOCKS, nextPos, dim, range);
                        break;
                    }
                    nextPos = shape.get(this.shapeIndex);
                    this.incrementPosition(shape);
                }
            }
        }
    }

    private void incrementPosition(List<BlockPos> shape) {
        if (shape == null || shape.size() == 0) {
            return;
        }
        int c = this.shapeIndex + 1;
        if (c < 0 || c >= shape.size()) {
            c = 0;
        }
        this.shapeIndex = c;
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        if (side == EnumFacing.UP || side == EnumFacing.DOWN) {
            return hopperInput;
        }
        return this.hopperInputFuel;
    }

    @Override
    public void toggleNeedsRedstone() {
        int val = (this.needsRedstone + 1) % 2;
        this.func_174885_b(Fields.REDSTONE.ordinal(), val);
    }

    @Override
    public void toggleSizeShape() {
        BuildType old = this.getBuildTypeEnum();
        BuildType next = BuildType.getNextType(old);
        this.setBuildType(next.ordinal());
    }

    @Override
    public void togglePreview() {
        int val = (this.renderParticles + 1) % 2;
        this.func_174885_b(Fields.RENDERPARTICLES.ordinal(), val);
    }

    @Override
    public boolean isPreviewVisible() {
        return this.func_174887_a_(Fields.RENDERPARTICLES.ordinal()) == 1;
    }

    static {
        maxHeight = 10;
    }

    public static enum BuildType {
        FACING,
        SQUARE,
        CIRCLE,
        SOLID,
        STAIRWAY,
        SPHERE;


        public static BuildType getNextType(BuildType btype) {
            int type = btype.ordinal();
            if (++type > SPHERE.ordinal()) {
                type = FACING.ordinal();
            }
            return BuildType.values()[type];
        }

        public boolean hasHeight() {
            return this != STAIRWAY && this != SPHERE;
        }
    }

    public static enum Fields {
        TIMER,
        BUILDTYPE,
        SPEED,
        SIZE,
        HEIGHT,
        REDSTONE,
        RENDERPARTICLES,
        FUEL,
        FUELMAX;

    }
}

