/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.component.crafter;

import com.lothrazar.cyclicmagic.block.base.TileEntityBaseMachineInvo;
import com.lothrazar.cyclicmagic.gui.ITileRedstoneToggle;
import com.lothrazar.cyclicmagic.util.UtilInventoryTransfer;
import com.lothrazar.cyclicmagic.util.UtilItemStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;

public class TileEntityCrafter
extends TileEntityBaseMachineInvo
implements ITileRedstoneToggle,
ITickable {
    public static final int TIMER_FULL = 80;
    public static final int ROWS = 5;
    public static final int COLS = 2;
    public static final int SIZE_INPUT = 10;
    public static final int SIZE_GRID = 9;
    public static final int SIZE_OUTPUT = 10;
    private Container fakeContainer;
    private IRecipe recipe;
    private int needsRedstone = 1;
    private InventoryCrafting crafter;
    private int[] hopperInput = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
    private int[] hopperInputfUEL = new int[]{29};
    private int[] hopperOutput = new int[]{19, 20, 21, 22, 23, 24, 25, 26, 27, 28};

    public TileEntityCrafter() {
        super(30);
        this.fakeContainer = new Container(){

            public boolean func_75145_c(@Nonnull EntityPlayer playerIn) {
                return false;
            }
        };
        this.crafter = new InventoryCrafting(this.fakeContainer, 3, 3);
        this.setFuelSlot(this.func_70302_i_() - 1);
    }

    @Override
    public int[] getFieldOrdinals() {
        return super.getFieldArray(Fields.values().length);
    }

    public void func_73660_a() {
        if (!this.isRunning()) {
            return;
        }
        this.spawnParticlesAbove();
        this.setRecipeInput();
        this.findRecipe();
        this.updateFuelIsBurning();
        if (this.updateTimerIsZero()) {
            this.findRecipe();
            if (this.recipe != null && this.tryPayCost()) {
                ItemStack craftingResult = this.recipe.func_77572_b(this.crafter);
                this.sendOutput(craftingResult);
                this.timer = 80;
            }
        }
    }

    private boolean tryPayCost() {
        boolean thisPaid = false;
        HashMap<Integer, Integer> slotsToPay = new HashMap<Integer, Integer>();
        for (int i = 0; i < this.crafter.func_70302_i_(); ++i) {
            thisPaid = false;
            ItemStack fromRecipe = this.crafter.func_70301_a(i);
            if (fromRecipe.func_190926_b()) continue;
            for (int j = 0; j < 10; ++j) {
                ItemStack fromInput = this.func_70301_a(j);
                if (!fromRecipe.func_77969_a(fromInput)) continue;
                if (!slotsToPay.containsKey(j)) {
                    slotsToPay.put(j, 0);
                }
                if ((Integer)slotsToPay.get(j) + 1 > fromInput.func_190916_E()) continue;
                slotsToPay.put(j, (Integer)slotsToPay.get(j) + 1);
                thisPaid = true;
                break;
            }
            if (thisPaid) continue;
            return false;
        }
        for (Map.Entry entry : slotsToPay.entrySet()) {
            if ((Integer)entry.getValue() <= this.func_70301_a((Integer)entry.getKey()).func_190916_E()) continue;
            return false;
        }
        for (Map.Entry entry : slotsToPay.entrySet()) {
            this.func_70301_a((Integer)entry.getKey()).func_190918_g(((Integer)entry.getValue()).intValue());
        }
        return true;
    }

    private void sendOutput(ItemStack craftingResult) {
        ArrayList<ItemStack> toDrop = UtilInventoryTransfer.dumpToIInventory(Arrays.asList(craftingResult), this, 19);
        if (!toDrop.isEmpty()) {
            for (ItemStack s : toDrop) {
                UtilItemStack.dropItemStackInWorld(this.func_145831_w(), this.func_174877_v().func_177984_a(), s);
            }
        }
    }

    private void findRecipe() {
        if (this.recipe != null && this.recipe.func_77569_a(this.crafter, this.field_145850_b)) {
            return;
        }
        this.recipe = null;
        List recipes = CraftingManager.func_77594_a().func_77592_b();
        for (IRecipe rec : recipes) {
            try {
                if (rec.func_77570_a() > 9 || !rec.func_77569_a(this.crafter, this.field_145850_b)) continue;
                this.recipe = rec;
                return;
            }
            catch (Exception err) {
                throw new RuntimeException("Caught exception while querying recipe ", err);
            }
        }
    }

    private void setRecipeInput() {
        int gridStart;
        for (int i = gridStart = 10; i < gridStart + 9; ++i) {
            int craftSlot = i - gridStart;
            this.crafter.func_70299_a(craftSlot, this.func_70301_a(i));
        }
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        switch (side) {
            case DOWN: {
                return this.hopperOutput;
            }
            case UP: {
                return this.hopperInput;
            }
        }
        return this.hopperInputfUEL;
    }

    @Override
    public int func_174887_a_(int id) {
        switch (Fields.values()[id]) {
            case REDSTONE: {
                return this.needsRedstone;
            }
            case TIMER: {
                return this.timer;
            }
            case FUEL: {
                return this.getFuelCurrent();
            }
            case FUELMAX: {
                return this.getFuelMax();
            }
        }
        return -1;
    }

    @Override
    public void func_174885_b(int id, int value) {
        switch (Fields.values()[id]) {
            case REDSTONE: {
                this.needsRedstone = value;
                break;
            }
            case TIMER: {
                this.timer = value;
                break;
            }
            case FUEL: {
                this.setFuelCurrent(value);
                break;
            }
            case FUELMAX: {
                this.setFuelMax(value);
                break;
            }
        }
    }

    @Override
    public int func_174890_g() {
        return Fields.values().length;
    }

    @Override
    public void toggleNeedsRedstone() {
        this.func_174885_b(Fields.REDSTONE.ordinal(), (this.needsRedstone + 1) % 2);
    }

    @Override
    public boolean onlyRunIfPowered() {
        return this.needsRedstone == 1;
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.needsRedstone = tagCompound.func_74762_e("redstone");
        this.timer = tagCompound.func_74762_e("Timer");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        tagCompound.func_74768_a("Timer", this.timer);
        tagCompound.func_74768_a("redstone", this.needsRedstone);
        return super.func_189515_b(tagCompound);
    }

    public static enum Fields {
        REDSTONE,
        TIMER,
        FUEL,
        FUELMAX;

    }
}

