/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.component.cyclicwand;

import com.lothrazar.cyclicmagic.component.cyclicwand.ItemCyclicWand;
import com.lothrazar.cyclicmagic.gui.base.InventoryBase;
import com.lothrazar.cyclicmagic.util.UtilItemStack;
import com.lothrazar.cyclicmagic.util.UtilNBT;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;

public class InventoryWand
extends InventoryBase
implements IInventory {
    public static final int INV_SIZE = 18;
    private final ItemStack internalWand;
    private EntityPlayer thePlayer;

    public InventoryWand(EntityPlayer player, ItemStack wand) {
        super(18);
        this.internalWand = wand;
        this.inv = InventoryWand.readFromNBT(wand);
        this.thePlayer = player;
    }

    public EntityPlayer getPlayer() {
        return this.thePlayer;
    }

    public String func_70005_c_() {
        return "Wand Inventory";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return null;
    }

    public int func_70302_i_() {
        return 18;
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.inv.get(index);
    }

    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack stack = this.func_70301_a(slot);
        if (!stack.func_190926_b()) {
            if (stack.func_190916_E() > amount) {
                stack = stack.func_77979_a(amount);
                this.func_70296_d();
            } else {
                this.func_70299_a(slot, ItemStack.field_190927_a);
            }
        }
        return stack;
    }

    public ItemStack func_70304_b(int index) {
        ItemStack stack = this.func_70301_a(index);
        this.func_70299_a(index, ItemStack.field_190927_a);
        return stack;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inv.set(slot, (Object)stack);
        if (!stack.func_190926_b() && stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        this.func_70296_d();
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
        int i;
        for (i = 0; i < this.func_70302_i_(); ++i) {
            if (this.func_70301_a(i).func_190926_b() || this.func_70301_a(i).func_190916_E() != 0) continue;
            this.inv.set(i, (Object)ItemStack.field_190927_a);
        }
        for (i = 0; i < this.thePlayer.field_71071_by.func_70302_i_(); ++i) {
            if (this.thePlayer.field_71071_by.func_70301_a(i).func_190926_b() || this.thePlayer.field_71071_by.func_70301_a(i).func_190916_E() != 0) continue;
            this.thePlayer.field_71071_by.func_70299_a(i, ItemStack.field_190927_a);
        }
        InventoryWand.writeToNBT(this.internalWand, (NonNullList<ItemStack>)this.inv);
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return !(stack.func_77973_b() instanceof ItemCyclicWand) && Block.func_149634_a((Item)stack.func_77973_b()) != Blocks.field_150350_a;
    }

    public static NonNullList<ItemStack> readFromNBT(ItemStack stack) {
        NonNullList inv = NonNullList.func_191197_a((int)18, (Object)ItemStack.field_190927_a);
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemCyclicWand)) {
            return inv;
        }
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagList items = stack.func_77978_p().func_150295_c("ItemInventory", 10);
        for (int i = 0; i < items.func_74745_c(); ++i) {
            NBTTagCompound item = items.func_150305_b(i);
            int slot = item.func_74762_e("Slot");
            if (slot < 0 || slot >= 18) continue;
            inv.set(slot, (Object)UtilNBT.itemFromNBT(item));
        }
        return inv;
    }

    public static void writeToNBT(ItemStack wandStack, NonNullList<ItemStack> theInventory) {
        NBTTagCompound tagcompound = wandStack.func_77978_p();
        NBTTagList items = new NBTTagList();
        for (int i = 0; i < theInventory.size(); ++i) {
            ItemStack stack = (ItemStack)theInventory.get(i);
            if (!stack.func_190926_b() && stack.func_190916_E() == 0) {
                stack = ItemStack.field_190927_a;
            }
            if (stack.func_190926_b()) continue;
            NBTTagCompound itemTags = new NBTTagCompound();
            itemTags.func_74768_a("Slot", i);
            stack.func_77955_b(itemTags);
            items.func_74742_a((NBTBase)itemTags);
        }
        tagcompound.func_74782_a("ItemInventory", (NBTBase)items);
    }

    public static void decrementSlot(ItemStack wand, int itemSlot) {
        NonNullList<ItemStack> invv = InventoryWand.readFromNBT(wand);
        ((ItemStack)invv.get(itemSlot)).func_190918_g(1);
        InventoryWand.writeToNBT(wand, invv);
    }

    public static ItemStack getFromSlot(ItemStack wand, int i) {
        if (i < 0 || i >= 18) {
            return ItemStack.field_190927_a;
        }
        return (ItemStack)InventoryWand.readFromNBT(wand).get(i);
    }

    public static IBlockState getToPlaceFromSlot(ItemStack wand, int i) {
        ItemStack toPlace = InventoryWand.getFromSlot(wand, i);
        if (toPlace != null && toPlace.func_77973_b() != null && Block.func_149634_a((Item)toPlace.func_77973_b()) != Blocks.field_150350_a) {
            Block b = Block.func_149634_a((Item)toPlace.func_77973_b());
            return UtilItemStack.getStateFromMeta(b, toPlace.func_77960_j());
        }
        return null;
    }

    private static boolean isSlotEmpty(NonNullList<ItemStack> inv, int i) {
        ItemStack s = (ItemStack)inv.get(i);
        return s == null || s.func_77973_b() == null || Block.func_149634_a((Item)s.func_77973_b()) == Blocks.field_150350_a;
    }

    public static int calculateSlotCurrent(ItemStack wand) {
        int itemSlot = ItemCyclicWand.BuildType.getSlot(wand);
        int buildType = ItemCyclicWand.BuildType.get(wand);
        NonNullList<ItemStack> inv = InventoryWand.readFromNBT(wand);
        ArrayList<Integer> slotNonEmpty = new ArrayList<Integer>();
        for (int i = 0; i < inv.size(); ++i) {
            if (InventoryWand.isSlotEmpty(inv, i)) continue;
            slotNonEmpty.add(i);
        }
        if (buildType == ItemCyclicWand.BuildType.FIRST.ordinal()) {
            if (((ItemStack)inv.get(itemSlot)).func_190926_b()) {
                Iterator i = slotNonEmpty.iterator();
                while (i.hasNext()) {
                    int trySlot = (Integer)i.next();
                    if (((ItemStack)inv.get(trySlot)).func_190926_b()) continue;
                    itemSlot = trySlot;
                    break;
                }
            }
        } else if (buildType == ItemCyclicWand.BuildType.ROTATE.ordinal()) {
            int i;
            boolean found = false;
            for (i = itemSlot + 1; i < inv.size(); ++i) {
                if (InventoryWand.isSlotEmpty(inv, i)) continue;
                itemSlot = i;
                found = true;
                break;
            }
            if (!found) {
                for (i = 0; i < itemSlot; ++i) {
                    if (InventoryWand.isSlotEmpty(inv, i)) continue;
                    itemSlot = i;
                    found = true;
                    break;
                }
            }
        } else if (buildType == ItemCyclicWand.BuildType.RANDOM.ordinal()) {
            int next;
            Random rand = new Random();
            if (slotNonEmpty.size() > 0 && (next = rand.nextInt(slotNonEmpty.size())) >= 0 && next < slotNonEmpty.size()) {
                itemSlot = (Integer)slotNonEmpty.get(next);
            }
        }
        return itemSlot;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
        int slot = ItemCyclicWand.BuildType.getSlot(this.internalWand);
        if (InventoryWand.getFromSlot(this.internalWand, slot).func_190926_b() || InventoryWand.getToPlaceFromSlot(this.internalWand, slot) == null) {
            ItemCyclicWand.BuildType.setNextSlot(this.internalWand);
        }
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    public boolean func_191420_l() {
        return false;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }
}

