/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.component.disenchanter;

import com.google.common.collect.Maps;
import com.lothrazar.cyclicmagic.block.base.TileEntityBaseMachineInvo;
import com.lothrazar.cyclicmagic.gui.ITileRedstoneToggle;
import com.lothrazar.cyclicmagic.util.UtilItemStack;
import com.lothrazar.cyclicmagic.util.UtilSound;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;

public class TileEntityDisenchanter
extends TileEntityBaseMachineInvo
implements ITileRedstoneToggle,
ITickable {
    public static final int TIMER_FULL = 100;
    public static final int SLOT_INPUT = 0;
    public static final int SLOT_BOTTLE = 1;
    public static final int SLOT_REDSTONE = 2;
    public static final int SLOT_GLOWSTONE = 3;
    public static final int SLOT_BOOK = 4;
    private int needsRedstone = 1;
    private int timer = 100;

    public TileEntityDisenchanter() {
        super(14);
    }

    @Override
    public int[] getFieldOrdinals() {
        return super.getFieldArray(Fields.values().length);
    }

    public void func_73660_a() {
        if (!this.isRunning()) {
            return;
        }
        if (!this.isInputValid()) {
            return;
        }
        this.spawnParticlesAbove();
        --this.timer;
        if (this.timer > 0) {
            return;
        }
        this.timer = 100;
        ItemStack input = this.func_70301_a(0);
        ItemStack eBook = new ItemStack((Item)Items.field_151134_bR);
        LinkedHashMap outEnchants = Maps.newLinkedHashMap();
        Map enchants = EnchantmentHelper.func_82781_a((ItemStack)input);
        Enchantment keyMoved = null;
        Iterator iterator = enchants.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            keyMoved = (Enchantment)entry.getKey();
            outEnchants.put(keyMoved, entry.getValue());
        }
        if (outEnchants.size() == 0 || keyMoved == null) {
            return;
        }
        enchants.remove(keyMoved);
        EnchantmentHelper.func_82782_a((Map)outEnchants, (ItemStack)eBook);
        this.dropStack(eBook);
        if (input.func_77973_b() == Items.field_151134_bR && enchants.size() == 0) {
            this.dropStack(new ItemStack(Items.field_151122_aG));
        } else {
            EnchantmentHelper.func_82782_a((Map)enchants, (ItemStack)input);
            this.dropStack(input);
        }
        this.func_70299_a(0, ItemStack.field_190927_a);
        this.decrStackSize(3);
        this.decrStackSize(2);
        this.decrStackSize(1);
        this.decrStackSize(4);
        UtilSound.playSound(this.field_145850_b, this.field_174879_c, SoundEvents.field_190021_aL, SoundCategory.BLOCKS);
    }

    private void dropStack(ItemStack stack) {
        for (int i = 5; i < this.func_70302_i_(); ++i) {
            if (!this.func_70301_a(i).func_190926_b()) continue;
            this.func_70299_a(i, stack);
            return;
        }
        EntityItem ei = UtilItemStack.dropItemStackInWorld(this.field_145850_b, this.field_174879_c.func_177984_a(), stack);
        ei.func_70024_g(0.0, 1.0, 0.0);
    }

    private boolean isInputValid() {
        return this.func_70301_a(4).func_77973_b() == Items.field_151122_aG && this.func_70301_a(2).func_77973_b() == Items.field_151137_ax && this.func_70301_a(3).func_77973_b() == Items.field_151114_aO && this.func_70301_a(1).func_77973_b() == Items.field_151062_by && !this.func_70301_a(0).func_190926_b();
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        switch (side) {
            case DOWN: {
                return new int[]{5, 6, 7, 8, 9, 10, 11, 12, 13};
            }
            case UP: {
                return new int[]{0};
            }
            case EAST: {
                return new int[]{1};
            }
            case NORTH: {
                return new int[]{2};
            }
            case SOUTH: {
                return new int[]{3};
            }
            case WEST: {
                return new int[]{4};
            }
        }
        return new int[0];
    }

    @Override
    public void toggleNeedsRedstone() {
        int val = this.needsRedstone + 1;
        if (val > 1) {
            val = 0;
        }
        this.func_174885_b(Fields.REDSTONE.ordinal(), val);
    }

    @Override
    public boolean onlyRunIfPowered() {
        return this.needsRedstone == 1;
    }

    @Override
    public int func_174887_a_(int id) {
        switch (Fields.values()[id]) {
            case TIMER: {
                return this.timer;
            }
            case REDSTONE: {
                return this.needsRedstone;
            }
        }
        return -1;
    }

    @Override
    public void func_174885_b(int id, int value) {
        switch (Fields.values()[id]) {
            case TIMER: {
                this.timer = value;
                break;
            }
            case REDSTONE: {
                this.needsRedstone = value;
                break;
            }
        }
    }

    public static enum Fields {
        REDSTONE,
        TIMER;

    }
}

