/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.component.entitydetector;

import com.lothrazar.cyclicmagic.component.entitydetector.ButtonDetector;
import com.lothrazar.cyclicmagic.component.entitydetector.ContainerDetector;
import com.lothrazar.cyclicmagic.component.entitydetector.TileEntityDetector;
import com.lothrazar.cyclicmagic.gui.base.GuiBaseContainer;
import com.lothrazar.cyclicmagic.util.UtilChat;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class GuiDetector
extends GuiBaseContainer {
    static final int GUI_ROWS = 2;
    private TileEntityDetector tile;
    private int leftColX;
    private int sizeY;
    private int limitColX;
    private int[] yRows = new int[3];
    private ButtonDetector greaterLessBtn;
    private ButtonDetector entityBtn;

    public GuiDetector(InventoryPlayer inventoryPlayer, TileEntityDetector tileEntity) {
        super(new ContainerDetector(inventoryPlayer, tileEntity), tileEntity);
        this.tile = tileEntity;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        int id = 1;
        int vButtonSpacing = 12;
        this.sizeY = 58;
        this.leftColX = 28;
        this.limitColX = this.leftColX + 108;
        this.addPatternButtonAt(id++, this.limitColX, this.sizeY - vButtonSpacing, true, TileEntityDetector.Fields.LIMIT);
        this.addPatternButtonAt(id++, this.limitColX, this.sizeY + vButtonSpacing, false, TileEntityDetector.Fields.LIMIT);
        int x = this.leftColX + 40;
        int y = this.sizeY - 5;
        this.greaterLessBtn = this.addPatternButtonAt(id++, x, y, true, TileEntityDetector.Fields.GREATERTHAN, 60, 20);
        this.entityBtn = this.addPatternButtonAt(id++, x, 18, true, TileEntityDetector.Fields.ENTITYTYPE, 60, 20);
        int xOffset = 18;
        int yOffset = 12;
        this.yRows[0] = 30 + yOffset;
        this.addPatternButtonAt(id++, this.leftColX + xOffset, this.yRows[0], true, TileEntityDetector.Fields.RANGEX);
        this.addPatternButtonAt(id++, this.leftColX - xOffset - 4, this.yRows[0], false, TileEntityDetector.Fields.RANGEX);
        this.yRows[1] = this.yRows[0] + yOffset;
        this.addPatternButtonAt(id++, this.leftColX + xOffset, this.yRows[1], true, TileEntityDetector.Fields.RANGEY);
        this.addPatternButtonAt(id++, this.leftColX - xOffset - 4, this.yRows[1], false, TileEntityDetector.Fields.RANGEY);
        this.yRows[2] = this.yRows[1] + yOffset;
        this.addPatternButtonAt(id++, this.leftColX + xOffset, this.yRows[2], true, TileEntityDetector.Fields.RANGEZ);
        this.addPatternButtonAt(id++, this.leftColX - xOffset - 4, this.yRows[2], false, TileEntityDetector.Fields.RANGEZ);
    }

    private ButtonDetector addPatternButtonAt(int id, int x, int y, boolean isUp, TileEntityDetector.Fields f) {
        return this.addPatternButtonAt(id, x, y, isUp, f, 15, 10);
    }

    private ButtonDetector addPatternButtonAt(int id, int x, int y, boolean isUp, TileEntityDetector.Fields f, int w, int h) {
        ButtonDetector btn = new ButtonDetector(this.tile.func_174877_v(), id, this.field_147003_i + x, this.field_147009_r + y, isUp, f, w, h);
        btn.field_146126_j = isUp ? "+" : "-";
        this.field_146292_n.add(btn);
        return btn;
    }

    private void drawFieldAt(int x, int y, TileEntityDetector.Fields f) {
        this.drawFieldAt(x, y, f.ordinal());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void func_146979_b(int mouseX, int mouseY) {
        this.drawFieldAt(this.limitColX + 3, this.sizeY, TileEntityDetector.Fields.LIMIT);
        this.drawFieldAt(this.leftColX, this.yRows[0], TileEntityDetector.Fields.RANGEX);
        this.drawFieldAt(this.leftColX, this.yRows[1], TileEntityDetector.Fields.RANGEY);
        this.drawFieldAt(this.leftColX, this.yRows[2], TileEntityDetector.Fields.RANGEZ);
        TileEntityDetector.EntityType t = this.tile.getEntityType();
        this.entityBtn.field_146126_j = UtilChat.lang("tile.entity_detector." + t.name().toLowerCase());
        int greater = this.tile.getField(TileEntityDetector.Fields.GREATERTHAN);
        String dir = TileEntityDetector.CompareType.values()[greater].name().toLowerCase();
        this.greaterLessBtn.field_146126_j = UtilChat.lang("tile.entity_detector." + dir);
        super.func_146979_b(mouseX, mouseY);
    }
}

