/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.component.entitydetector;

import com.lothrazar.cyclicmagic.component.entitydetector.TileEntityDetector;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketTileDetector
implements IMessage,
IMessageHandler<PacketTileDetector, IMessage> {
    private BlockPos pos;
    private TileEntityDetector.Fields type;
    private int direction;

    public PacketTileDetector() {
    }

    public PacketTileDetector(BlockPos p, boolean up, TileEntityDetector.Fields t) {
        this.pos = p;
        this.type = t;
        this.direction = up ? 1 : -1;
    }

    public void fromBytes(ByteBuf buf) {
        NBTTagCompound tags = ByteBufUtils.readTag((ByteBuf)buf);
        int x = tags.func_74762_e("x");
        int y = tags.func_74762_e("y");
        int z = tags.func_74762_e("z");
        this.pos = new BlockPos(x, y, z);
        this.type = TileEntityDetector.Fields.values()[tags.func_74762_e("type")];
        this.direction = tags.func_74762_e("d");
    }

    public void toBytes(ByteBuf buf) {
        NBTTagCompound tags = new NBTTagCompound();
        tags.func_74768_a("x", this.pos.func_177958_n());
        tags.func_74768_a("y", this.pos.func_177956_o());
        tags.func_74768_a("z", this.pos.func_177952_p());
        tags.func_74768_a("type", this.type.ordinal());
        tags.func_74768_a("d", this.direction);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tags);
    }

    public IMessage onMessage(PacketTileDetector message, MessageContext ctx) {
        EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
        TileEntityDetector tile = (TileEntityDetector)player.func_130014_f_().func_175625_s(message.pos);
        if (tile != null) {
            tile.setField(message.type, tile.getField(message.type) + message.direction);
        }
        return null;
    }
}

