/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.component.entitydetector;

import com.lothrazar.cyclicmagic.block.base.TileEntityBaseMachineInvo;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;

public class TileEntityDetector
extends TileEntityBaseMachineInvo
implements ITickable {
    private int rangeX = 5;
    private int rangeY = 5;
    private int rangeZ = 5;
    private int limitUntilRedstone = 5;
    private boolean isPoweredNow = false;
    private CompareType compType = CompareType.GREATER;
    private EntityType entityType = EntityType.LIVING;
    private static final int MAX_RANGE = 16;

    public TileEntityDetector() {
        super(0);
    }

    @Override
    public int[] getFieldOrdinals() {
        return super.getFieldArray(Fields.values().length);
    }

    public void func_73660_a() {
        World world = this.func_145831_w();
        List entityList = world.func_72872_a(this.getEntityClass(), new AxisAlignedBB(this.func_174877_v(), this.func_174877_v().func_177982_a(1, 1, 1)).func_72314_b((double)this.rangeX, (double)this.rangeY, (double)this.rangeZ));
        int entitiesFound = entityList == null ? 0 : entityList.size();
        boolean trigger = false;
        switch (this.compType) {
            case LESS: {
                trigger = entitiesFound < this.limitUntilRedstone;
                break;
            }
            case GREATER: {
                trigger = entitiesFound > this.limitUntilRedstone;
                break;
            }
            case EQUAL: {
                trigger = entitiesFound == this.limitUntilRedstone;
                break;
            }
        }
        if (this.isPoweredNow != trigger) {
            this.isPoweredNow = trigger;
            IBlockState state = world.func_180495_p(this.func_174877_v());
            world.func_184138_a(this.func_174877_v(), state, state, 3);
            world.func_175685_c(this.func_174877_v(), this.field_145854_h, true);
        }
    }

    private Class<? extends Entity> getEntityClass() {
        switch (this.entityType) {
            case EXP: {
                return EntityXPOrb.class;
            }
            case ITEM: {
                return EntityItem.class;
            }
            case LIVING: {
                return EntityLivingBase.class;
            }
            case PLAYER: {
                return EntityPlayer.class;
            }
        }
        return null;
    }

    @Override
    public boolean isPowered() {
        return this.isPoweredNow;
    }

    @Override
    public int func_174887_a_(int id) {
        return this.getField(Fields.values()[id]);
    }

    @Override
    public void func_174885_b(int id, int value) {
        this.setField(Fields.values()[id], value);
    }

    public int getField(Fields f) {
        switch (f) {
            case ENTITYTYPE: {
                return this.entityType.ordinal();
            }
            case GREATERTHAN: {
                return this.compType.ordinal();
            }
            case LIMIT: {
                return this.limitUntilRedstone;
            }
            case RANGEX: {
                return this.rangeX;
            }
            case RANGEY: {
                return this.rangeY;
            }
            case RANGEZ: {
                return this.rangeZ;
            }
        }
        return 0;
    }

    public void setField(Fields f, int value) {
        if (f == Fields.RANGEX || f == Fields.RANGEY || f == Fields.RANGEZ) {
            if (value > 16) {
                value = 16;
            }
            if (value < 1) {
                value = 1;
            }
        }
        switch (f) {
            case GREATERTHAN: {
                if (value >= CompareType.values().length) {
                    value = 0;
                }
                if (value < 0) {
                    value = CompareType.values().length - 1;
                }
                this.compType = CompareType.values()[value];
                break;
            }
            case LIMIT: {
                if (value > 999) {
                    value = 16;
                }
                if (value < 1) {
                    value = 1;
                }
                this.limitUntilRedstone = value;
                break;
            }
            case RANGEX: {
                this.rangeX = value;
                break;
            }
            case RANGEY: {
                this.rangeY = value;
                break;
            }
            case RANGEZ: {
                this.rangeZ = value;
                break;
            }
            case ENTITYTYPE: {
                if (value >= EntityType.values().length) {
                    value = 0;
                }
                if (value < 0) {
                    value = EntityType.values().length - 1;
                }
                this.entityType = EntityType.values()[value];
                break;
            }
        }
    }

    public EntityType getEntityType() {
        int type = this.getField(Fields.ENTITYTYPE);
        return EntityType.values()[type];
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        int eType;
        super.func_145839_a(tagCompound);
        this.rangeX = tagCompound.func_74762_e("ox");
        this.rangeY = tagCompound.func_74762_e("oy");
        this.rangeZ = tagCompound.func_74762_e("oz");
        this.limitUntilRedstone = tagCompound.func_74762_e("limit");
        int cType = tagCompound.func_74762_e("compare");
        if (cType >= 0 && cType < CompareType.values().length) {
            this.compType = CompareType.values()[cType];
        }
        if ((eType = tagCompound.func_74762_e("et")) >= 0 && eType < EntityType.values().length) {
            this.entityType = EntityType.values()[eType];
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        tagCompound.func_74768_a("ox", this.rangeX);
        tagCompound.func_74768_a("oy", this.rangeY);
        tagCompound.func_74768_a("oz", this.rangeZ);
        tagCompound.func_74768_a("limit", this.limitUntilRedstone);
        tagCompound.func_74768_a("compare", this.compType.ordinal());
        tagCompound.func_74768_a("et", this.entityType.ordinal());
        return super.func_189515_b(tagCompound);
    }

    public static enum CompareType {
        LESS,
        GREATER,
        EQUAL;

    }

    public static enum EntityType {
        LIVING,
        ITEM,
        EXP,
        PLAYER;

    }

    public static enum Fields {
        GREATERTHAN,
        LIMIT,
        RANGEX,
        RANGEY,
        RANGEZ,
        ENTITYTYPE;

    }
}

