/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.component.fisher;

import com.lothrazar.cyclicmagic.block.base.TileEntityBaseMachineInvo;
import com.lothrazar.cyclicmagic.util.UtilItemStack;
import com.lothrazar.cyclicmagic.util.UtilNBT;
import com.lothrazar.cyclicmagic.util.UtilParticle;
import com.lothrazar.cyclicmagic.util.UtilShape;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.item.ItemFishingRod;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.LootTableManager;

public class TileEntityFishing
extends TileEntityBaseMachineInvo
implements ITickable {
    private static final String NBT_INV = "Inventory";
    private static final String NBT_SLOT = "Slot";
    public static final int RODSLOT = 1;
    public static final int FISHSLOTS = 15;
    public static final int MINIMUM_WET_SIDES = 2;
    public static final float SPEEDFACTOR = 8.9E-4f;
    private int toolSlot = 0;
    public ArrayList<Block> waterBoth = new ArrayList();

    public TileEntityFishing() {
        super(16);
        this.waterBoth.add((Block)Blocks.field_150358_i);
        this.waterBoth.add((Block)Blocks.field_150355_j);
    }

    public boolean isValidPosition() {
        return this.countWetSides() >= 2;
    }

    public int countWetSides() {
        int cov = 0;
        List<BlockPos> areas = Arrays.asList(this.field_174879_c.func_177977_b(), this.field_174879_c.func_177978_c(), this.field_174879_c.func_177974_f(), this.field_174879_c.func_177976_e(), this.field_174879_c.func_177968_d(), this.field_174879_c.func_177984_a());
        World world = this.func_145831_w();
        for (BlockPos adj : areas) {
            if (!this.waterBoth.contains(world.func_180495_p(adj).func_177230_c())) continue;
            ++cov;
        }
        return cov;
    }

    public int countWaterFlowing() {
        int cov = 0;
        List<BlockPos> areas = this.getWaterArea();
        World world = this.func_145831_w();
        for (BlockPos adj : areas) {
            if (world.func_180495_p(adj).func_177230_c() != Blocks.field_150358_i) continue;
            ++cov;
        }
        return cov;
    }

    private List<BlockPos> getWaterArea() {
        return UtilShape.cubeFilled(this.func_174877_v().func_177979_c(2), 2, 2);
    }

    public int countWater() {
        int cov = 0;
        List<BlockPos> areas = this.getWaterArea();
        World world = this.func_145831_w();
        for (BlockPos adj : areas) {
            if (world.func_180495_p(adj).func_177230_c() != Blocks.field_150355_j) continue;
            ++cov;
        }
        return cov;
    }

    public boolean isEquipmentValid() {
        String aquaBase;
        ItemStack equip = this.func_70301_a(this.toolSlot);
        if (equip.func_190926_b()) {
            return false;
        }
        if (equip.func_77973_b() instanceof ItemFishingRod) {
            return true;
        }
        String itemsClass = equip.func_77973_b().getClass().getName();
        return itemsClass.equals((aquaBase = "com.teammetallurgy.aquaculture.items.") + "ItemAquacultureWoodenFishingRod") || itemsClass.equals(aquaBase + "ItemAquacultureFishingRod") || itemsClass.equals(aquaBase + "ItemAdminAquacultureFishingRod") || itemsClass.equals(aquaBase + "ItemAdminFishingRod");
    }

    public void func_73660_a() {
        World world = this.func_145831_w();
        Random rand = world.field_73012_v;
        if (rand.nextDouble() < this.getFishSpeed() && this.isValidPosition() && this.isEquipmentValid() && world instanceof WorldServer && world != null && world.func_72820_D() % 20L == 0L) {
            LootContext.Builder lootcontext$builder = new LootContext.Builder((WorldServer)world);
            int luck = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_151370_z, (ItemStack)this.func_70301_a(this.toolSlot));
            lootcontext$builder.func_186469_a((float)luck);
            LootTableManager loot = world.func_184146_ak();
            if (loot == null) {
                return;
            }
            LootTable table = loot.func_186521_a(LootTableList.field_186387_al);
            if (table == null) {
                return;
            }
            LootContext context = lootcontext$builder.func_186471_a();
            if (context == null) {
                return;
            }
            for (ItemStack itemstack : table.func_186462_a(rand, context)) {
                UtilParticle.spawnParticle(world, EnumParticleTypes.WATER_WAKE, this.field_174879_c.func_177984_a());
                int mending = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185296_A, (ItemStack)this.func_70301_a(this.toolSlot));
                if (mending == 0) {
                    this.damageTool();
                } else if (rand.nextDouble() < 0.25) {
                    this.damageTool();
                } else if (rand.nextDouble() < 0.6) {
                    this.attemptRepairTool();
                }
                this.tryAddToInventory(itemstack);
            }
        }
    }

    private void tryAddToInventory(ItemStack itemstack) {
        for (int i = 1; i <= 15; ++i) {
            if (itemstack.func_190926_b() || itemstack.func_77976_d() == 0) continue;
            itemstack = this.tryMergeStackIntoSlot(itemstack, i);
        }
        if (!itemstack.func_190926_b() && itemstack.func_77976_d() != 0) {
            UtilItemStack.dropItemStackInWorld(this.func_145831_w(), this.field_174879_c.func_177977_b(), itemstack);
        }
    }

    public double getFishSpeed() {
        int mult = this.countWaterFlowing() * 4 + this.countWater();
        double randFact = 0.0;
        if (Math.random() > 0.9) {
            randFact = Math.random() / 10000.0;
        }
        return (double)((float)mult * 8.9E-4f) + randFact;
    }

    private void attemptRepairTool() {
        ItemStack equip = this.func_70301_a(this.toolSlot);
        if (!equip.func_190926_b() && equip.func_77952_i() > 0) {
            equip.func_77964_b(equip.func_77952_i() - 1);
        }
    }

    private void damageTool() {
        ItemStack equip = this.func_70301_a(this.toolSlot);
        if (!equip.func_190926_b()) {
            equip.func_96631_a(1, this.func_145831_w().field_73012_v);
            int damageRem = equip.func_77958_k() - equip.func_77952_i();
            if (damageRem == 1 && EnchantmentHelper.func_82781_a((ItemStack)equip).size() > 0) {
                this.tryAddToInventory(equip);
                this.func_70299_a(this.toolSlot, ItemStack.field_190927_a);
            }
            if (equip.func_77952_i() >= equip.func_77958_k()) {
                this.func_70299_a(this.toolSlot, ItemStack.field_190927_a);
            }
        }
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        if (side == EnumFacing.UP) {
            return new int[]{0};
        }
        return new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        NBTTagList tagList = tagCompound.func_150295_c(NBT_INV, 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tag = tagList.func_150305_b(i);
            byte slot = tag.func_74771_c(NBT_SLOT);
            if (slot < 0 || slot >= this.inv.size()) continue;
            this.inv.set(i, (Object)UtilNBT.itemFromNBT(tag));
        }
    }
}

