/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.component.harvester;

import com.lothrazar.cyclicmagic.block.base.TileEntityBaseMachineInvo;
import com.lothrazar.cyclicmagic.gui.ITilePreviewToggle;
import com.lothrazar.cyclicmagic.gui.ITileRedstoneToggle;
import com.lothrazar.cyclicmagic.gui.ITileSizeToggle;
import com.lothrazar.cyclicmagic.util.UtilHarvestCrops;
import com.lothrazar.cyclicmagic.util.UtilInventoryTransfer;
import com.lothrazar.cyclicmagic.util.UtilItemStack;
import com.lothrazar.cyclicmagic.util.UtilParticle;
import com.lothrazar.cyclicmagic.util.UtilShape;
import com.lothrazar.cyclicmagic.util.UtilWorld;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;

public class TileEntityHarvester
extends TileEntityBaseMachineInvo
implements ITileRedstoneToggle,
ITileSizeToggle,
ITilePreviewToggle,
ITickable {
    private static final int MAX_SIZE = 7;
    private int size = 7;
    public static final int TIMER_FULL = 200;
    private UtilHarvestCrops.HarvestSetting conf;
    private int needsRedstone = 1;
    private int renderParticles = 0;
    private static final int[] hopperInputFuel = new int[]{27};
    private static final int[] hopperOUTPUT = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26};

    public TileEntityHarvester() {
        super(28);
        this.setFuelSlot(27);
        this.timer = 200;
        this.conf = new UtilHarvestCrops.HarvestSetting();
        this.conf.doesCrops = true;
        this.conf.doesMushroom = true;
        this.conf.doesPumpkinBlocks = true;
        this.conf.doesMelonBlocks = true;
        this.conf.dropInPlace = false;
    }

    @Override
    public int[] getFieldOrdinals() {
        return super.getFieldArray(Fields.values().length);
    }

    public UtilHarvestCrops.HarvestSetting getHarvestConf() {
        return this.conf;
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.needsRedstone = tagCompound.func_74762_e("redstone");
        this.size = tagCompound.func_74762_e("size");
        this.renderParticles = tagCompound.func_74762_e("render");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        tagCompound.func_74768_a("redstone", this.needsRedstone);
        tagCompound.func_74768_a("size", this.size);
        tagCompound.func_74768_a("render", this.renderParticles);
        return super.func_189515_b(tagCompound);
    }

    public boolean isFuelBurning() {
        return this.timer > 0 && this.timer < 200;
    }

    public void func_73660_a() {
        if (!this.isRunning()) {
            return;
        }
        this.spawnParticlesAbove();
        if (this.updateTimerIsZero()) {
            this.timer = 200;
            this.spawnParticlesAbove();
            BlockPos harvest = this.getTargetPos();
            if (UtilHarvestCrops.harvestSingle(this.func_145831_w(), harvest, this.conf)) {
                this.updateFuelIsBurning();
                UtilParticle.spawnParticle(this.func_145831_w(), EnumParticleTypes.DRAGON_BREATH, harvest);
                if (this.conf.drops != null) {
                    this.setOutputItems(this.conf.drops);
                }
            } else {
                this.timer = 1;
            }
            this.func_70296_d();
        } else {
            this.updateFuelIsBurning();
        }
    }

    private void setOutputItems(List<ItemStack> output) {
        ArrayList<ItemStack> toDrop = UtilInventoryTransfer.dumpToIInventory(output, this, 0, 18);
        if (!toDrop.isEmpty()) {
            for (ItemStack s : toDrop) {
                UtilItemStack.dropItemStackInWorld(this.func_145831_w(), this.func_174877_v().func_177984_a(), s);
            }
        }
    }

    public BlockPos getTargetCenter() {
        return this.func_174877_v().func_177967_a(this.getCurrentFacing(), this.size + 1);
    }

    private BlockPos getTargetPos() {
        return UtilWorld.getRandomPos(this.func_145831_w().field_73012_v, this.getTargetCenter(), this.size);
    }

    @Override
    public int func_174887_a_(int id) {
        switch (Fields.values()[id]) {
            case TIMER: {
                return this.timer;
            }
            case REDSTONE: {
                return this.needsRedstone;
            }
            case SIZE: {
                return this.size;
            }
            case RENDERPARTICLES: {
                return this.renderParticles;
            }
            case FUEL: {
                return this.getFuelCurrent();
            }
            case FUELMAX: {
                return this.getFuelMax();
            }
        }
        return -1;
    }

    @Override
    public void func_174885_b(int id, int value) {
        if (id >= 0 && id < this.func_174890_g()) {
            switch (Fields.values()[id]) {
                case TIMER: {
                    this.timer = value;
                    break;
                }
                case REDSTONE: {
                    this.needsRedstone = value;
                    break;
                }
                case SIZE: {
                    this.size = value;
                    break;
                }
                case RENDERPARTICLES: {
                    this.renderParticles = value % 2;
                    break;
                }
                case FUEL: {
                    this.setFuelCurrent(value);
                    break;
                }
                case FUELMAX: {
                    this.setFuelMax(value);
                    break;
                }
            }
        }
    }

    @Override
    public int func_174890_g() {
        return Fields.values().length;
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        if (side == EnumFacing.DOWN) {
            return hopperOUTPUT;
        }
        return hopperInputFuel;
    }

    @Override
    public void toggleSizeShape() {
        ++this.size;
        if (this.size > 7) {
            this.size = 0;
        }
    }

    @Override
    public void toggleNeedsRedstone() {
        int val = this.needsRedstone + 1;
        if (val > 1) {
            val = 0;
        }
        this.func_174885_b(Fields.REDSTONE.ordinal(), val);
    }

    @Override
    public boolean onlyRunIfPowered() {
        return this.needsRedstone == 1;
    }

    @Override
    public void togglePreview() {
        this.renderParticles = (this.renderParticles + 1) % 2;
    }

    @Override
    public List<BlockPos> getShape() {
        return UtilShape.squareHorizontalHollow(this.getTargetCenter(), this.size);
    }

    @Override
    public boolean isPreviewVisible() {
        return this.func_174887_a_(Fields.RENDERPARTICLES.ordinal()) == 1;
    }

    public static enum Fields {
        TIMER,
        REDSTONE,
        SIZE,
        RENDERPARTICLES,
        FUEL,
        FUELMAX;

    }
}

