/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.component.password;

import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.component.password.TileEntityPassword;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IThreadListener;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketTilePassword
implements IMessage,
IMessageHandler<PacketTilePassword, IMessage> {
    private BlockPos pos;
    private String password;
    private PacketType type = null;

    public PacketTilePassword() {
    }

    public PacketTilePassword(PacketType t, String pword, BlockPos p) {
        this.pos = p;
        this.password = pword;
        this.type = t;
    }

    public void fromBytes(ByteBuf buf) {
        NBTTagCompound tags = ByteBufUtils.readTag((ByteBuf)buf);
        this.type = PacketType.values()[tags.func_74762_e("t")];
        int x = tags.func_74762_e("x");
        int y = tags.func_74762_e("y");
        int z = tags.func_74762_e("z");
        this.pos = new BlockPos(x, y, z);
        this.password = tags.func_74779_i("p");
    }

    public void toBytes(ByteBuf buf) {
        if (this.type == null) {
            this.type = PacketType.PASSTEXT;
        }
        NBTTagCompound tags = new NBTTagCompound();
        tags.func_74768_a("x", this.pos.func_177958_n());
        tags.func_74768_a("y", this.pos.func_177956_o());
        tags.func_74768_a("z", this.pos.func_177952_p());
        tags.func_74768_a("t", this.type.ordinal());
        tags.func_74778_a("p", this.password);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tags);
    }

    public IMessage onMessage(PacketTilePassword message, MessageContext ctx) {
        PacketTilePassword.checkThreadAndEnqueue(message, ctx);
        return null;
    }

    private static void checkThreadAndEnqueue(final PacketTilePassword message, final MessageContext ctx) {
        if (message.type == null) {
            message.type = PacketType.PASSTEXT;
        }
        IThreadListener thread = ModCyclic.proxy.getThreadFromContext(ctx);
        thread.func_152344_a(new Runnable(){

            @Override
            public void run() {
                EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                World world = player.func_130014_f_();
                TileEntityPassword tile = (TileEntityPassword)world.func_175625_s(message.pos);
                if (tile != null) {
                    switch (message.type) {
                        case ACTIVETYPE: {
                            tile.toggleActiveType();
                            break;
                        }
                        case PASSTEXT: {
                            tile.setMyPassword(message.password);
                            break;
                        }
                        case USERSALLOWED: {
                            tile.toggleUserType();
                            break;
                        }
                        case USERCLAIM: {
                            tile.toggleClaimedHash(player);
                        }
                    }
                    tile.func_70296_d();
                    player.func_130014_f_().func_175646_b(message.pos, (TileEntity)tile);
                    IBlockState oldState = world.func_180495_p(message.pos);
                    world.func_184138_a(message.pos, oldState, oldState, 3);
                }
            }
        });
    }

    public static enum PacketType {
        PASSTEXT,
        ACTIVETYPE,
        USERSALLOWED,
        USERCLAIM;

    }
}

