/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.component.pattern;

import com.lothrazar.cyclicmagic.block.base.TileEntityBaseMachineInvo;
import com.lothrazar.cyclicmagic.gui.ITilePreviewToggle;
import com.lothrazar.cyclicmagic.gui.ITileRedstoneToggle;
import com.lothrazar.cyclicmagic.util.UtilItemStack;
import com.lothrazar.cyclicmagic.util.UtilParticle;
import com.lothrazar.cyclicmagic.util.UtilShape;
import com.lothrazar.cyclicmagic.util.UtilSound;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileEntityPatternBuilder
extends TileEntityBaseMachineInvo
implements ITickable,
ITilePreviewToggle,
ITileRedstoneToggle {
    private static final int MAXIMUM = 32;
    private static final String NBT_REDST = "redstone";
    private static final int TIMER_FULL = 20;
    private static final int TIMER_SKIP = 1;
    private int height = 5;
    private int offsetTargetX = -4;
    private int offsetTargetY = 0;
    private int offsetTargetZ = 1;
    private int offsetSourceX = 4;
    private int offsetSourceY = 0;
    private int offsetSourceZ = 1;
    private int sizeRadius = 3;
    private int timer = 1;
    private int needsRedstone = 1;
    private int renderParticles = 1;

    public TileEntityPatternBuilder() {
        super(18);
    }

    @Override
    public int[] getFieldOrdinals() {
        return super.getFieldArray(Fields.values().length);
    }

    @Override
    public int func_174890_g() {
        return Fields.values().length;
    }

    private BlockPos getCenterTarget() {
        return this.func_174877_v().func_177982_a(this.offsetTargetX, this.offsetTargetY, this.offsetTargetZ);
    }

    private BlockPos getCenterSrc() {
        return this.func_174877_v().func_177982_a(this.offsetSourceX, this.offsetSourceY, this.offsetSourceZ);
    }

    private int findSlotForMatch(IBlockState stateToMatch) {
        int slot = -1;
        if (stateToMatch == null || stateToMatch.func_177230_c() == null) {
            return slot;
        }
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            Item itemFromState;
            ItemStack is = this.func_70301_a(i);
            if (UtilItemStack.isEmpty(is) || (itemFromState = Item.func_150898_a((Block)stateToMatch.func_177230_c())) != is.func_77973_b()) continue;
            slot = i;
            break;
        }
        return slot;
    }

    @Override
    public boolean onlyRunIfPowered() {
        return this.needsRedstone == 1;
    }

    public void func_73660_a() {
        if (!this.isRunning()) {
            return;
        }
        --this.timer;
        if (this.timer <= 0) {
            this.timer = 20;
            BlockPos centerSrc = this.getCenterSrc();
            List<BlockPos> shapeSrc = UtilShape.cubeFilled(centerSrc, this.sizeRadius, this.height);
            if (shapeSrc.size() <= 0) {
                return;
            }
            World world = this.func_145831_w();
            int pTarget = world.field_73012_v.nextInt(shapeSrc.size());
            BlockPos posSrc = shapeSrc.get(pTarget);
            int xOffset = posSrc.func_177958_n() - centerSrc.func_177958_n();
            int yOffset = posSrc.func_177956_o() - centerSrc.func_177956_o();
            int zOffset = posSrc.func_177952_p() - centerSrc.func_177952_p();
            BlockPos centerTarget = this.getCenterTarget();
            BlockPos posTarget = centerTarget.func_177982_a(xOffset, yOffset, zOffset);
            if (this.renderParticles == 1) {
                UtilParticle.spawnParticle(this.func_145831_w(), EnumParticleTypes.CRIT_MAGIC, posSrc);
                UtilParticle.spawnParticle(this.func_145831_w(), EnumParticleTypes.CRIT_MAGIC, posTarget);
            }
            if (!world.func_175623_d(posSrc)) {
                IBlockState stateToMatch = world.func_180495_p(posSrc);
                int slot = this.findSlotForMatch(stateToMatch);
                if (slot < 0) {
                    return;
                }
                if (world.func_175623_d(posTarget)) {
                    world.func_175656_a(posTarget, stateToMatch);
                    this.func_70298_a(slot, 1);
                    SoundType type = UtilSound.getSoundFromBlockstate(stateToMatch, world, posTarget);
                    if (type != null && type.func_185841_e() != null) {
                        int dim = this.getDimension();
                        int range = 18;
                        UtilSound.playSoundFromServer(type.func_185841_e(), SoundCategory.BLOCKS, posTarget, dim, range);
                    }
                } else {
                    this.timer = 1;
                }
            } else {
                this.timer = 1;
            }
        }
    }

    public List<BlockPos> getSourceShape() {
        BlockPos centerSrc = this.func_174877_v().func_177982_a(this.offsetSourceX, this.offsetSourceY, this.offsetSourceZ);
        List<BlockPos> shapeSrc = UtilShape.cubeFrame(centerSrc, this.sizeRadius, this.height);
        return shapeSrc;
    }

    public List<BlockPos> getTargetShape() {
        BlockPos centerTarget = this.func_174877_v().func_177982_a(this.offsetTargetX, this.offsetTargetY, this.offsetTargetZ);
        List<BlockPos> shapeTarget = UtilShape.cubeFrame(centerTarget, this.sizeRadius, this.height);
        return shapeTarget;
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17};
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.offsetTargetX = compound.func_74762_e("ox");
        this.offsetTargetY = compound.func_74762_e("oy");
        this.offsetTargetZ = compound.func_74762_e("oz");
        this.offsetSourceX = compound.func_74762_e("sx");
        this.offsetSourceY = compound.func_74762_e("sy");
        this.offsetSourceZ = compound.func_74762_e("sz");
        this.sizeRadius = compound.func_74762_e("r");
        this.height = compound.func_74762_e("height");
        this.timer = compound.func_74762_e("timer");
        this.renderParticles = compound.func_74762_e("render");
        this.needsRedstone = compound.func_74762_e(NBT_REDST);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("ox", this.offsetTargetX);
        compound.func_74768_a("oy", this.offsetTargetY);
        compound.func_74768_a("oz", this.offsetTargetZ);
        compound.func_74768_a("sx", this.offsetSourceX);
        compound.func_74768_a("sy", this.offsetSourceY);
        compound.func_74768_a("sz", this.offsetSourceZ);
        compound.func_74768_a("r", this.sizeRadius);
        compound.func_74768_a("height", this.height);
        compound.func_74768_a("timer", this.timer);
        compound.func_74768_a("render", this.renderParticles);
        compound.func_74768_a(NBT_REDST, this.needsRedstone);
        return super.func_189515_b(compound);
    }

    public int getField(Fields f) {
        switch (f) {
            case OFFTARGX: {
                return this.offsetTargetX;
            }
            case OFFTARGY: {
                return this.offsetTargetY;
            }
            case OFFTARGZ: {
                return this.offsetTargetZ;
            }
            case SIZER: {
                return this.sizeRadius;
            }
            case OFFSRCX: {
                return this.offsetSourceX;
            }
            case OFFSRCY: {
                return this.offsetSourceY;
            }
            case OFFSRCZ: {
                return this.offsetSourceZ;
            }
            case HEIGHT: {
                return this.height;
            }
            case TIMER: {
                return this.timer;
            }
            case REDSTONE: {
                return this.needsRedstone;
            }
            case RENDERPARTICLES: {
                return this.renderParticles;
            }
        }
        return 0;
    }

    public void setField(Fields f, int value) {
        if (value > 32) {
            value = 32;
        }
        switch (f) {
            case OFFTARGX: {
                this.offsetTargetX = value;
                break;
            }
            case OFFTARGY: {
                this.offsetTargetY = value;
                break;
            }
            case OFFTARGZ: {
                this.offsetTargetZ = value;
                break;
            }
            case SIZER: {
                this.sizeRadius = value;
                break;
            }
            case OFFSRCX: {
                this.offsetSourceX = value;
                break;
            }
            case OFFSRCY: {
                this.offsetSourceY = value;
                break;
            }
            case OFFSRCZ: {
                this.offsetSourceZ = value;
                break;
            }
            case HEIGHT: {
                this.height = value;
                break;
            }
            case TIMER: {
                this.timer = value;
                break;
            }
            case REDSTONE: {
                this.needsRedstone = value;
                break;
            }
            case RENDERPARTICLES: {
                this.renderParticles = value;
                break;
            }
        }
    }

    @Override
    public int func_174887_a_(int id) {
        return this.getField(Fields.values()[id]);
    }

    @Override
    public void func_174885_b(int id, int value) {
        this.setField(Fields.values()[id], value);
    }

    public void swapTargetSource() {
        int srcX = this.offsetSourceX;
        int srcY = this.offsetSourceY;
        int srcZ = this.offsetSourceZ;
        this.offsetSourceX = this.offsetTargetX;
        this.offsetSourceY = this.offsetTargetY;
        this.offsetSourceZ = this.offsetTargetZ;
        this.offsetTargetX = srcX;
        this.offsetTargetY = srcY;
        this.offsetTargetZ = srcZ;
    }

    @Override
    public void toggleNeedsRedstone() {
        int val = (this.needsRedstone + 1) % 2;
        this.func_174885_b(Fields.REDSTONE.ordinal(), val);
    }

    @Override
    public void togglePreview() {
        int val = (this.renderParticles + 1) % 2;
        this.func_174885_b(Fields.RENDERPARTICLES.ordinal(), val);
    }

    @Override
    public boolean isPreviewVisible() {
        return this.renderParticles == 1;
    }

    @Override
    public List<BlockPos> getShape() {
        return this.getTargetShape();
    }

    public static enum Fields {
        OFFTARGX,
        OFFTARGY,
        OFFTARGZ,
        SIZER,
        OFFSRCX,
        OFFSRCY,
        OFFSRCZ,
        HEIGHT,
        TIMER,
        REDSTONE,
        RENDERPARTICLES;

    }
}

