/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.component.placer;

import com.lothrazar.cyclicmagic.block.base.BlockBaseFacingOmni;
import com.lothrazar.cyclicmagic.block.base.TileEntityBaseMachineInvo;
import com.lothrazar.cyclicmagic.gui.ITileRedstoneToggle;
import com.lothrazar.cyclicmagic.util.UtilItemStack;
import com.lothrazar.cyclicmagic.util.UtilPlaceBlocks;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;

public class TileEntityPlacer
extends TileEntityBaseMachineInvo
implements ITileRedstoneToggle,
ITickable {
    private static final int buildSpeed = 1;
    public static final int TIMER_FULL = 75;
    private static final String NBT_TIMER = "Timer";
    private static final String NBT_REDST = "redstone";
    private int timer;
    private int[] hopperInput = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    private int needsRedstone = 1;

    public TileEntityPlacer() {
        super(9);
    }

    @Override
    public int[] getFieldOrdinals() {
        return super.getFieldArray(Fields.values().length);
    }

    @Override
    public boolean func_94041_b(int index, ItemStack stack) {
        return Block.func_149634_a((Item)stack.func_77973_b()) != null;
    }

    @Override
    public int func_174887_a_(int id) {
        if (id >= 0 && id < this.func_174890_g()) {
            switch (Fields.values()[id]) {
                case TIMER: {
                    return this.timer;
                }
                case REDSTONE: {
                    return this.needsRedstone;
                }
            }
        }
        return -1;
    }

    @Override
    public void func_174885_b(int id, int value) {
        if (id >= 0 && id < this.func_174890_g()) {
            switch (Fields.values()[id]) {
                case TIMER: {
                    this.timer = value;
                    break;
                }
                case REDSTONE: {
                    this.needsRedstone = value;
                }
            }
        }
    }

    @Override
    public int func_174890_g() {
        return Fields.values().length;
    }

    public int getTimer() {
        return this.func_174887_a_(Fields.TIMER.ordinal());
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.needsRedstone = tagCompound.func_74762_e(NBT_REDST);
        this.timer = tagCompound.func_74762_e(NBT_TIMER);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        tagCompound.func_74768_a(NBT_REDST, this.needsRedstone);
        tagCompound.func_74768_a(NBT_TIMER, this.timer);
        return super.func_189515_b(tagCompound);
    }

    public boolean isFuelBurning() {
        return this.timer > 0 && this.timer < 75;
    }

    public void func_73660_a() {
        Block stuff;
        this.shiftAllUp();
        boolean trigger = false;
        if (!this.isRunning()) {
            this.func_70296_d();
            return;
        }
        this.spawnParticlesAbove();
        ItemStack stack = this.func_70301_a(0);
        if (stack == null) {
            this.timer = 75;
        } else {
            --this.timer;
            if (this.timer <= 0) {
                this.timer = 75;
                trigger = true;
            }
        }
        if (trigger && (stuff = Block.func_149634_a((Item)stack.func_77973_b())) != null && UtilPlaceBlocks.placeStateSafe(this.func_145831_w(), null, this.field_174879_c.func_177972_a(this.getCurrentFacing()), UtilItemStack.getStateFromMeta(stuff, stack.func_77960_j())) && !this.func_145831_w().field_72995_K) {
            this.func_70298_a(0, 1);
        }
        this.func_70296_d();
    }

    @Override
    protected EnumFacing getCurrentFacing() {
        return BlockBaseFacingOmni.getCurrentFacing(this.func_145831_w(), this.func_174877_v());
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        return this.hopperInput;
    }

    @Override
    public boolean func_145842_c(int id, int value) {
        if (id >= 0 && id < this.func_174890_g()) {
            this.func_174885_b(id, value);
            return true;
        }
        return super.func_145842_c(id, value);
    }

    @Override
    public void toggleNeedsRedstone() {
        int val = this.needsRedstone + 1;
        if (val > 1) {
            val = 0;
        }
        this.func_174885_b(Fields.REDSTONE.ordinal(), val);
    }

    @Override
    public boolean onlyRunIfPowered() {
        return this.needsRedstone == 1;
    }

    public static enum Fields {
        TIMER,
        REDSTONE;

    }
}

