/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.component.pylonexp;

import com.lothrazar.cyclicmagic.component.pylonexp.TileEntityXpPylon;
import com.lothrazar.cyclicmagic.util.UtilChat;
import com.lothrazar.cyclicmagic.util.UtilExperience;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketTilePylon
implements IMessage,
IMessageHandler<PacketTilePylon, IMessage> {
    private BlockPos pos;
    private int value;
    private TileEntityXpPylon.Fields type;

    public PacketTilePylon() {
    }

    public PacketTilePylon(BlockPos p, int s, TileEntityXpPylon.Fields spr) {
        this.pos = p;
        this.value = s;
        this.type = spr;
    }

    public void fromBytes(ByteBuf buf) {
        NBTTagCompound tags = ByteBufUtils.readTag((ByteBuf)buf);
        int x = tags.func_74762_e("x");
        int y = tags.func_74762_e("y");
        int z = tags.func_74762_e("z");
        this.pos = new BlockPos(x, y, z);
        this.value = tags.func_74762_e("value");
        this.type = TileEntityXpPylon.Fields.values()[tags.func_74762_e("t")];
    }

    public void toBytes(ByteBuf buf) {
        NBTTagCompound tags = new NBTTagCompound();
        tags.func_74768_a("x", this.pos.func_177958_n());
        tags.func_74768_a("y", this.pos.func_177956_o());
        tags.func_74768_a("z", this.pos.func_177952_p());
        tags.func_74768_a("value", this.value);
        tags.func_74768_a("t", this.type.ordinal());
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tags);
    }

    public IMessage onMessage(PacketTilePylon message, MessageContext ctx) {
        EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
        TileEntityXpPylon tile = (TileEntityXpPylon)player.func_130014_f_().func_175625_s(message.pos);
        if (tile != null) {
            int pylonHas = tile.func_174887_a_(message.type.ordinal());
            int pylonSpace = 20000 - pylonHas;
            if (message.type.ordinal() == TileEntityXpPylon.Fields.EXP.ordinal()) {
                int playerHas = (int)Math.floor(UtilExperience.getExpTotal((EntityPlayer)player));
                int toDeposit = message.value == -1 ? Math.min(playerHas, pylonSpace) : Math.min(message.value, pylonSpace);
                if (pylonHas + toDeposit <= 20000) {
                    if (UtilExperience.drainExp((EntityPlayer)player, toDeposit)) {
                        tile.func_174885_b(message.type.ordinal(), pylonHas + toDeposit);
                    } else {
                        UtilChat.addChatMessage((EntityPlayer)player, "tile.exp_pylon.notenough");
                    }
                } else {
                    UtilChat.addChatMessage((EntityPlayer)player, "tile.exp_pylon.full");
                }
            } else {
                tile.func_174885_b(message.type.ordinal(), pylonHas + message.value);
            }
            tile.func_70296_d();
            if (player.field_71070_bA != null) {
                player.field_71070_bA.func_75142_b();
                player.func_175173_a(player.field_71070_bA, (IInventory)tile);
            }
        }
        return null;
    }
}

