/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.component.pylonexp;

import com.lothrazar.cyclicmagic.block.base.TileEntityBaseMachineInvo;
import com.lothrazar.cyclicmagic.util.UtilItemStack;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;

public class TileEntityXpPylon
extends TileEntityBaseMachineInvo
implements ITickable {
    private static final int XP_PER_SPEWORB = 10;
    private static final int XP_PER_BOTTLE = 11;
    public static final int TIMER_FULL = 18;
    public static final int MAX_EXP_HELD = 20000;
    public static final int SLOT_INPUT = 0;
    public static final int SLOT_OUTPUT = 1;
    private static final String NBT_TIMER = "Timer";
    private static final String NBT_COLLECT = "collect";
    private static final String NBT_SPRAY = "spray";
    private static final String NBT_BOTTLE = "bottle";
    private static final String NBT_EXP = "particles";
    public static final int RADIUS = 5;
    private static final int[] SLOTS_EXTRACT = new int[]{1};
    private static final int[] SLOTS_INSERT = new int[]{0};
    private int timer = 0;
    private int collect = 1;
    private int bottle = 0;
    private int spray = 0;
    private int currentExp = 0;

    public TileEntityXpPylon() {
        super(2);
    }

    @Override
    public int[] getFieldOrdinals() {
        return super.getFieldArray(Fields.values().length);
    }

    public void func_73660_a() {
        if (this.collect == 1) {
            this.updateCollection();
        }
        if (this.bottle == 1) {
            this.updateBottle();
        }
        if (this.spray == 1) {
            this.updateSpew();
        }
    }

    private void updateSpew() {
        --this.timer;
        if (this.timer <= 0) {
            this.timer = 18;
            int amtToSpew = Math.min(10, this.currentExp);
            if (amtToSpew > 0 && this.tryDecrExp(amtToSpew) && !this.func_145831_w().field_72995_K) {
                EntityXPOrb orb = new EntityXPOrb(this.func_145831_w());
                orb.func_70634_a((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5);
                orb.field_70530_e = amtToSpew;
                this.func_145831_w().func_72838_d((Entity)orb);
                this.spewOrb(orb);
            }
        }
    }

    private void updateBottle() {
        --this.timer;
        if (this.timer <= 0) {
            this.timer = 18;
            if (this.outputSlotHasRoom() && this.inputSlotHasSome() && this.tryDecrExp(11)) {
                this.outputSlotIncrement();
                this.inputSlotDecrement();
            }
        }
    }

    private void updateCollection() {
        List orbs = this.func_145831_w().func_72872_a(EntityXPOrb.class, new AxisAlignedBB(this.func_174877_v().func_177984_a()).func_186662_g(5.0));
        if (orbs != null) {
            for (EntityXPOrb orb : orbs) {
                if (!orb.field_70128_L && this.tryIncrExp(orb.func_70526_d())) {
                    this.func_145831_w().func_72900_e((Entity)orb);
                    continue;
                }
                this.spewOrb(orb);
            }
        }
    }

    private void outputSlotIncrement() {
        ItemStack fullOnes = this.func_70301_a(1);
        if (UtilItemStack.isEmpty(fullOnes)) {
            fullOnes = new ItemStack(Items.field_151062_by);
        } else {
            fullOnes.func_190917_f(1);
        }
        this.func_70299_a(1, fullOnes);
    }

    private boolean outputSlotHasRoom() {
        ItemStack fullOnes = this.func_70301_a(1);
        return UtilItemStack.isEmpty(fullOnes) || fullOnes.func_190916_E() < 64;
    }

    private boolean inputSlotHasSome() {
        ItemStack emptyOnes = this.func_70301_a(0);
        return !UtilItemStack.isEmpty(emptyOnes) && emptyOnes.func_190916_E() > 0;
    }

    private void inputSlotDecrement() {
        ItemStack fullOnes = this.func_70301_a(0);
        fullOnes.func_190918_g(1);
        if (fullOnes.func_190916_E() == 0) {
            fullOnes = ItemStack.field_190927_a;
        }
        this.func_70299_a(0, fullOnes);
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        if (side == EnumFacing.DOWN) {
            return SLOTS_EXTRACT;
        }
        return SLOTS_INSERT;
    }

    private boolean tryDecrExp(int xpValue) {
        if (this.currentExp - xpValue < 0) {
            return false;
        }
        this.currentExp -= xpValue;
        return true;
    }

    private boolean tryIncrExp(int xpValue) {
        if (this.currentExp + xpValue > 20000) {
            return false;
        }
        this.currentExp += xpValue;
        return true;
    }

    private void spewOrb(EntityXPOrb orb) {
        orb.func_70024_g(Math.random() / 1000.0, 0.01, Math.random() / 1000.0);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tags) {
        tags.func_74768_a(NBT_TIMER, this.timer);
        tags.func_74768_a(NBT_COLLECT, this.collect);
        tags.func_74768_a(NBT_EXP, this.currentExp);
        tags.func_74768_a(NBT_SPRAY, this.spray);
        tags.func_74768_a(NBT_BOTTLE, this.bottle);
        return super.func_189515_b(tags);
    }

    @Override
    public void func_145839_a(NBTTagCompound tags) {
        super.func_145839_a(tags);
        this.timer = tags.func_74762_e(NBT_TIMER);
        this.collect = tags.func_74762_e(NBT_COLLECT);
        this.currentExp = tags.func_74762_e(NBT_EXP);
        this.spray = tags.func_74762_e(NBT_SPRAY);
        this.bottle = tags.func_74762_e(NBT_BOTTLE);
    }

    private void setExp(int value) {
        this.currentExp = value;
    }

    @Override
    public int func_174890_g() {
        return Fields.values().length;
    }

    @Override
    public int func_174887_a_(int id) {
        switch (Fields.values()[id]) {
            case TIMER: {
                return this.timer;
            }
            case EXP: {
                return this.currentExp;
            }
            case BOTTLE: {
                return this.bottle;
            }
            case COLLECT: {
                return this.collect;
            }
            case SPRAY: {
                return this.spray;
            }
        }
        return -1;
    }

    @Override
    public void func_174885_b(int id, int value) {
        switch (Fields.values()[id]) {
            case TIMER: {
                this.timer = value;
                break;
            }
            case EXP: {
                this.setExp(value);
                break;
            }
            case BOTTLE: {
                this.bottle = value % 2;
                break;
            }
            case COLLECT: {
                this.collect = value % 2;
                break;
            }
            case SPRAY: {
                this.spray = value % 2;
            }
        }
    }

    public static enum Fields {
        TIMER,
        EXP,
        COLLECT,
        SPRAY,
        BOTTLE;

    }
}

