/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.component.storagesack;

import com.lothrazar.cyclicmagic.gui.base.InventoryBase;
import com.lothrazar.cyclicmagic.util.UtilNBT;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;

public class InventoryStorage
extends InventoryBase
implements IInventory {
    public static final int INV_SIZE = 66;
    private final ItemStack internalWand;
    private EntityPlayer thePlayer;

    public InventoryStorage(EntityPlayer player, ItemStack wand) {
        super(66);
        this.internalWand = wand;
        this.inv = InventoryStorage.readFromNBT(this.internalWand);
        this.thePlayer = player;
    }

    public EntityPlayer getPlayer() {
        return this.thePlayer;
    }

    public String func_70005_c_() {
        return "";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return null;
    }

    public int func_70302_i_() {
        return 66;
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.inv.get(index);
    }

    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null) {
            if (stack.func_190916_E() > amount) {
                stack = stack.func_77979_a(amount);
                this.func_70296_d();
            } else {
                this.func_70299_a(slot, null);
            }
        }
        return stack;
    }

    public ItemStack func_70304_b(int index) {
        ItemStack stack = this.func_70301_a(index);
        this.func_70299_a(index, null);
        return stack;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        if (stack == null) {
            stack = ItemStack.field_190927_a;
        }
        this.inv.set(slot, (Object)stack);
        if (!stack.func_190926_b() && stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        this.func_70296_d();
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
        int i;
        for (i = 0; i < this.func_70302_i_(); ++i) {
            if (this.func_70301_a(i).func_190926_b() || this.func_70301_a(i).func_190916_E() != 0) continue;
            this.inv.set(i, (Object)ItemStack.field_190927_a);
        }
        for (i = 0; i < this.thePlayer.field_71071_by.func_70302_i_(); ++i) {
            if (this.thePlayer.field_71071_by.func_70301_a(i).func_190926_b() || this.thePlayer.field_71071_by.func_70301_a(i).func_190916_E() != 0) continue;
            this.thePlayer.field_71071_by.func_70299_a(i, ItemStack.field_190927_a);
        }
        InventoryStorage.writeToNBT(this.internalWand, (NonNullList<ItemStack>)this.inv);
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    public static int countNonEmpty(ItemStack stack) {
        NonNullList<ItemStack> inv = InventoryStorage.readFromNBT(stack);
        int count = 0;
        for (int i = 0; i < inv.size(); ++i) {
            if (((ItemStack)inv.get(i)).func_190926_b()) continue;
            ++count;
        }
        return count;
    }

    public static NonNullList<ItemStack> readFromNBT(ItemStack stack) {
        NonNullList inv = NonNullList.func_191197_a((int)66, (Object)ItemStack.field_190927_a);
        if (stack.func_190926_b()) {
            return inv;
        }
        NBTTagList items = UtilNBT.getItemStackNBT(stack).func_150295_c("ItemInventory", 10);
        for (int i = 0; i < items.func_74745_c(); ++i) {
            NBTTagCompound item = items.func_150305_b(i);
            int slot = item.func_74762_e("Slot");
            if (slot < 0 || slot >= 66) continue;
            inv.set(slot, (Object)UtilNBT.itemFromNBT(item));
        }
        return inv;
    }

    public static void writeToNBT(ItemStack item, NonNullList<ItemStack> theInventory) {
        NBTTagCompound tagcompound = UtilNBT.getItemStackNBT(item);
        NBTTagList items = new NBTTagList();
        for (int i = 0; i < theInventory.size(); ++i) {
            ItemStack stack = (ItemStack)theInventory.get(i);
            if (!stack.func_190926_b() && stack.func_190916_E() == 0) {
                stack = ItemStack.field_190927_a;
            }
            if (stack.func_190926_b()) continue;
            NBTTagCompound itemTags = new NBTTagCompound();
            itemTags.func_74768_a("Slot", i);
            stack.func_77955_b(itemTags);
            items.func_74742_a((NBTBase)itemTags);
        }
        tagcompound.func_74782_a("ItemInventory", (NBTBase)items);
    }

    public static void decrementSlot(ItemStack stack, int itemSlot) {
        NonNullList<ItemStack> invv = InventoryStorage.readFromNBT(stack);
        ((ItemStack)invv.get(itemSlot)).func_190918_g(1);
        if (((ItemStack)invv.get(itemSlot)).func_190916_E() == 0) {
            invv.set(itemSlot, (Object)ItemStack.field_190927_a);
        }
        InventoryStorage.writeToNBT(stack, invv);
    }

    public static ItemStack getFromSlot(ItemStack stack, int i) {
        if (i < 0 || i >= 66) {
            return ItemStack.field_190927_a;
        }
        return (ItemStack)InventoryStorage.readFromNBT(stack).get(i);
    }
}

