/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.component.storagesack;

import com.lothrazar.cyclicmagic.IHasRecipe;
import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.component.storagesack.InventoryStorage;
import com.lothrazar.cyclicmagic.item.base.BaseItem;
import com.lothrazar.cyclicmagic.registry.RecipeRegistry;
import com.lothrazar.cyclicmagic.registry.SoundRegistry;
import com.lothrazar.cyclicmagic.util.UtilChat;
import com.lothrazar.cyclicmagic.util.UtilInventoryTransfer;
import com.lothrazar.cyclicmagic.util.UtilNBT;
import com.lothrazar.cyclicmagic.util.UtilSound;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemStorageBag
extends BaseItem
implements IHasRecipe {
    public ItemStorageBag() {
        this.func_77625_d(1);
    }

    public int func_77626_a(ItemStack stack) {
        return 1;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        int size = InventoryStorage.countNonEmpty(stack);
        tooltip.add(UtilChat.lang("item.storage_bag.tooltip") + size);
        tooltip.add(UtilChat.lang("item.storage_bag.tooltip2") + UtilChat.lang(StorageActionType.getName(stack)));
        super.func_77624_a(stack, playerIn, tooltip, advanced);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        StorageActionType.tickTimeout(stack);
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    @SubscribeEvent
    public void onHit(PlayerInteractEvent.LeftClickBlock event) {
        EntityPlayer player = event.getEntityPlayer();
        ItemStack held = player.func_184586_b(event.getHand());
        if (held != null && held.func_77973_b() == this) {
            World world = event.getWorld();
            TileEntity tile = event.getWorld().func_175625_s(event.getPos());
            if (tile != null && tile instanceof IInventory) {
                int depositType = StorageActionType.get(held);
                if (depositType == StorageActionType.NOTHING.ordinal()) {
                    if (world.field_72995_K) {
                        UtilChat.addChatMessage(player, UtilChat.lang("item.storage_bag.disabled"));
                    }
                    return;
                }
                if (!world.field_72995_K) {
                    NonNullList<ItemStack> inv = InventoryStorage.readFromNBT(held);
                    UtilInventoryTransfer.BagDepositReturn ret = null;
                    if (depositType == StorageActionType.DEPOSIT.ordinal()) {
                        ret = UtilInventoryTransfer.dumpFromListToIInventory(world, (IInventory)tile, inv, false);
                    } else if (depositType == StorageActionType.MERGE.ordinal()) {
                        ret = UtilInventoryTransfer.dumpFromListToIInventory(world, (IInventory)tile, inv, true);
                    }
                    if (ret != null && ret.moved > 0) {
                        InventoryStorage.writeToNBT(held, ret.stacks);
                        UtilChat.addChatMessage(player, UtilChat.lang("item.storage_bag.success") + ret.moved);
                    }
                }
                UtilSound.playSound(player, SoundRegistry.basey);
            } else {
                if (StorageActionType.getTimeout(held) > 0) {
                    return;
                }
                StorageActionType.setTimeout(held);
                event.setCanceled(true);
                UtilSound.playSound(player, player.func_180425_c(), SoundRegistry.dcoin, SoundCategory.PLAYERS);
                if (!player.func_130014_f_().field_72995_K) {
                    StorageActionType.toggle(held);
                    UtilChat.addChatMessage(player, UtilChat.lang(StorageActionType.getName(held)));
                }
            }
        }
    }

    public static ItemStack getPlayerItemIfHeld(EntityPlayer player) {
        ItemStack wand = player.func_184614_ca();
        if (wand == null || !(wand.func_77973_b() instanceof ItemStorageBag)) {
            wand = player.func_184592_cb();
        }
        if (wand == null || !(wand.func_77973_b() instanceof ItemStorageBag)) {
            return null;
        }
        return wand;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        if (!world.field_72995_K) {
            BlockPos pos = player.func_180425_c();
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            player.openGui((Object)ModCyclic.instance, 3, world, x, y, z);
        }
        return super.func_77659_a(world, player, hand);
    }

    public static ItemStack getPlayerBagIfHeld(EntityPlayer player) {
        ItemStack wand = player.func_184614_ca();
        if (wand != null && wand.func_77973_b() instanceof ItemStorageBag) {
            return wand;
        }
        wand = player.func_184592_cb();
        if (wand != null && wand.func_77973_b() instanceof ItemStorageBag) {
            return wand;
        }
        return null;
    }

    @Override
    public IRecipe addRecipe() {
        return RecipeRegistry.addShapedRecipe(new ItemStack((Item)this), "lsl", "ldl", "lrl", Character.valueOf('l'), "leather", Character.valueOf('s'), "string", Character.valueOf('r'), "dustRedstone", Character.valueOf('d'), "ingotGold");
    }

    public static enum StorageActionType {
        NOTHING,
        DEPOSIT,
        MERGE;

        private static final String NBT = "build";
        private static final String NBTTIMEOUT = "timeout";

        public static int getTimeout(ItemStack wand) {
            return UtilNBT.getItemStackNBT(wand).func_74762_e(NBTTIMEOUT);
        }

        public static void setTimeout(ItemStack wand) {
            UtilNBT.getItemStackNBT(wand).func_74768_a(NBTTIMEOUT, 15);
        }

        public static void tickTimeout(ItemStack wand) {
            NBTTagCompound tags = UtilNBT.getItemStackNBT(wand);
            int t = tags.func_74762_e(NBTTIMEOUT);
            if (t > 0) {
                UtilNBT.getItemStackNBT(wand).func_74768_a(NBTTIMEOUT, t - 1);
            }
        }

        public static int get(ItemStack wand) {
            if (wand == null) {
                return 0;
            }
            NBTTagCompound tags = UtilNBT.getItemStackNBT(wand);
            return tags.func_74762_e(NBT);
        }

        public static String getName(ItemStack wand) {
            try {
                NBTTagCompound tags = UtilNBT.getItemStackNBT(wand);
                return "item.storage_bag." + StorageActionType.values()[tags.func_74762_e(NBT)].toString().toLowerCase();
            }
            catch (Exception e) {
                return "item.storage_bag." + NOTHING.toString().toLowerCase();
            }
        }

        public static void toggle(ItemStack wand) {
            NBTTagCompound tags = UtilNBT.getItemStackNBT(wand);
            int type = tags.func_74762_e(NBT);
            if (++type > MERGE.ordinal()) {
                type = NOTHING.ordinal();
            }
            tags.func_74768_a(NBT, type);
            wand.func_77982_d(tags);
        }
    }
}

