/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.component.uncrafter;

import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.block.base.TileEntityBaseMachineInvo;
import com.lothrazar.cyclicmagic.gui.ITileRedstoneToggle;
import com.lothrazar.cyclicmagic.util.UtilInventoryTransfer;
import com.lothrazar.cyclicmagic.util.UtilItemStack;
import com.lothrazar.cyclicmagic.util.UtilSound;
import com.lothrazar.cyclicmagic.util.UtilUncraft;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;

public class TileEntityUncrafter
extends TileEntityBaseMachineInvo
implements ITileRedstoneToggle,
ITickable {
    public static final int SLOT_UNCRAFTME = 0;
    public static final int SLOT_ROWS = 3;
    public static final int SLOT_COLS = 7;
    public static final int TIMER_FULL = 200;
    private int needsRedstone = 1;
    private int[] hopperInput = new int[]{0};
    private int[] hopperInputfUEL = new int[]{22};
    private int[] hopperOutput;

    public TileEntityUncrafter() {
        super(23);
        this.timer = 200;
        this.hopperOutput = new int[21];
        for (int i = 1; i <= 21; ++i) {
            this.hopperOutput[i - 1] = i;
        }
        this.setFuelSlot(22);
    }

    @Override
    public int[] getFieldOrdinals() {
        return super.getFieldArray(Fields.values().length);
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.needsRedstone = tagCompound.func_74762_e("redstone");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        tagCompound.func_74768_a("redstone", this.needsRedstone);
        return super.func_189515_b(tagCompound);
    }

    public void func_73660_a() {
        if (!this.isRunning()) {
            return;
        }
        ItemStack stack = this.func_70301_a(0);
        if (stack.func_190926_b()) {
            return;
        }
        this.spawnParticlesAbove();
        this.updateFuelIsBurning();
        if (this.updateTimerIsZero()) {
            this.timer = 200;
            UtilUncraft.Uncrafter uncrafter = new UtilUncraft.Uncrafter();
            try {
                if (uncrafter.process(stack) == UtilUncraft.UncraftResultType.SUCCESS) {
                    if (!this.func_145831_w().field_72995_K) {
                        ArrayList<ItemStack> uncrafterOutput = uncrafter.getDrops();
                        this.setOutputItems(uncrafterOutput);
                        this.func_70298_a(0, uncrafter.getOutsize());
                    }
                    UtilSound.playSound(this.func_145831_w(), this.func_174877_v(), SoundEvents.field_187635_cQ, SoundCategory.BLOCKS);
                } else {
                    ArrayList<ItemStack> toDrop = new ArrayList<ItemStack>();
                    toDrop.add(stack.func_77946_l());
                    this.setOutputItems(toDrop);
                    if (!this.func_145831_w().field_72995_K) {
                        this.func_70298_a(0, stack.func_190916_E());
                    }
                    UtilSound.playSound(this.func_145831_w(), this.func_174877_v(), SoundEvents.field_187737_v, SoundCategory.BLOCKS);
                }
                this.func_145831_w().func_175704_b(this.func_174877_v(), this.func_174877_v().func_177984_a());
                this.func_70296_d();
            }
            catch (Exception e) {
                ModCyclic.logger.error("Unhandled exception in uncrafting ");
                ModCyclic.logger.error(e.getMessage());
                e.printStackTrace();
            }
        }
    }

    private void setOutputItems(List<ItemStack> output) {
        ArrayList<ItemStack> toDrop = UtilInventoryTransfer.dumpToIInventory(output, this, 1);
        if (!toDrop.isEmpty()) {
            for (ItemStack s : toDrop) {
                UtilItemStack.dropItemStackInWorld(this.func_145831_w(), this.func_174877_v().func_177984_a(), s);
            }
        }
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        if (side == EnumFacing.UP) {
            return this.hopperInput;
        }
        if (side == EnumFacing.DOWN) {
            return this.hopperOutput;
        }
        return this.hopperInputfUEL;
    }

    @Override
    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    @Override
    public int func_174887_a_(int id) {
        switch (Fields.values()[id]) {
            case TIMER: {
                return this.timer;
            }
            case REDSTONE: {
                if (this.needsRedstone != 1 && this.needsRedstone != 0) {
                    this.needsRedstone = 0;
                }
                return this.needsRedstone;
            }
            case FUEL: {
                return this.getFuelCurrent();
            }
            case FUELMAX: {
                return this.getFuelMax();
            }
        }
        return -7;
    }

    @Override
    public void func_174885_b(int id, int value) {
        switch (Fields.values()[id]) {
            case TIMER: {
                this.timer = value;
                break;
            }
            case REDSTONE: {
                if (value != 1 && value != 0) {
                    value = 0;
                }
                this.needsRedstone = value;
                break;
            }
            case FUEL: {
                this.setFuelCurrent(value);
                break;
            }
            case FUELMAX: {
                this.setFuelMax(value);
            }
        }
    }

    @Override
    public int func_174890_g() {
        return Fields.values().length;
    }

    @Override
    public void toggleNeedsRedstone() {
        int val = (this.needsRedstone + 1) % 2;
        this.func_174885_b(Fields.REDSTONE.ordinal(), val);
    }

    @Override
    public boolean onlyRunIfPowered() {
        return this.needsRedstone == 1;
    }

    public static enum Fields {
        TIMER,
        REDSTONE,
        FUEL,
        FUELMAX;

    }
}

