/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.component.vector;

import com.lothrazar.cyclicmagic.block.base.TileEntityBaseMachineInvo;
import com.lothrazar.cyclicmagic.gui.ITileRedstoneToggle;
import net.minecraft.nbt.NBTTagCompound;

public class TileEntityVector
extends TileEntityBaseMachineInvo
implements ITileRedstoneToggle {
    public static final int MAX_ANGLE = 90;
    public static final int MAX_YAW = 360;
    public static final int MAX_POWER = 300;
    public static final int DEFAULT_ANGLE = 45;
    public static final int DEFAULT_YAW = 90;
    public static final int DEFAULT_POWER = 250;
    public static final String NBT_ANGLE = "vectorAngle";
    public static final String NBT_POWER = "vectorPower";
    public static final String NBT_YAW = "vectorYaw";
    public static final String NBT_RED = "redst";
    private int angle = 45;
    private int power = 250;
    private int yaw = 90;
    public static final String NBT_SOUND = "sound";
    private int playSound = 1;
    private int needsRedstone = 0;

    public TileEntityVector() {
        super(0);
    }

    @Override
    public int[] getFieldOrdinals() {
        return super.getFieldArray(Fields.values().length);
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.power = tagCompound.func_74762_e(NBT_POWER);
        this.angle = tagCompound.func_74762_e(NBT_ANGLE);
        this.yaw = tagCompound.func_74762_e(NBT_YAW);
        this.playSound = tagCompound.func_74762_e(NBT_SOUND);
        this.needsRedstone = tagCompound.func_74762_e(NBT_RED);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        tagCompound.func_74768_a(NBT_POWER, this.power);
        tagCompound.func_74768_a(NBT_ANGLE, this.angle);
        tagCompound.func_74768_a(NBT_YAW, this.yaw);
        tagCompound.func_74768_a(NBT_SOUND, this.playSound);
        tagCompound.func_74768_a(NBT_RED, this.needsRedstone);
        return super.func_189515_b(tagCompound);
    }

    public float getActualPower() {
        float actual = (float)this.power / 100.0f;
        return actual;
    }

    public int getPower() {
        return this.power;
    }

    public int getAngle() {
        return this.angle;
    }

    public int getYaw() {
        return this.yaw;
    }

    public boolean playSound() {
        return this.playSound == 1;
    }

    @Override
    public int func_174887_a_(int id) {
        if (id >= 0 && id < this.func_174890_g()) {
            switch (Fields.values()[id]) {
                case ANGLE: {
                    return this.angle;
                }
                case POWER: {
                    return this.power;
                }
                case YAW: {
                    return this.yaw;
                }
                case SOUND: {
                    return this.playSound;
                }
                case REDSTONE: {
                    return this.needsRedstone;
                }
            }
        }
        return -1;
    }

    @Override
    public void func_174885_b(int id, int value) {
        if (id >= 0 && id < this.func_174890_g()) {
            switch (Fields.values()[id]) {
                case ANGLE: {
                    this.angle = Math.min(value, 90);
                    break;
                }
                case POWER: {
                    this.power = Math.min(value, 300);
                    if (this.power > 0) break;
                    this.power = 1;
                    break;
                }
                case YAW: {
                    this.yaw = Math.min(value, 360);
                    break;
                }
                case SOUND: {
                    this.playSound = value;
                }
                case REDSTONE: {
                    this.needsRedstone = value;
                }
            }
        }
    }

    @Override
    public int func_174890_g() {
        return Fields.values().length;
    }

    @Override
    public void toggleNeedsRedstone() {
        int val = this.needsRedstone + 1;
        if (val > 1) {
            val = 0;
        }
        this.func_174885_b(Fields.REDSTONE.ordinal(), val);
    }

    @Override
    public boolean onlyRunIfPowered() {
        return this.needsRedstone == 1;
    }

    public static enum Fields {
        ANGLE,
        POWER,
        YAW,
        SOUND,
        REDSTONE;

    }
}

